/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import java.util.List;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugArrayElementInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataArrayInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;

final class DebugJDIPlsqlTableElement {
    DebugJDIPlsqlTableElement() {
    }

    static String parseTableElement(String name, List keys) {
        int closeParen;
        int openParen = name.indexOf("(");
        if (openParen != -1 && (closeParen = name.indexOf(")", openParen + 1)) == name.length() - 1) {
            String tableName = name.substring(0, openParen);
            String key = name.substring(openParen + 1, closeParen);
            keys.add(key);
            return tableName;
        }
        return null;
    }

    private static DebugDataInfo getTableElementData(DebugDataInfo tableData, String keyToFind) {
        DebugDataObjectInfo objectData;
        DebugDataInfo _valuesFieldData;
        DebugClassInfo classInfo = tableData.getClassInfo();
        String className = classInfo.getName();
        if (className.startsWith("$Oracle.") && tableData instanceof DebugDataObjectInfo && (_valuesFieldData = DebugShared.findFieldData((DebugDataObjectInfo)(objectData = (DebugDataObjectInfo)tableData), (String)"_values", null)) instanceof DebugDataArrayInfo) {
            DebugDataArrayInfo array = (DebugDataArrayInfo)_valuesFieldData;
            int length = array.getArrayCount();
            for (int index = 0; index < length; ++index) {
                DebugDataInfo _valueFieldData;
                String key;
                DebugDataObjectInfo elementObjectData;
                DebugDataInfo _keyFieldData;
                DebugArrayElementInfo element;
                DebugDataInfo elementData;
                DebugArrayElementInfo[] elements = array.getArrayElements(index, 1);
                if (elements == null || elements.length != 1 || !((elementData = (element = elements[0]).getDataInfo()) instanceof DebugDataObjectInfo) || !((_keyFieldData = DebugShared.findFieldData((DebugDataObjectInfo)(elementObjectData = (DebugDataObjectInfo)elementData), (String)"_key", null)) instanceof DebugDataCompositeInfo) || !keyToFind.equals(key = DebugShared.makeCourtesyValue((DebugDataCompositeInfo)((DebugDataCompositeInfo)_keyFieldData))) || (_valueFieldData = DebugShared.findFieldData((DebugDataObjectInfo)elementObjectData, (String)"_value", null)) == null) continue;
                return _valueFieldData;
            }
        }
        return null;
    }

    static DebugVariableInfo getTableElementVariable(DebugVariableInfo[] vars, String tableName, List keys, DebugJDI dj, String name, boolean argument, boolean local) {
        if (keys.size() == 1) {
            String keyToFind = (String)keys.get(0);
            for (DebugVariableInfo var : vars) {
                DebugDataInfo tableData;
                DebugDataInfo tableElementData;
                if (!var.getName().equals(tableName) || (tableElementData = DebugJDIPlsqlTableElement.getTableElementData(tableData = var.getDataInfo(), keyToFind)) == null) continue;
                return new VariableInfo(dj, name, tableElementData, argument, local);
            }
        }
        return null;
    }

    static DebugFieldInfo getTableElementField(DebugFieldInfo[] fields, String tableName, List keys, DebugJDI dj, String name, DebugClassInfo declaringClass, boolean isStatic) {
        if (keys.size() == 1) {
            String keyToFind = (String)keys.get(0);
            for (DebugFieldInfo field : fields) {
                DebugDataInfo tableData;
                DebugDataInfo tableElementData;
                if (!field.getName().equals(tableName) || (tableElementData = DebugJDIPlsqlTableElement.getTableElementData(tableData = field.getDataInfo(), keyToFind)) == null) continue;
                return new FieldInfo(dj, name, tableElementData, declaringClass, isStatic);
            }
        }
        return null;
    }

    static class FieldInfo
    implements DebugFieldInfo {
        private DebugJDI dj;
        private String name;
        private DebugDataInfo dataInfo;
        private DebugClassInfo declaringClass;
        private boolean isStatic;
        private int stoppedCount;

        FieldInfo(DebugJDI dj, String name, DebugDataInfo dataInfo, DebugClassInfo declaringClass, boolean isStatic) {
            this.dj = dj;
            this.name = name;
            this.dataInfo = dataInfo;
            this.declaringClass = declaringClass;
            this.isStatic = isStatic;
            this.stoppedCount = dj.stoppedCount;
        }

        public boolean hasExpired() {
            return this.stoppedCount != this.dj.stoppedCount;
        }

        public DebugClassInfo getClassInfo() {
            return this.dataInfo.getClassInfo();
        }

        public String getGenericSignature() {
            return null;
        }

        public DebugClassInfo getDeclaringClassInfo() {
            return this.declaringClass;
        }

        public boolean isStatic() {
            return this.isStatic;
        }

        public boolean isFinal() {
            return false;
        }

        public String getName() {
            return this.name;
        }

        public int getAccess() {
            return 0;
        }

        public DebugDataInfo getDataInfo() {
            return this.dataInfo;
        }
    }

    static class VariableInfo
    implements DebugVariableInfo {
        private DebugJDI dj;
        private String name;
        private DebugDataInfo dataInfo;
        private boolean argument;
        private boolean local;
        private int stoppedCount;

        VariableInfo(DebugJDI dj, String name, DebugDataInfo dataInfo, boolean argument, boolean local) {
            this.dj = dj;
            this.name = name;
            this.dataInfo = dataInfo;
            this.argument = argument;
            this.local = local;
            this.stoppedCount = dj.stoppedCount;
        }

        public boolean hasExpired() {
            return this.stoppedCount != this.dj.stoppedCount;
        }

        public DebugClassInfo getClassInfo() {
            return this.dataInfo.getClassInfo();
        }

        public String getGenericSignature() {
            return null;
        }

        public String getName() {
            return this.name;
        }

        public boolean isInScope() {
            return true;
        }

        public boolean isArgument() {
            return this.argument;
        }

        public boolean isLocal() {
            return this.local;
        }

        public boolean isReturn() {
            return false;
        }

        public boolean isReturned() {
            return false;
        }

        public DebugDataInfo getDataInfo() {
            return this.dataInfo;
        }

        public int getSlotSize() {
            return 1;
        }
    }
}

