/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.transform;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Vector;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.xmlsec.c14n.StreamingC14NImpl;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.transform.EbxmlXPathFilter;
import oracle.security.xmlsec.transform.NodeFilterTransform;
import oracle.security.xmlsec.transform.NodeToStreamTransform;
import oracle.security.xmlsec.transform.TransformationException;
import oracle.security.xmlsec.transform.XPathFilter;
import oracle.security.xmlsec.util.DSIGInitializer;
import oracle.security.xmlsec.util.FilteredNodeReader;
import oracle.security.xmlsec.util.NodeReader;
import oracle.security.xmlsec.util.NodeReaderForSubtree;
import oracle.security.xmlsec.util.URIManager;
import oracle.security.xmlsec.util.XMLContainer;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.util.XPathException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class XSTransformer {
    private static final boolean debug = System.getProperty("xml.debug.trans") != null;
    protected XSAlgorithmIdentifier transform;

    protected XSTransformer() {
    }

    protected XSTransformer(XSAlgorithmIdentifier trans) throws IllegalArgumentException {
        if (!"Transform".equals(trans.getLocalName()) && !"Transform".equals(trans.getTagName())) {
            throw new IllegalArgumentException("Transform element required");
        }
        this.transform = trans;
    }

    public XSAlgorithmIdentifier getTransform() {
        return this.transform;
    }

    public abstract XMLContainer transform(XMLContainer var1) throws TransformationException;

    public abstract String getAlgorithmURI();

    public static XSTransformer getInstance(XSAlgorithmIdentifier trans) throws AlgorithmIdentifierException, IllegalArgumentException {
        if (!"Transform".equals(trans.getLocalName()) && !"Transform".equals(trans.getTagName())) {
            throw new IllegalArgumentException("Transform element required");
        }
        try {
            Class c = URIManager.getURIManager().getClassForURI(trans.getAlgorithm(), "transformer");
            if (c == null) {
                throw new AlgorithmIdentifierException("Unknown Transform algorithm URI " + trans.getAlgorithm());
            }
            try {
                Constructor x = c.getConstructor(XSAlgorithmIdentifier.class);
                return (XSTransformer)x.newInstance(trans);
            }
            catch (NoSuchMethodException x) {
                return (XSTransformer)c.newInstance();
            }
        }
        catch (ClassNotFoundException ex) {
            AlgorithmIdentifierException ai = new AlgorithmIdentifierException();
            ai.initCause((Throwable)ex);
            throw ai;
        }
        catch (SecurityException ex) {
            AlgorithmIdentifierException ai = new AlgorithmIdentifierException();
            ai.initCause((Throwable)ex);
            throw ai;
        }
        catch (InstantiationException ex) {
            AlgorithmIdentifierException ai = new AlgorithmIdentifierException();
            ai.initCause((Throwable)ex);
            throw ai;
        }
        catch (IllegalAccessException ex) {
            AlgorithmIdentifierException ai = new AlgorithmIdentifierException();
            ai.initCause((Throwable)ex);
            throw ai;
        }
        catch (InvocationTargetException ex) {
            AlgorithmIdentifierException ai = new AlgorithmIdentifierException();
            ai.initCause((Throwable)ex);
            throw ai;
        }
    }

    public static XSTransformer getInstance(String uri) throws AlgorithmIdentifierException {
        try {
            Class c = URIManager.getURIManager().getClassForURI(uri, "transformer");
            if (c == null) {
                throw new AlgorithmIdentifierException("Unknown algorithm URI " + uri);
            }
            return (XSTransformer)c.newInstance();
        }
        catch (ClassNotFoundException ex) {
            throw new AlgorithmIdentifierException(ex.toString());
        }
        catch (SecurityException ex) {
            throw new AlgorithmIdentifierException(ex.toString());
        }
        catch (InstantiationException ex) {
            throw new AlgorithmIdentifierException(ex.toString());
        }
        catch (IllegalAccessException ex) {
            throw new AlgorithmIdentifierException(ex.toString());
        }
    }

    public static XMLContainer applyTransforms(XMLContainer source, Vector transformList) throws TransformationException {
        if (debug) {
            System.err.println("\n+++ XSTransformer.applyTransforms():");
        }
        int maxTrans = XMLUtils.getMaxTrans();
        int numTrans = transformList.size();
        if (numTrans > maxTrans && !XMLUtils.getAllowAllFlag()) {
            throw new TransformationException("Number of transformation:" + numTrans + " cannot bigger then the limit number:" + maxTrans + ". Be cautious of the DOS attack! (or change the JVM variable:" + "osdt.max.transforms" + " to accept a different number of transformation.)");
        }
        XMLContainer src = source;
        XMLContainer res = null;
        if (src == null) {
            return new XMLContainer();
        }
        ArrayList<XSTransformer> transformers = new ArrayList<XSTransformer>();
        try {
            boolean useXSLT = XMLUtils.getXSLTFlag();
            int n = transformList.size();
            for (int i = 0; i < n; ++i) {
                XSAlgorithmIdentifier transform = (XSAlgorithmIdentifier)transformList.elementAt(i);
                if (transform.getAlgorithm().equals("http://www.w3.org/TR/1999/REC-xslt-19991116") && !XMLUtils.getAllowAllFlag() && !useXSLT) {
                    throw new TransformationException("XSLT transformation cannot be used by default.To use it, change the JVM variable osdt.allow.XSLTTransform to true, but be aware of security risks by using XSLT transform");
                }
                XSTransformer tran = XSTransformer.getInstance(transform);
                if (tran instanceof XPathFilter && EbxmlXPathFilter.isEbXMLFilter((XPathFilter)tran)) {
                    tran = new EbxmlXPathFilter((XPathFilter)tran);
                }
                transformers.add(tran);
            }
        }
        catch (AlgorithmIdentifierException ex) {
            throw new TransformationException(ex.toString());
        }
        if (XSTransformer.isStreamable(source, transformers)) {
            return XSTransformer.applyStreamingTransforms(source, transformers);
        }
        if (transformList.size() > 0) {
            int n = transformers.size();
            for (int i = 0; i < n; ++i) {
                XSTransformer tran = (XSTransformer)transformers.get(i);
                long start = 0L;
                if (debug) {
                    System.err.println("dsig:Transform: " + tran.getAlgorithmURI());
                    System.err.print("    Time = ");
                    start = System.currentTimeMillis();
                }
                res = tran.transform(src);
                if (debug) {
                    long time = System.currentTimeMillis() - start;
                    System.err.println(String.valueOf(time) + " ms");
                }
                src = res;
            }
        } else {
            try {
                res = src.subTreeAvailable() ? new XMLContainer(src.getSubTree()) : (src.nodeSetAvailable() ? new XMLContainer(src.getNodeSet()) : (src.octetsAvailable() ? new XMLContainer(src.getOctetStream()) : new XMLContainer()));
                res.setWithComments(src.getWithComments());
            }
            catch (IOException iOException) {
            }
            catch (SAXException sAXException) {
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
            res.setSystemId(src.getSystemId());
        }
        return res;
    }

    private static boolean isStreamable(XMLContainer source, ArrayList transformers) {
        boolean C14N_NS_FILTERED_OUT;
        if (!source.subTreeAvailable()) {
            return false;
        }
        boolean bl = C14N_NS_FILTERED_OUT = System.getProperty("osdt.c14nNsFilteredOut") != null;
        if (C14N_NS_FILTERED_OUT) {
            return false;
        }
        int n = transformers.size();
        XSTransformer tran = null;
        for (int i = 0; i < n; ++i) {
            tran = (XSTransformer)transformers.get(i);
            if (i < n - 1 && !(tran instanceof NodeFilterTransform)) {
                return false;
            }
            if (i != n - 1 || tran instanceof NodeFilterTransform || tran instanceof NodeToStreamTransform) continue;
            return false;
        }
        return true;
    }

    private static XMLContainer applyStreamingTransforms(XMLContainer source, ArrayList transformers) throws TransformationException {
        try {
            InputStream is;
            int n = transformers.size();
            XSTransformer tran = null;
            Node subtree = source.getSubTree();
            NodeReader nReader = new NodeReaderForSubtree(subtree);
            for (int i = 0; i < n; ++i) {
                tran = (XSTransformer)transformers.get(i);
                if (!(tran instanceof NodeFilterTransform)) continue;
                nReader = new FilteredNodeReader(nReader, (NodeFilterTransform)((Object)tran));
            }
            if (n > 0 && tran instanceof NodeToStreamTransform) {
                is = ((NodeToStreamTransform)((Object)tran)).transformToStream(nReader);
            } else {
                StreamingC14NImpl.StreamingInclusiveC14NImpl c14n = new StreamingC14NImpl.StreamingInclusiveC14NImpl();
                is = c14n.canonicalizeToStream(nReader);
            }
            XMLContainer res = new XMLContainer(is);
            return res;
        }
        catch (SAXException ex) {
            throw new TransformationException(ex);
        }
        catch (IOException ex) {
            throw new TransformationException(ex);
        }
    }

    static {
        DSIGInitializer.initialize();
    }
}

