/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.keys;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import oracle.security.crypto.util.Utils;
import oracle.security.xmlsec.keys.KeyValueData;
import oracle.security.xmlsec.util.Base64;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RSAKeyValue
extends XMLElement
implements KeyValueData {
    public RSAKeyValue(Element element) throws DOMException {
        super(element);
    }

    public RSAKeyValue(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    RSAKeyValue(Document owner) throws DOMException {
        super(owner, "http://www.w3.org/2000/09/xmldsig#", "RSAKeyValue");
    }

    RSAKeyValue(Document owner, RSAPublicKey rsaKey) throws DOMException {
        this(owner, rsaKey.getModulus(), rsaKey.getPublicExponent());
    }

    RSAKeyValue(Document owner, BigInteger modulus, BigInteger exponent) throws DOMException {
        this(owner);
        this.setModulus(modulus);
        this.setExponent(exponent);
    }

    public void setModulus(BigInteger modulus) throws DOMException {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Modulus");
        for (int i = nList.getLength(); i > 0; --i) {
            this.removeChild(nList.item(i - 1));
        }
        Element m = this.getOwnerDocument().createElementNS("http://www.w3.org/2000/09/xmldsig#", "Modulus");
        XMLUtils.copyNSPrefix((Element)this.node, m);
        m.appendChild(this.getOwnerDocument().createTextNode(Base64.toBase64WithLFSeparator(Utils.toByteArray((BigInteger)modulus))));
        nList = this.getChildNodes();
        if (nList.getLength() != 0) {
            this.insertBefore(m, nList.item(0));
        } else {
            this.appendChild(m);
        }
    }

    public BigInteger getModulus() {
        String mString;
        BigInteger modulus = null;
        NodeList mList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Modulus");
        if (mList.getLength() != 0 && (mString = XMLUtils.collectText(mList.item(0))).length() != 0) {
            modulus = new BigInteger(1, Base64.fromBase64(mString));
        }
        return modulus;
    }

    public void setExponent(BigInteger exponent) throws DOMException {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Exponent");
        for (int i = nList.getLength(); i > 0; --i) {
            this.removeChild(nList.item(i - 1));
        }
        Element e = this.getOwnerDocument().createElementNS("http://www.w3.org/2000/09/xmldsig#", "Exponent");
        XMLUtils.copyNSPrefix((Element)this.node, e);
        e.appendChild(this.getOwnerDocument().createTextNode(Base64.toBase64WithLFSeparator(Utils.toByteArray((BigInteger)exponent))));
        this.appendChild(e);
    }

    public BigInteger getExponent() {
        String eString;
        BigInteger exponent = null;
        NodeList eList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Exponent");
        if (eList.getLength() != 0 && (eString = XMLUtils.collectText(eList.item(0))).length() != 0) {
            exponent = new BigInteger(1, Base64.fromBase64(eString));
        }
        return exponent;
    }

    @Override
    public PublicKey getPublicKey() {
        try {
            KeyFactory dsakf = KeyFactory.getInstance("RSA");
            return dsakf.generatePublic(new RSAPublicKeySpec(this.getModulus(), this.getExponent()));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getType() {
        return "http://www.w3.org/2000/09/xmldsig#RSAKeyValue";
    }
}

