/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.keys;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.util.Utils;
import oracle.security.xmlsec.keys.KeyValueData;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ECDSAKeyValue
extends XMLElement
implements KeyValueData {
    public static final ASN1ObjectID primeCurve = new ASN1ObjectID(new int[]{1, 2, 840, 10045, 3, 1});
    public static final ASN1ObjectID secgCurve = new ASN1ObjectID(new int[]{1, 3, 132, 0});
    public static ASN1ObjectID ansiX9p192r1 = new ASN1ObjectID(primeCurve, 1);
    public static ASN1ObjectID ansiX9t163k1 = new ASN1ObjectID(secgCurve, 1);
    public static ASN1ObjectID ansiX9t163r2 = new ASN1ObjectID(secgCurve, 15);
    public static ASN1ObjectID ansiX9p224r1 = new ASN1ObjectID(secgCurve, 33);
    public static ASN1ObjectID ansiX9t233k1 = new ASN1ObjectID(secgCurve, 26);
    public static ASN1ObjectID ansiX9t233r1 = new ASN1ObjectID(secgCurve, 27);
    public static ASN1ObjectID ansiX9p256r1 = new ASN1ObjectID(primeCurve, 7);
    public static ASN1ObjectID ansiX9t283k1 = new ASN1ObjectID(secgCurve, 16);
    public static ASN1ObjectID ansiX9t283r1 = new ASN1ObjectID(secgCurve, 17);
    public static ASN1ObjectID ansiX9p384r1 = new ASN1ObjectID(secgCurve, 34);
    public static ASN1ObjectID ansiX9t409k1 = new ASN1ObjectID(secgCurve, 36);
    public static ASN1ObjectID ansiX9t409r1 = new ASN1ObjectID(secgCurve, 37);
    public static ASN1ObjectID ansiX9p521r1 = new ASN1ObjectID(secgCurve, 35);
    public static ASN1ObjectID ansiX9t571k1 = new ASN1ObjectID(secgCurve, 38);
    public static ASN1ObjectID ansiX9t571r1 = new ASN1ObjectID(secgCurve, 39);
    public static final HashMap<String, ECParameterSpec> namedCurves = new HashMap();
    static ECParameterSpec P256;
    static ECParameterSpec P384;
    static ECParameterSpec P521;

    public ECDSAKeyValue(Document owner, String systemId) throws DOMException {
        super(owner, "http://www.w3.org/2001/04/xmldsig-more#", "ECDSAKeyValue", systemId);
        this.addNSPrefixAttrDefault("http://www.w3.org/2001/04/xmldsig-more#");
    }

    public ECDSAKeyValue(Document owner) throws DOMException {
        super(owner, "http://www.w3.org/2001/04/xmldsig-more#", "ECDSAKeyValue");
        this.addNSPrefixAttrDefault("http://www.w3.org/2001/04/xmldsig-more#");
    }

    public ECDSAKeyValue(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public ECDSAKeyValue(Element element) throws DOMException {
        super(element);
    }

    @Override
    public PublicKey getPublicKey() {
        ECPublicKeySpec keySpec = new ECPublicKeySpec(new ECPoint(this.getX(), this.getY()), this.getCurve());
        try {
            KeyFactory kf = KeyFactory.getInstance("ECDSA");
            return kf.generatePublic(keySpec);
        }
        catch (InvalidKeySpecException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public ECDSAKeyValue(Document owner, ECPublicKey ecKey) {
        this(owner);
        Node nextChild = null;
        Node n = this.getFirstChild();
        while (n != null) {
            nextChild = n.getNextSibling();
            this.removeChild(n);
            n = nextChild;
        }
        EllipticCurve eCurve = ecKey.getParams().getCurve();
        for (String urn : namedCurves.keySet()) {
            ECParameterSpec nc = namedCurves.get(urn);
            if (eCurve.getField().getFieldSize() != nc.getCurve().getField().getFieldSize() || !eCurve.getField().equals(nc.getCurve().getField())) continue;
            Element domainParameters = this.getOwnerDocument().createElementNS("http://www.w3.org/2001/04/xmldsig-more#", "DomainParameters");
            XMLUtils.copyNSPrefix((Element)this.node, domainParameters);
            this.appendChild(domainParameters);
            Element namedCurve = this.getOwnerDocument().createElementNS("http://www.w3.org/2001/04/xmldsig-more#", "NamedCurve");
            XMLUtils.copyNSPrefix((Element)this.node, namedCurve);
            domainParameters.appendChild(namedCurve);
            namedCurve.setAttribute("URN", urn);
            break;
        }
        Element publicKey = this.getOwnerDocument().createElementNS("http://www.w3.org/2001/04/xmldsig-more#", "PublicKey");
        XMLUtils.copyNSPrefix((Element)this.node, publicKey);
        this.appendChild(publicKey);
        Element x = this.getOwnerDocument().createElementNS("http://www.w3.org/2001/04/xmldsig-more#", "X");
        XMLUtils.copyNSPrefix((Element)this.node, x);
        publicKey.appendChild(x);
        x.setAttribute("Value", ecKey.getW().getAffineX().toString());
        Element y = this.getOwnerDocument().createElementNS("http://www.w3.org/2001/04/xmldsig-more#", "Y");
        XMLUtils.copyNSPrefix((Element)this.node, y);
        publicKey.appendChild(y);
        y.setAttribute("Value", ecKey.getW().getAffineY().toString());
    }

    @Override
    public String getType() {
        return "http://www.w3.org/2001/04/xmldsig-more#ECDSAKeyValue";
    }

    public BigInteger getX() {
        Element publicKey = (Element)this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmldsig-more#", "PublicKey").item(0);
        Element X = (Element)XMLElement.getChildElementsByTagNameNS(publicKey, "http://www.w3.org/2001/04/xmldsig-more#", "X").item(0);
        return new BigInteger(X.getAttribute("Value"));
    }

    public BigInteger getY() {
        Element publicKey = (Element)this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmldsig-more#", "PublicKey").item(0);
        Element Y = (Element)XMLElement.getChildElementsByTagNameNS(publicKey, "http://www.w3.org/2001/04/xmldsig-more#", "Y").item(0);
        return new BigInteger(Y.getAttribute("Value"));
    }

    public ECParameterSpec getCurve() {
        Element domainParameters = (Element)this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmldsig-more#", "DomainParameters").item(0);
        Element namedCurve = (Element)XMLElement.getChildElementsByTagNameNS(domainParameters, "http://www.w3.org/2001/04/xmldsig-more#", "NamedCurve").item(0);
        String urn = namedCurve.getAttribute("URN");
        return namedCurves.get(urn);
    }

    static {
        BigInteger p = new BigInteger("115792089210356248762697446949407573530086143415290314195533631308867097853951");
        BigInteger b = new BigInteger("5ac635d8aa3a93e7b3ebbd55769886bc651d06b0cc53b0f63bce3c3e27d2604b", 16);
        BigInteger a = p.subtract(new BigInteger("3"));
        byte[] seed = Utils.fromHexString((String)"c49d360886e704936a6678e1139d26b7819f7e90");
        EllipticCurve P256curve = new EllipticCurve(new ECFieldFp(p), a, b, seed);
        BigInteger Gx = new BigInteger("6b17d1f2e12c4247f8bce6e563a440f277037d812deb33a0f4a13945d898c296", 16);
        BigInteger Gy = new BigInteger("4fe342e2fe1a7f9b8ee7eb4a7c0f9e162bce33576b315ececbb6406837bf51f5", 16);
        BigInteger n = new BigInteger("115792089210356248762697446949407573529996955224135760342422259061068512044369");
        P256 = new ECParameterSpec(P256curve, new ECPoint(Gx, Gy), n, 1);
        namedCurves.put("urn:oid:" + ansiX9p256r1.toStringCompact(), P256);
        p = new BigInteger("39402006196394479212279040100143613805079739270465446667948293404245721771496870329047266088258938001861606973112319");
        b = new BigInteger("b3312fa7e23ee7e4988e056be3f82d19181d9c6efe8141120314088f5013875ac656398d8a2ed19d2a85c8edd3ec2aef", 16);
        a = p.subtract(new BigInteger("3"));
        seed = Utils.fromHexString((String)"a335926aa319a27a1d00896a6773a4827acdac73");
        EllipticCurve P384curve = new EllipticCurve(new ECFieldFp(p), a, b, seed);
        Gx = new BigInteger("aa87ca22be8b05378eb1c71ef320ad746e1d3b628ba79b9859f741e082542a385502f25dbf55296c3a545e3872760ab7", 16);
        Gy = new BigInteger("3617de4a96262c6f5d9e98bf9292dc29f8f41dbd289a147ce9da3113b5f0b8c00a60b1ce1d7e819d7a431d7c90ea0e5f", 16);
        n = new BigInteger("39402006196394479212279040100143613805079739270465446667946905279627659399113263569398956308152294913554433653942643");
        P384 = new ECParameterSpec(P384curve, new ECPoint(Gx, Gy), n, 1);
        namedCurves.put("urn:oid:" + ansiX9p384r1.toStringCompact(), P384);
        p = new BigInteger("6864797660130609714981900799081393217269435300143305409394463459185543183397656052122559640661454554977296311391480858037121987999716643812574028291115057151");
        b = new BigInteger("051953eb9618e1c9a1f929a21a0b68540eea2da725b99b315f3b8b489918ef109e156193951ec7e937b1652c0bd3bb1bf073573df883d2c34f1ef451fd46b503f00", 16);
        a = p.subtract(new BigInteger("3"));
        seed = Utils.fromHexString((String)"d09e8800291cb85396cc6717393284aaa0da64ba");
        EllipticCurve P521curve = new EllipticCurve(new ECFieldFp(p), a, b, seed);
        Gx = new BigInteger("c6858e06b70404e9cd9e3ecb662395b4429c648139053fb521f828af606b4d3dbaa14b5e77efe75928fe1dc127a2ffa8de3348b3c1856a429bf97e7e31c2e5bd66", 16);
        Gy = new BigInteger("11839296a789a3bc0045c8a5fb42c7d1bd998f54449579b446817afbd17273e662c97ee72995ef42640c550b9013fad0761353c7086a272c24088be94769fd16650", 16);
        n = new BigInteger("6864797660130609714981900799081393217269435300143305409394463459185543183397655394245057746333217197532963996371363321113864768612440380340372808892707005449");
        P521 = new ECParameterSpec(P521curve, new ECPoint(Gx, Gy), n, 1);
        namedCurves.put("urn:oid:" + ansiX9p521r1.toStringCompact(), P521);
    }
}

