/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.enc;

import java.util.Vector;
import oracle.security.xmlsec.dsig.Referable;
import oracle.security.xmlsec.enc.XEEncryptionProperty;
import oracle.security.xmlsec.util.XMLElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XEEncryptionProperties
extends XMLElement
implements Referable {
    public XEEncryptionProperties(Element encProps) throws DOMException {
        super(encProps);
    }

    public XEEncryptionProperties(Element encProps, String systemId) throws DOMException {
        super(encProps, systemId);
    }

    XEEncryptionProperties(Document doc) throws DOMException {
        super(doc, "http://www.w3.org/2001/04/xmlenc#", "EncryptionProperties");
    }

    XEEncryptionProperties(Document doc, String id) throws DOMException {
        this(doc);
        if (id != null) {
            this.setId(id);
        }
    }

    @Override
    public void setId(String id) throws DOMException {
        this.setAttribute("Id", id);
    }

    @Override
    public String getId() {
        if (this.hasAttribute("Id")) {
            return this.getAttribute("Id");
        }
        return null;
    }

    public void addEncryptionProperty(XEEncryptionProperty property) throws DOMException {
        this.appendChild(property);
    }

    public Vector getEncryptionProperties() {
        Vector<XEEncryptionProperty> v = new Vector<XEEncryptionProperty>();
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionProperty");
        int len = nodes.getLength();
        for (int i = 0; i < len; ++i) {
            v.addElement(new XEEncryptionProperty((Element)nodes.item(i), this.systemId));
        }
        return v;
    }

    @Override
    public String getType() {
        return "http://www.w3.org/2001/04/xmlenc#EncryptionProperties";
    }
}

