/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.enc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;
import oracle.security.xmlsec.enc.XECipherReference;
import oracle.security.xmlsec.util.Base64;
import oracle.security.xmlsec.util.SOAPMessageUtils;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XECipherData
extends XMLElement {
    public XECipherData(Element cipherData) throws DOMException {
        super(cipherData);
    }

    public XECipherData(Element cipherData, String systemId) throws DOMException {
        super(cipherData, systemId);
    }

    XECipherData(Document doc) throws DOMException {
        super(doc, "http://www.w3.org/2001/04/xmlenc#", "CipherData");
    }

    public void setCipherValue(byte[] cipherValue) throws DOMException {
        Document owner = this.getOwnerDocument();
        Element cv = null;
        if (System.getProperty("osdt.useMTOM") != null && owner.getDocumentElement() != null && owner.getDocumentElement().getClass().getName().startsWith("oracle.j2ee.ws.saaj")) {
            cv = SOAPMessageUtils.addChildElementWithBinaryContent((Element)this.node, "CipherValue", null, "http://www.w3.org/2001/04/xmlenc#", cipherValue, false);
        } else {
            cv = owner.createElementNS("http://www.w3.org/2001/04/xmlenc#", "CipherValue");
            XMLUtils.copyNSPrefix((Element)this.node, cv);
            cv.appendChild(owner.createTextNode(Base64.toBase64WithLFSeparator(cipherValue)));
            this.appendChild(cv);
        }
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherValue");
        int len = nodes.getLength();
        for (int i = 0; i < len; ++i) {
            if (nodes.item(i) == cv) continue;
            this.removeChild(nodes.item(i));
        }
    }

    public OutputStream setCipherValueAsStream() {
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherValue");
        int len = nodes.getLength();
        for (int i = 0; i < len; ++i) {
            this.removeChild(nodes.item(i));
        }
        final Document owner = this.getOwnerDocument();
        final XECipherData cd = this;
        if (System.getProperty("osdt.useMTOM") != null && owner.getDocumentElement() != null && owner.getDocumentElement().getClass().getName().startsWith("oracle.j2ee.ws.saaj")) {
            return new UnsyncByteArrayOutputStream(){

                public void close() throws IOException {
                    Element cv = SOAPMessageUtils.addChildElementWithBinaryContent((Element)cd.node, "CipherValue", null, "http://www.w3.org/2001/04/xmlenc#", this.toByteArray(), false);
                }
            };
        }
        final Element cv = owner.createElementNS("http://www.w3.org/2001/04/xmlenc#", "CipherValue");
        XMLUtils.copyNSPrefix((Element)this.node, cv);
        this.appendChild(cv);
        Writer wr = new Writer(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void write(char[] cbuf, int off, int len) {
                cv.appendChild(owner.createTextNode(new String(cbuf, off, len)));
            }
        };
        return new Base64.EncodeOutputStream(wr);
    }

    public void setCipherReference(XECipherReference cipherRef) throws DOMException {
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherReference");
        int len = nodes.getLength();
        for (int i = 0; i < len; ++i) {
            this.removeChild(nodes.item(i));
        }
        this.appendChild(cipherRef);
    }

    public byte[] getCipherValue() {
        String cvString;
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherValue");
        if (nodes.getLength() != 0 && (cvString = XMLUtils.collectText(nodes.item(0))).length() != 0) {
            return Base64.fromBase64(cvString);
        }
        return null;
    }

    public InputStream getCipherValueAsStream() {
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherValue");
        if (nodes.getLength() != 0) {
            InputStream is;
            Element cvElem = (Element)nodes.item(0);
            if (System.getProperty("osdt.useMTOM") != null && (is = SOAPMessageUtils.getBinaryContentForChildElement(cvElem)) != null) {
                return is;
            }
            final Text txtNode = (Text)cvElem.getFirstChild();
            Reader rw = new Reader(){
                Text currentTxtNode;
                char[] currentChars;
                int currentOffset;
                int currentLen;
                {
                    this.currentTxtNode = txtNode;
                    this.currentChars = this.currentTxtNode == null ? new char[]{} : txtNode.getNodeValue().toCharArray();
                    this.currentOffset = 0;
                    this.currentLen = this.currentChars.length;
                }

                @Override
                public void close() throws IOException {
                }

                @Override
                public int read(char[] cbuf, int off, int len) throws IOException {
                    if (this.currentTxtNode == null) {
                        return -1;
                    }
                    int n = Math.min(len, this.currentLen - this.currentOffset);
                    System.arraycopy(this.currentChars, this.currentOffset, cbuf, off, n);
                    this.currentOffset += n;
                    if (this.currentOffset == this.currentLen) {
                        this.currentTxtNode = (Text)this.currentTxtNode.getNextSibling();
                        this.currentChars = this.currentTxtNode == null ? new char[]{} : this.currentTxtNode.getNodeValue().toCharArray();
                        this.currentOffset = 0;
                        this.currentLen = this.currentChars.length;
                    }
                    return n;
                }
            };
            return new Base64.DecodeInputStream(rw);
        }
        return null;
    }

    public XECipherReference getCipherReference() {
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherReference");
        if (nodes.getLength() != 0) {
            return new XECipherReference((Element)nodes.item(0), this.systemId);
        }
        return null;
    }
}

