/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.enc;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

public class EncryptOutputStream
extends FilterOutputStream {
    private final Cipher c;
    private int inputLength = 0;
    private int outputLength = 0;
    private boolean doPadding = false;
    final int blockSize;
    final byte[] input;
    final byte[] output;

    public EncryptOutputStream(OutputStream os, Cipher c) throws IOException {
        super(os);
        this.c = c;
        this.blockSize = c.getBlockSize();
        this.input = new byte[1024];
        this.output = new byte[this.input.length + this.blockSize * 2];
        byte[] b = c.getIV();
        if (c.getAlgorithm().contains("GCM")) {
            b = Arrays.copyOfRange(b, b.length - 12, b.length);
            this.doPadding = false;
        } else {
            this.doPadding = !c.getAlgorithm().endsWith("ISO10126Padding");
        }
        this.out.write(b);
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.doPadding) {
                int blockSize = this.c.getBlockSize();
                int paddingLength = blockSize - this.inputLength % blockSize;
                for (int i = 0; i < paddingLength; ++i) {
                    this.input[i + this.inputLength] = paddingLength;
                }
                this.inputLength += paddingLength;
            }
            this.outputLength = this.c.doFinal(this.input, 0, this.inputLength, this.output, 0);
        }
        catch (IllegalBlockSizeException ex) {
            IOException ex1 = new IOException(ex.getMessage());
            ex1.initCause(ex);
            throw ex1;
        }
        catch (BadPaddingException ex) {
            IOException ex1 = new IOException(ex.getMessage());
            ex1.initCause(ex);
            throw ex1;
        }
        catch (ShortBufferException ex) {
            IOException ex1 = new IOException(ex.getMessage());
            ex1.initCause(ex);
            throw ex1;
        }
        this.out.write(this.output, 0, this.outputLength);
        this.out.close();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int off1 = off;
        int len1 = len;
        do {
            int toCopy = Math.min(len1, this.input.length - this.inputLength);
            System.arraycopy(b, off1, this.input, this.inputLength, toCopy);
            this.inputLength += toCopy;
            off1 += toCopy;
            len1 -= toCopy;
            if (this.inputLength != this.input.length) continue;
            try {
                this.outputLength = this.c.update(this.input, 0, this.inputLength, this.output);
            }
            catch (ShortBufferException ex) {
                IOException ex1 = new IOException(ex.getMessage());
                ex1.initCause(ex);
                throw ex1;
            }
            this.inputLength = 0;
            this.out.write(this.output, 0, this.outputLength);
        } while (len1 > 0);
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)b};
        this.write(buf, 0, 1);
    }
}

