/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.c14n;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;
import oracle.security.xmlsec.c14n.CanonicalizationException;
import oracle.security.xmlsec.c14n.Canonicalizer;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.util.FilteredNodeReader;
import oracle.security.xmlsec.util.NodeReader;
import oracle.security.xmlsec.util.NodeReaderException;
import oracle.security.xmlsec.util.NodeReaderForNodeset;
import oracle.security.xmlsec.util.NodeReaderForSAX;
import oracle.security.xmlsec.util.NodeReaderForStAX;
import oracle.security.xmlsec.util.NodeReaderForSubtree;
import oracle.security.xmlsec.util.XMLUtils;
import org.jaxen.dom.NamespaceNode;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class StreamingC14NImpl
extends Canonicalizer {
    private static final boolean xmlDebugC14N = System.getProperty("xml.debug.c14n") != null;
    private String debugIndent = "";
    private boolean withComments = false;
    private boolean gotRoot = false;
    private boolean beforeDocElement = false;
    private boolean afterDocElement = false;
    private boolean excC14n = false;
    private boolean c14n11 = false;
    private TreeSet inclusiveNSPrefixes = new TreeSet();
    private boolean checkNamespaceURI = false;
    private static AttrComparator aComparator = new AttrComparator();
    private static final Object DUMMY = new Object();
    private final HashMap currNamespaces = new HashMap();
    private final HashMap outputNamespaces = new HashMap();
    private final HashSet missingNamespaces = new HashSet();
    private final ArrayList elemContextStack = new ArrayList();
    private NodeReader nodeReader;
    private BufWriter buf;
    private int eventType;
    private char[] text = null;
    int textLength;
    int textStart;

    public StreamingC14NImpl(boolean excC14n, boolean withComments) {
        this(excC14n, withComments, false);
    }

    public StreamingC14NImpl(boolean excC14n, boolean withComments, boolean c14n11) {
        this.excC14n = excC14n;
        this.withComments = withComments;
        this.c14n11 = c14n11;
    }

    public StreamingC14NImpl() {
    }

    public StreamingC14NImpl(boolean exclusive, boolean withComments, String inclusiveNSList) {
        this.excC14n = exclusive;
        this.withComments = withComments;
        this.setInclusiveNSPrefixList(inclusiveNSList);
    }

    public static String getInclusiveNamespacesList(XSAlgorithmIdentifier c14nMethod) throws IllegalArgumentException {
        NodeList pList = c14nMethod.getParameters();
        if (pList.getLength() == 1) {
            Element param = (Element)pList.item(0);
            if (!"InclusiveNamespaces".equals(param.getLocalName()) && !"InclusiveNamespaces".equals(param.getTagName())) {
                throw new IllegalArgumentException("Illegal CanonicalizationMethod parameter");
            }
            if (param.hasAttribute("PrefixList")) {
                return param.getAttribute("PrefixList");
            }
            return null;
        }
        if (pList.getLength() > 0) {
            throw new IllegalArgumentException("Illegal CanonicalizationMethod parameter");
        }
        return null;
    }

    @Override
    public void setInclusiveNSPrefixList(String inclusiveNSList) {
        this.inclusiveNSPrefixes.clear();
        if (inclusiveNSList != null && inclusiveNSList.length() > 0) {
            StringTokenizer st = new StringTokenizer(inclusiveNSList);
            while (st.hasMoreTokens()) {
                String prefix = st.nextToken();
                if (prefix.equals("#default")) {
                    prefix = "";
                }
                this.inclusiveNSPrefixes.add(prefix);
            }
        }
    }

    @Override
    public String getInclusiveNSPrefixList() {
        StringBuffer inclusiveNSList = new StringBuffer();
        Iterator i = this.inclusiveNSPrefixes.iterator();
        while (i.hasNext()) {
            String prefix = (String)i.next();
            if (prefix.equals("")) {
                prefix = "#default";
            }
            inclusiveNSList.append(prefix);
            if (!i.hasNext()) continue;
            inclusiveNSList.append(' ');
        }
        return inclusiveNSList.toString();
    }

    private final int c14nCurrentTextNode() {
        if (this.text == null) {
            return 0;
        }
        int len1 = Math.min(this.buf.available(), this.textLength);
        this.buf.writeCharsEscapeText(this.text, this.textStart, len1);
        this.textStart += len1;
        this.textLength -= len1;
        if (this.textLength == 0) {
            this.text = null;
        }
        return len1;
    }

    private final boolean c14nCurrentNode() throws NodeReaderException {
        if (this.text != null) {
            this.c14nCurrentTextNode();
            return this.text == null;
        }
        this.eventType = this.nodeReader.getEventType();
        this.text = null;
        this.textStart = 0;
        this.textLength = 0;
        switch (this.eventType) {
            case 7: {
                this.processStartDocument();
                break;
            }
            case 4: {
                this.text = this.nodeReader.getText();
                this.textStart = this.nodeReader.getTextStart();
                this.textLength = this.nodeReader.getTextLength();
                this.c14nCurrentTextNode();
                return this.text == null;
            }
            case 12: {
                this.text = this.nodeReader.getText();
                this.textStart = this.nodeReader.getTextStart();
                this.textLength = this.nodeReader.getTextLength();
                this.c14nCurrentTextNode();
                return this.text == null;
            }
            case 3: {
                this.processPI(this.nodeReader.getPITarget(), this.nodeReader.getPIData());
                break;
            }
            case 5: {
                if (!this.withComments) break;
                this.processComment(this.nodeReader.getText(), this.nodeReader.getTextStart(), this.nodeReader.getTextLength());
                break;
            }
            case 1: {
                this.processStartElement();
                break;
            }
            case 2: {
                this.processEndElement();
                break;
            }
        }
        return true;
    }

    private final void processPI(String target, String data) {
        if (xmlDebugC14N) {
            System.err.println(this.debugIndent + "PI");
        }
        if (!"xml".equals(target)) {
            if (this.afterDocElement) {
                this.buf.writeByte(10);
            }
            this.buf.writeBytes(BufWriter.SPIs);
            this.buf.writeString(target, false, false);
            String value = data;
            if (value != null && value.length() > 0) {
                this.buf.writeByte(32);
                this.buf.writeString(value, false, false);
            }
            this.buf.writeBytes(BufWriter.SPIe);
            if (this.beforeDocElement) {
                this.buf.writeByte(10);
            }
        }
    }

    private final void processComment(char[] comment, int start, int length) {
        if (xmlDebugC14N) {
            System.err.println(this.debugIndent + "Comment");
        }
        if (this.afterDocElement) {
            this.buf.writeByte(10);
        }
        this.buf.writeBytes(BufWriter.SComms);
        this.buf.writeChars(comment, start, length, false, false);
        this.buf.writeBytes(BufWriter.SComme);
        if (this.beforeDocElement) {
            this.buf.writeByte(10);
        }
    }

    private final void processText(char[] ch, int start, int length) {
        if (xmlDebugC14N) {
            System.err.println(this.debugIndent + "Text");
        }
        this.buf.writeCharsEscapeText(ch, start, length);
    }

    private final void processStartDocument() {
        this.beforeDocElement = true;
        this.gotRoot = true;
    }

    private final void processStartElement() throws NodeReaderException {
        this.beforeDocElement = false;
        ElementContext ec = new ElementContext();
        this.elemContextStack.add(ec);
        ec.processStart();
    }

    private final void processEndElement() {
        ElementContext ec = (ElementContext)this.elemContextStack.remove(this.elemContextStack.size() - 1);
        ec.processEnd();
        ec.restoreNsMap();
        if (this.elemContextStack.size() == 0 && this.gotRoot) {
            this.afterDocElement = true;
        }
    }

    private void reinit() {
        this.gotRoot = false;
        this.beforeDocElement = false;
        this.afterDocElement = false;
        this.buf = new BufWriter();
        this.currNamespaces.clear();
        this.currNamespaces.put("", "");
        this.outputNamespaces.clear();
        this.outputNamespaces.put("", "");
        this.missingNamespaces.clear();
        this.elemContextStack.clear();
        this.text = null;
        this.textStart = 0;
        this.textLength = 0;
        boolean bl = this.checkNamespaceURI = this.nodeReader instanceof NodeReaderForSubtree || this.nodeReader instanceof FilteredNodeReader || this.nodeReader instanceof NodeReaderForNodeset && this.nodeReader.isElementInheritingNamespaces();
        if (xmlDebugC14N) {
            this.debugIndent = "";
        }
    }

    @Override
    public InputStream canonicalizeToStream(Node subTree) throws CanonicalizationException {
        this.nodeReader = new NodeReaderForSubtree(subTree);
        return new C14NStream();
    }

    @Override
    public InputStream canonicalizeToStream(Collection source) throws CanonicalizationException {
        boolean C14N_NS_FILTERED_OUT = System.getProperty("osdt.c14nNsFilteredOut") != null;
        double C14N_SPARSE_THRESHOLD = Double.parseDouble(System.getProperty("osdt.c14nSparseThreshold", "0.0"));
        this.nodeReader = new NodeReaderForNodeset(source, C14N_NS_FILTERED_OUT, C14N_SPARSE_THRESHOLD >= 1.0);
        return new C14NStream();
    }

    @Override
    public InputStream canonicalizeToStream(NodeList source) throws CanonicalizationException {
        HashSet<Node> nodeset = new HashSet<Node>(source.getLength());
        int n = source.getLength();
        for (int i = 0; i < n; ++i) {
            nodeset.add(source.item(i));
        }
        return this.canonicalizeToStream(nodeset);
    }

    public InputStream canonicalizeToStream(NodeReader nodeReader) throws CanonicalizationException {
        this.nodeReader = nodeReader;
        return new C14NStream();
    }

    public void canonicalizeToStream(NodeReader nodeReader, OutputStream os) {
        this.nodeReader = nodeReader;
        C14NNodeListener nl = new C14NNodeListener(os);
        nodeReader.addListener(nl);
    }

    @Override
    public byte[] canonicalize(Collection source) throws CanonicalizationException {
        try {
            return XMLUtils.readBytes(this.canonicalizeToStream(source));
        }
        catch (IOException ex) {
            throw new CanonicalizationException(ex);
        }
    }

    @Override
    public InputStream canonicalizeToStream(InputSource source) throws CanonicalizationException {
        String C14N_PARSER = System.getProperty("osdt.c14nParser", "DOM");
        if (C14N_PARSER.equalsIgnoreCase("StAX")) {
            try {
                return this.canonicalizeToStream(new NodeReaderForStAX(new StreamSource(source.getSystemId())));
            }
            catch (NodeReaderException ex) {
                throw new CanonicalizationException(ex);
            }
        }
        if (C14N_PARSER.equalsIgnoreCase("SAX")) {
            SAXParserFactory sf = SAXParserFactory.newInstance();
            UnsyncByteArrayOutputStream bos = new UnsyncByteArrayOutputStream();
            try {
                sf.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                sf.setFeature("http://xml.org/sax/features/namespaces", true);
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
            try {
                SAXParser sp = sf.newSAXParser();
                NodeReaderForSAX nr = new NodeReaderForSAX();
                this.canonicalizeToStream(nr, (OutputStream)bos);
                sp.parse(source, (DefaultHandler)nr.getSAXHandler());
            }
            catch (IOException ex) {
                throw new CanonicalizationException(ex);
            }
            catch (SAXException ex) {
                throw new CanonicalizationException(ex);
            }
            catch (ParserConfigurationException ex) {
                throw new CanonicalizationException(ex);
            }
            return new UnsyncByteArrayInputStream(bos.toByteArray());
        }
        try {
            DocumentBuilder db = XMLUtils.createDocBuilder();
            Document doc = db.parse(source);
            return this.canonicalizeToStream(doc);
        }
        catch (IOException ex) {
            throw new CanonicalizationException(ex);
        }
        catch (SAXException ex) {
            throw new CanonicalizationException(ex);
        }
    }

    @Override
    public InputStream canonicalizeToStream(InputStream source, String systemId) throws CanonicalizationException {
        String C14N_PARSER = System.getProperty("osdt.c14nParser", "DOM");
        if (C14N_PARSER.equalsIgnoreCase("StAX")) {
            try {
                return this.canonicalizeToStream(new NodeReaderForStAX(source, systemId));
            }
            catch (NodeReaderException ex) {
                throw new CanonicalizationException(ex);
            }
        }
        if (C14N_PARSER.equalsIgnoreCase("SAX")) {
            SAXParserFactory sf = SAXParserFactory.newInstance();
            UnsyncByteArrayOutputStream bos = new UnsyncByteArrayOutputStream();
            try {
                sf.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                sf.setFeature("http://xml.org/sax/features/namespaces", true);
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
            try {
                SAXParser sp = sf.newSAXParser();
                NodeReaderForSAX nr = new NodeReaderForSAX();
                this.canonicalizeToStream(nr, (OutputStream)bos);
                sp.parse(source, nr.getSAXHandler(), systemId);
            }
            catch (IOException ex) {
                throw new CanonicalizationException(ex);
            }
            catch (SAXException ex) {
                throw new CanonicalizationException(ex);
            }
            catch (ParserConfigurationException ex) {
                throw new CanonicalizationException(ex);
            }
            return new UnsyncByteArrayInputStream(bos.toByteArray());
        }
        try {
            DocumentBuilder db = XMLUtils.createDocBuilder();
            Document doc = db.parse(source, systemId);
            return this.canonicalizeToStream(doc);
        }
        catch (IOException ex) {
            throw new CanonicalizationException(ex);
        }
        catch (SAXException ex) {
            throw new CanonicalizationException(ex);
        }
    }

    @Override
    public InputStream canonicalizeToStream(InputStream source) throws CanonicalizationException {
        return this.canonicalizeToStream(source, null);
    }

    @Override
    public byte[] canonicalize(InputSource source) throws CanonicalizationException {
        try {
            return XMLUtils.readBytes(this.canonicalizeToStream(source));
        }
        catch (IOException ex) {
            throw new CanonicalizationException(ex);
        }
    }

    @Override
    public byte[] canonicalize(InputStream source, String systemId) throws CanonicalizationException {
        try {
            return XMLUtils.readBytes(this.canonicalizeToStream(source, systemId));
        }
        catch (IOException ex) {
            throw new CanonicalizationException(ex);
        }
    }

    @Override
    public byte[] canonicalize(InputStream source) throws CanonicalizationException {
        try {
            return XMLUtils.readBytes(this.canonicalizeToStream(source));
        }
        catch (IOException ex) {
            throw new CanonicalizationException(ex);
        }
    }

    @Override
    public byte[] canonicalize(Node source) throws CanonicalizationException {
        try {
            return XMLUtils.readBytes(this.canonicalizeToStream(source));
        }
        catch (IOException ex) {
            throw new CanonicalizationException(ex);
        }
    }

    @Override
    public byte[] canonicalize(NodeList source) throws CanonicalizationException {
        try {
            return XMLUtils.readBytes(this.canonicalizeToStream(source));
        }
        catch (IOException ex) {
            throw new CanonicalizationException(ex);
        }
    }

    private class C14NStream
    extends InputStream {
        private static final int AVERAGE_NODE_SIZE = 512;
        private boolean eof = false;

        public C14NStream() {
            StreamingC14NImpl.this.reinit();
        }

        @Override
        public final int read() throws IOException {
            byte[] b = new byte[1];
            int n = this.read(b, 0, 1);
            return n == -1 ? -1 : b[0];
        }

        @Override
        public final int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int n = StreamingC14NImpl.this.buf.readOverflow(b, off, len);
            off += n;
            if ((len -= n) == 0) {
                return n;
            }
            StreamingC14NImpl.this.buf.init(b, off, len);
            while (!this.eof && StreamingC14NImpl.this.buf.available() > 512) {
                try {
                    boolean currentNodeOver = StreamingC14NImpl.this.c14nCurrentNode();
                    if (!currentNodeOver) continue;
                    boolean bl = this.eof = !StreamingC14NImpl.this.nodeReader.hasNext();
                    if (this.eof) continue;
                    StreamingC14NImpl.this.nodeReader.next();
                }
                catch (NodeReaderException ex) {
                    IOException ex1 = new IOException();
                    ex1.initCause(ex);
                    throw ex1;
                }
            }
            n += len - StreamingC14NImpl.this.buf.available();
            off += len - StreamingC14NImpl.this.buf.available();
            len = StreamingC14NImpl.this.buf.available();
            if (this.eof && n == 0) {
                return -1;
            }
            return n;
        }
    }

    private class C14NNodeListener
    implements NodeReader.NodeListener {
        OutputStream os;
        byte[] b = new byte[2048];

        C14NNodeListener(OutputStream os) {
            this.os = os;
            StreamingC14NImpl.this.reinit();
        }

        @Override
        public void consumeNode() throws NodeReaderException {
            try {
                boolean currentNodeOver;
                do {
                    StreamingC14NImpl.this.buf.init(this.b, 0, this.b.length);
                    currentNodeOver = StreamingC14NImpl.this.c14nCurrentNode();
                    StreamingC14NImpl.this.buf.writeToStream(this.os);
                } while (!currentNodeOver);
            }
            catch (IOException ex) {
                throw new NodeReaderException(ex);
            }
        }
    }

    private static class BufWriter {
        static final byte[] Samp = new byte[]{38, 97, 109, 112, 59};
        static final byte[] Slt = new byte[]{38, 108, 116, 59};
        static final byte[] Sgt = new byte[]{38, 103, 116, 59};
        static final byte[] Squot = new byte[]{38, 113, 117, 111, 116, 59};
        static final byte[] Sx9 = new byte[]{38, 35, 120, 57, 59};
        static final byte[] SxA = new byte[]{38, 35, 120, 65, 59};
        static final byte[] SxD = new byte[]{38, 35, 120, 68, 59};
        static final byte[] Selem = new byte[]{60, 47};
        static final byte[] SPIs = new byte[]{60, 63};
        static final byte[] SPIe = new byte[]{63, 62};
        static final byte[] SComms = new byte[]{60, 33, 45, 45};
        static final byte[] SComme = new byte[]{45, 45, 62};
        static final byte[] Sxmlns = new byte[]{120, 109, 108, 110, 115};
        private byte[] currBuf;
        private int currOffset;
        private int currLength;
        private final LinkedList overflowQueue = new LinkedList();
        private static final int OVERFLOW_BLOCK_SIZE = 2048;
        private int tail = 0;
        private int head = 0;

        private BufWriter() {
        }

        final void init(byte[] b, int off, int len) {
            if (this.overflowSize() > 0) {
                throw new IllegalStateException("can't call init while there is still something in the overflow buffers");
            }
            this.tail = 0;
            this.head = 0;
            this.currBuf = b;
            this.currOffset = off;
            this.currLength = len;
        }

        final int available() {
            return this.currLength;
        }

        final int overflowSize() {
            if (this.overflowQueue.size() == 0) {
                return 0;
            }
            if (this.overflowQueue.size() == 1) {
                return this.head - this.tail;
            }
            return this.head + (this.overflowQueue.size() - 2) * 2048 + (2048 - this.tail);
        }

        final int readOverflow(byte[] b, int off, int len) {
            int n = 0;
            if (this.overflowQueue.size() == 0) {
                return 0;
            }
            while (n < len && (this.overflowQueue.size() > 1 || this.head > this.tail)) {
                byte[] buf = (byte[])this.overflowQueue.getFirst();
                int size = this.overflowQueue.size() == 1 ? this.head : 2048;
                int n1 = Math.min(len - n, size - this.tail);
                System.arraycopy(buf, this.tail, b, off, n1);
                n += n1;
                off += n1;
                this.tail += n1;
                if (this.tail != 2048) continue;
                this.overflowQueue.removeFirst();
                this.tail = 0;
            }
            return n;
        }

        final int readOverflow() {
            if (this.overflowQueue.size() == 0) {
                return -1;
            }
            byte[] buf = (byte[])this.overflowQueue.getFirst();
            byte b = buf[this.tail++];
            if (this.tail == 2048) {
                this.overflowQueue.removeFirst();
                this.tail = 0;
            }
            return b;
        }

        final void writeByte(int b) {
            if (this.currLength == 0) {
                if (this.overflowQueue.size() == 0 || this.head == 2048) {
                    this.overflowQueue.addLast(new byte[2048]);
                    this.head = 0;
                }
                byte[] buf = (byte[])this.overflowQueue.getLast();
                buf[this.head++] = (byte)b;
            } else {
                this.currBuf[this.currOffset++] = (byte)b;
                --this.currLength;
            }
        }

        final int writeToStream(OutputStream os) throws IOException {
            int n = this.currOffset;
            os.write(this.currBuf, 0, this.currOffset);
            while (this.overflowQueue.size() > 1 || this.head > this.tail) {
                byte[] buf = (byte[])this.overflowQueue.getFirst();
                int size = this.overflowQueue.size() == 1 ? this.head : 2048;
                os.write(buf, this.tail, size);
                n += size - this.tail;
                this.tail += size - this.tail;
                if (this.tail != 2048) continue;
                this.overflowQueue.removeFirst();
                this.tail = 0;
            }
            return n;
        }

        final void writeBytes(byte[] b) {
            int l = Math.min(b.length, this.currLength);
            if (l > 0) {
                System.arraycopy(b, 0, this.currBuf, this.currOffset, l);
                this.currOffset += l;
                this.currLength -= l;
            }
            while (l < b.length) {
                if (this.overflowQueue.size() == 0 || this.head == 2048) {
                    this.overflowQueue.addLast(new byte[2048]);
                    this.head = 0;
                }
                byte[] buf = (byte[])this.overflowQueue.getLast();
                int n = Math.min(b.length - l, 2048 - this.head);
                System.arraycopy(b, l, buf, this.head, n);
                this.head += n;
                l += n;
            }
        }

        final void writeString(String str, boolean escapeAttrib, boolean escapeText) {
            if (str != null) {
                char[] chars = str.toCharArray();
                this.writeChars(chars, 0, chars.length, escapeAttrib, escapeText);
            }
        }

        final void writeCharsEscapeText(char[] chars, int start, int length) {
            char c;
            int end = start + length;
            int n = Math.min(this.currLength, length);
            int i = start;
            int j = 0;
            int k = this.currOffset;
            byte[] buf = this.currBuf;
            while (j < n && (c = chars[i]) <= '\u007f' && c != '&' && c != '<' && c != '>' && c != '\r') {
                buf[k] = (byte)c;
                ++i;
                ++j;
                ++k;
            }
            this.currOffset += j;
            this.currLength -= j;
            while (i < end) {
                c = chars[i];
                if (c == '&') {
                    this.writeBytes(Samp);
                } else if (c == '<') {
                    this.writeBytes(Slt);
                } else if (c == '\r') {
                    this.writeBytes(SxD);
                } else if (c == '>') {
                    this.writeBytes(Sgt);
                } else if (c <= '\u007f') {
                    if (this.currLength > 0) {
                        this.currBuf[this.currOffset++] = (byte)c;
                        --this.currLength;
                    } else {
                        this.writeByte(c);
                    }
                } else if (c <= '\u07ff') {
                    this.writeByte(0xC0 | c >>> 6 & 0x1F);
                    this.writeByte(0x80 | c & 0x3F);
                } else {
                    this.writeByte(0xE0 | c >>> 12 & 0xF);
                    this.writeByte(0x80 | c >>> 6 & 0x3F);
                    this.writeByte(0x80 | c & 0x3F);
                }
                ++i;
            }
        }

        final void writeChars(char[] chars, int start, int length, boolean escapeAttrib, boolean escapeText) {
            int i = start;
            int end = start + length;
            while (i < end) {
                char c = chars[i++];
                if (escapeText || escapeAttrib) {
                    if (c == '&') {
                        this.writeBytes(Samp);
                        continue;
                    }
                    if (c == '<') {
                        this.writeBytes(Slt);
                        continue;
                    }
                    if (c == '\r') {
                        this.writeBytes(SxD);
                        continue;
                    }
                    if (escapeAttrib) {
                        if (c == '\"') {
                            this.writeBytes(Squot);
                            continue;
                        }
                        if (c == '\t') {
                            this.writeBytes(Sx9);
                            continue;
                        }
                        if (c == '\n') {
                            this.writeBytes(SxA);
                            continue;
                        }
                    }
                    if (escapeText && c == '>') {
                        this.writeBytes(Sgt);
                        continue;
                    }
                }
                if (c <= '\u007f') {
                    if (this.currLength > 0) {
                        this.currBuf[this.currOffset++] = (byte)c;
                        --this.currLength;
                        continue;
                    }
                    this.writeByte(c);
                    continue;
                }
                if (c <= '\u07ff') {
                    this.writeByte(0xC0 | c >>> 6 & 0x1F);
                    this.writeByte(0x80 | c & 0x3F);
                    continue;
                }
                this.writeByte(0xE0 | c >>> 12 & 0xF);
                this.writeByte(0x80 | c >>> 6 & 0x3F);
                this.writeByte(0x80 | c & 0x3F);
            }
        }
    }

    private class ElementContext {
        private String elemLocalName;
        private String elemPrefix;
        private boolean elemIncluded;
        private HashMap modifiedNs = null;
        private HashMap addedOutputNs = null;
        private HashMap removedOutputNs = null;
        private ArrayList addedMissingNs = null;
        private ArrayList removedMissingNs = null;
        private TreeMap attrsList = null;
        private TreeMap nsMap = null;
        private URI xmlBase = null;
        private boolean emitEmptyDefaultNs = false;

        private final void processNamespace(String prefix, String uri) {
            String prevUri;
            if (prefix.equals("xml") && uri.equals("http://www.w3.org/XML/1998/namespace")) {
                return;
            }
            if (!this.elemIncluded) {
                if (StreamingC14NImpl.this.excC14n && !StreamingC14NImpl.this.inclusiveNSPrefixes.contains(prefix)) {
                    return;
                }
                if (prefix.length() == 0 && uri.length() == 0) {
                    return;
                }
            }
            if ((prevUri = (String)StreamingC14NImpl.this.currNamespaces.get(prefix)) != null && prevUri.equals(uri)) {
                return;
            }
            if (this.modifiedNs == null) {
                this.modifiedNs = new HashMap();
            }
            if (prevUri == null) {
                this.modifiedNs.put(prefix, null);
            } else {
                this.modifiedNs.put(prefix, prevUri);
            }
            StreamingC14NImpl.this.currNamespaces.put(prefix, uri);
        }

        private final void processNamespaces(Map namespaces) {
            if (!StreamingC14NImpl.this.nodeReader.isElementInheritingNamespaces()) {
                Iterator i = StreamingC14NImpl.this.currNamespaces.keySet().iterator();
                while (i.hasNext()) {
                    String prefix = (String)i.next();
                    NamespaceNode ns = (NamespaceNode)namespaces.get(prefix);
                    if (ns != null) continue;
                    if (this.modifiedNs == null) {
                        this.modifiedNs = new HashMap();
                    }
                    this.modifiedNs.put(prefix, StreamingC14NImpl.this.currNamespaces.get(prefix));
                    i.remove();
                }
            }
            for (String prefix : namespaces.keySet()) {
                String uri = ((Node)namespaces.get(prefix)).getNodeValue();
                this.processNamespace(prefix, uri);
            }
        }

        private final void processAllAttributes(Iterator attrs) {
            while (attrs.hasNext()) {
                String attrName;
                Attr attr = (Attr)attrs.next();
                String attrPrefix = attr.getPrefix();
                String attrLocalName = attr.getLocalName();
                String nsPrefix = attrLocalName == null ? ((attrName = attr.getNodeName()).equals("xmlns") ? "" : (attrName.startsWith("xmlns:") ? attrName.substring(6) : null)) : (attrPrefix != null && attrPrefix.equals("xmlns") ? attr.getLocalName() : ((attrPrefix == null || attrPrefix.length() == 0) && attr.getLocalName() != null && attr.getLocalName().equals("xmlns") ? "" : null));
                if (nsPrefix != null) {
                    String uri = attr.getNodeValue();
                    this.processNamespace(nsPrefix, uri);
                    continue;
                }
                if (StreamingC14NImpl.this.checkNamespaceURI && attr.getPrefix() != null) {
                    String namespaceURI = attr.getNamespaceURI();
                    if (namespaceURI == null) {
                        namespaceURI = "";
                    }
                    this.processNamespace(attr.getPrefix(), namespaceURI);
                }
                if (this.attrsList == null) {
                    this.attrsList = new TreeMap(aComparator);
                }
                this.attrsList.put(attr, DUMMY);
            }
        }

        private ElementContext() throws NodeReaderException {
            Collection xmlAttribs;
            Map namespaces;
            this.elemIncluded = StreamingC14NImpl.this.nodeReader.isElementIncluded();
            this.elemLocalName = StreamingC14NImpl.this.nodeReader.getLocalName();
            this.elemPrefix = StreamingC14NImpl.this.nodeReader.getPrefix();
            if (this.elemPrefix == null) {
                this.elemPrefix = "";
            }
            this.emitEmptyDefaultNs = StreamingC14NImpl.this.nodeReader.isUnnecessaryEmptyDefaultNsRequired();
            boolean attrsListReadOnly = false;
            if (xmlDebugC14N) {
                StringBuffer attribs = new StringBuffer();
                Map namespaces2 = StreamingC14NImpl.this.nodeReader.getNamespaces();
                if (namespaces2 != null) {
                    for (Node attr : namespaces2.values()) {
                        attribs.append("xmlns:" + attr.getNodeName() + "= \"" + attr.getNodeValue() + "\" ");
                    }
                    for (Node attr : StreamingC14NImpl.this.nodeReader.getSortedAttributes().keySet()) {
                        attribs.append(attr.getNodeName() + "= \"" + attr.getNodeValue() + "\" ");
                    }
                } else {
                    Iterator ia = StreamingC14NImpl.this.nodeReader.getAttributes();
                    while (ia.hasNext()) {
                        Node attr;
                        attr = (Attr)ia.next();
                        attribs.append(attr.getNodeName() + "= \"" + attr.getNodeValue() + "\" ");
                    }
                }
                System.err.println(StreamingC14NImpl.this.debugIndent + "Element:" + this.elemPrefix + ":" + this.elemLocalName + "(" + attribs + ")");
            }
            if ((namespaces = StreamingC14NImpl.this.nodeReader.getNamespaces()) != null) {
                this.processNamespaces(namespaces);
                SortedMap attrsMap = StreamingC14NImpl.this.nodeReader.getSortedAttributes();
                if (attrsMap == null || attrsMap instanceof TreeMap) {
                    this.attrsList = (TreeMap)attrsMap;
                    attrsListReadOnly = true;
                } else {
                    this.attrsList = new TreeMap(attrsMap);
                }
            } else {
                this.processAllAttributes(StreamingC14NImpl.this.nodeReader.getAttributes());
            }
            if (StreamingC14NImpl.this.checkNamespaceURI && this.elemIncluded) {
                String nsURI = StreamingC14NImpl.this.nodeReader.getNamespaceURI();
                if (nsURI == null) {
                    nsURI = "";
                }
                if (!nsURI.equals(StreamingC14NImpl.this.currNamespaces.get(this.elemPrefix))) {
                    if (xmlDebugC14N) {
                        System.err.println(StreamingC14NImpl.this.debugIndent + "Adding undeclarated prefix" + this.elemPrefix);
                    }
                    this.processNamespace(this.elemPrefix, nsURI);
                }
            }
            if (!StreamingC14NImpl.this.excC14n && StreamingC14NImpl.this.nodeReader.isElementAnOrphan() && (xmlAttribs = StreamingC14NImpl.this.nodeReader.getAncestorXmlAttributes(StreamingC14NImpl.this.c14n11)) != null && xmlAttribs.size() > 0) {
                if (this.attrsList == null) {
                    this.attrsList = new TreeMap(aComparator);
                } else if (attrsListReadOnly) {
                    TreeMap newAttrsList = new TreeMap(aComparator);
                    newAttrsList.putAll(this.attrsList);
                    this.attrsList = newAttrsList;
                    attrsListReadOnly = false;
                }
                for (Attr a : xmlAttribs) {
                    this.attrsList.remove(a);
                    this.attrsList.put(a, DUMMY);
                }
            }
        }

        private final void restoreNsMap() {
            if (this.modifiedNs != null) {
                for (String prefix : this.modifiedNs.keySet()) {
                    String prevUri = (String)this.modifiedNs.get(prefix);
                    if (prevUri == null) {
                        StreamingC14NImpl.this.currNamespaces.remove(prefix);
                        continue;
                    }
                    StreamingC14NImpl.this.currNamespaces.put(prefix, prevUri);
                }
                this.modifiedNs = null;
            }
            if (this.addedOutputNs != null) {
                for (String prefix : this.addedOutputNs.keySet()) {
                    StreamingC14NImpl.this.outputNamespaces.remove(prefix);
                }
                this.addedOutputNs = null;
            }
            if (this.removedOutputNs != null) {
                for (String prefix : this.removedOutputNs.keySet()) {
                    String uri = (String)this.removedOutputNs.get(prefix);
                    StreamingC14NImpl.this.outputNamespaces.put(prefix, uri);
                }
                this.removedOutputNs = null;
            }
            if (this.removedMissingNs != null) {
                for (String prefix : this.removedMissingNs) {
                    StreamingC14NImpl.this.missingNamespaces.add(prefix);
                }
                this.removedMissingNs = null;
            }
            if (this.addedMissingNs != null) {
                for (String prefix : this.addedMissingNs) {
                    StreamingC14NImpl.this.missingNamespaces.remove(prefix);
                }
                this.addedMissingNs = null;
            }
        }

        private void outputExcNs(String prefix) {
            if (prefix == null) {
                prefix = "";
            }
            if (StreamingC14NImpl.this.inclusiveNSPrefixes.contains(prefix)) {
                return;
            }
            if (this.nsMap != null && this.nsMap.containsKey(prefix)) {
                return;
            }
            String uri = (String)StreamingC14NImpl.this.currNamespaces.get(prefix);
            String outputNsUri = (String)StreamingC14NImpl.this.outputNamespaces.get(prefix);
            boolean alreadyOutput = false;
            if (outputNsUri != null && outputNsUri.equals(uri)) {
                alreadyOutput = true;
            }
            boolean missing = StreamingC14NImpl.this.missingNamespaces.contains(prefix);
            if (alreadyOutput && !missing && uri != null) {
                return;
            }
            if (uri == null) {
                if (missing) {
                    return;
                }
                StreamingC14NImpl.this.missingNamespaces.add(prefix);
                if (this.addedMissingNs == null) {
                    this.addedMissingNs = new ArrayList();
                }
                this.addedMissingNs.add(prefix);
                return;
            }
            if (this.nsMap == null) {
                this.nsMap = new TreeMap();
            }
            this.nsMap.put(prefix, uri);
            if (missing) {
                StreamingC14NImpl.this.missingNamespaces.remove(prefix);
                if (this.removedMissingNs == null) {
                    this.removedMissingNs = new ArrayList();
                }
                this.removedMissingNs.add(prefix);
            }
            if (!alreadyOutput) {
                if (outputNsUri != null) {
                    if (this.removedOutputNs == null) {
                        this.removedOutputNs = new HashMap();
                    }
                    this.removedOutputNs.put(prefix, outputNsUri);
                }
                StreamingC14NImpl.this.outputNamespaces.put(prefix, uri);
                if (this.addedOutputNs == null) {
                    this.addedOutputNs = new HashMap();
                }
                this.addedOutputNs.put(prefix, uri);
            }
        }

        private final void processStart() {
            Iterator i;
            if (this.elemIncluded) {
                StreamingC14NImpl.this.buf.writeByte(60);
                if (this.elemPrefix != null && this.elemPrefix.length() > 0) {
                    StreamingC14NImpl.this.buf.writeString(this.elemPrefix, false, false);
                    StreamingC14NImpl.this.buf.writeByte(58);
                }
                StreamingC14NImpl.this.buf.writeString(this.elemLocalName, false, false);
            }
            if (this.modifiedNs != null && this.modifiedNs.size() > 0) {
                for (String prefix : this.modifiedNs.keySet()) {
                    String ns = (String)StreamingC14NImpl.this.currNamespaces.get(prefix);
                    if (StreamingC14NImpl.this.excC14n && !StreamingC14NImpl.this.inclusiveNSPrefixes.contains(prefix) || ns == null) continue;
                    if (this.nsMap == null) {
                        this.nsMap = new TreeMap();
                    }
                    this.nsMap.put(prefix, ns);
                }
                if (!this.elemIncluded) {
                    if (!StreamingC14NImpl.this.excC14n) {
                        this.restoreNsMap();
                    } else if (StreamingC14NImpl.this.inclusiveNSPrefixes.size() > 0) {
                        i = this.modifiedNs.keySet().iterator();
                        while (i.hasNext()) {
                            String prefix;
                            prefix = (String)i.next();
                            if (!StreamingC14NImpl.this.inclusiveNSPrefixes.contains(prefix)) continue;
                            String prevUri = (String)this.modifiedNs.get(prefix);
                            if (prevUri == null) {
                                StreamingC14NImpl.this.currNamespaces.remove(prefix);
                            } else {
                                StreamingC14NImpl.this.currNamespaces.put(prefix, prevUri);
                            }
                            i.remove();
                        }
                    }
                }
            }
            if (StreamingC14NImpl.this.excC14n && this.elemIncluded) {
                this.outputExcNs(this.elemPrefix);
                if (this.attrsList != null) {
                    for (Attr attr : this.attrsList.keySet()) {
                        if (attr.getPrefix() == null || attr.getPrefix().length() == 0) continue;
                        this.outputExcNs(attr.getPrefix());
                    }
                }
            }
            if (this.emitEmptyDefaultNs) {
                if (this.nsMap == null) {
                    this.nsMap = new TreeMap();
                }
                if (this.modifiedNs == null) {
                    this.modifiedNs = new HashMap();
                }
                if (!this.nsMap.containsKey("")) {
                    if (!StreamingC14NImpl.this.currNamespaces.containsKey("")) {
                        this.modifiedNs.put("", null);
                        StreamingC14NImpl.this.currNamespaces.put("", "");
                    } else if (!StreamingC14NImpl.this.currNamespaces.get("").equals("")) {
                        this.modifiedNs.put("", StreamingC14NImpl.this.currNamespaces.get(""));
                        StreamingC14NImpl.this.currNamespaces.put("", "");
                    }
                    this.nsMap.put("", "");
                }
            }
            if (this.nsMap != null) {
                i = this.nsMap.keySet().iterator();
                Iterator j = this.nsMap.values().iterator();
                while (i.hasNext() && j.hasNext()) {
                    String prefix = (String)i.next();
                    String uri = (String)j.next();
                    StreamingC14NImpl.this.buf.writeByte(32);
                    BufWriter bufWriter = StreamingC14NImpl.this.buf;
                    StreamingC14NImpl.this.buf;
                    bufWriter.writeBytes(BufWriter.Sxmlns);
                    if (prefix.length() > 0) {
                        StreamingC14NImpl.this.buf.writeByte(58);
                        StreamingC14NImpl.this.buf.writeString(prefix, false, false);
                    }
                    StreamingC14NImpl.this.buf.writeByte(61);
                    StreamingC14NImpl.this.buf.writeByte(34);
                    StreamingC14NImpl.this.buf.writeString(uri, true, false);
                    StreamingC14NImpl.this.buf.writeByte(34);
                }
                this.nsMap = null;
            }
            if (this.attrsList != null) {
                for (Attr attr : this.attrsList.keySet()) {
                    StreamingC14NImpl.this.buf.writeByte(32);
                    if (attr.getPrefix() != null && attr.getPrefix().length() > 0) {
                        StreamingC14NImpl.this.buf.writeString(attr.getPrefix(), false, false);
                        StreamingC14NImpl.this.buf.writeByte(58);
                        StreamingC14NImpl.this.buf.writeString(attr.getLocalName(), false, false);
                    } else {
                        StreamingC14NImpl.this.buf.writeString(attr.getNodeName(), false, false);
                    }
                    StreamingC14NImpl.this.buf.writeByte(61);
                    StreamingC14NImpl.this.buf.writeByte(34);
                    StreamingC14NImpl.this.buf.writeString(attr.getNodeValue(), true, false);
                    StreamingC14NImpl.this.buf.writeByte(34);
                }
                this.attrsList = null;
            }
            if (this.elemIncluded) {
                StreamingC14NImpl.this.buf.writeByte(62);
            }
            if (xmlDebugC14N) {
                StreamingC14NImpl.this.debugIndent = StreamingC14NImpl.this.debugIndent + " ";
            }
        }

        private final void processEnd() {
            if (xmlDebugC14N) {
                StreamingC14NImpl.this.debugIndent = StreamingC14NImpl.this.debugIndent.substring(1);
                System.err.println(StreamingC14NImpl.this.debugIndent + "ElementEnd:" + this.elemPrefix + ":" + this.elemLocalName);
            }
            if (!this.elemIncluded) {
                return;
            }
            BufWriter bufWriter = StreamingC14NImpl.this.buf;
            StreamingC14NImpl.this.buf;
            bufWriter.writeBytes(BufWriter.Selem);
            if (this.elemPrefix != null && this.elemPrefix.length() > 0) {
                StreamingC14NImpl.this.buf.writeString(this.elemPrefix, false, false);
                StreamingC14NImpl.this.buf.writeByte(58);
            }
            StreamingC14NImpl.this.buf.writeString(this.elemLocalName, false, false);
            StreamingC14NImpl.this.buf.writeByte(62);
        }
    }

    public static class AttrObj
    implements Attr {
        String attribPrefix;
        String attribNsUri;
        String attribLocalName;
        String attribValue;
        String attribName;

        public AttrObj(String attribNsUri, String attribPrefix, String attribLocalName, String attribName, String attribValue) {
            this.attribNsUri = attribNsUri;
            this.attribPrefix = attribPrefix;
            this.attribLocalName = attribLocalName;
            this.attribName = attribName;
            this.attribValue = attribValue;
            if (attribName == null && attribLocalName != null && (attribPrefix == null || attribPrefix.length() == 0)) {
                this.attribName = attribLocalName;
            }
        }

        private void computeNodeValue() {
            if (this.attribName == null && this.attribLocalName != null) {
                this.attribName = this.attribPrefix == null || this.attribPrefix.length() == 0 ? this.attribLocalName : this.attribPrefix + ":" + this.attribLocalName;
            }
        }

        @Override
        public String getName() {
            this.computeNodeValue();
            return this.attribName;
        }

        @Override
        public String getValue() {
            return this.attribValue;
        }

        @Override
        public String getLocalName() {
            return this.attribLocalName;
        }

        @Override
        public String getNamespaceURI() {
            return this.attribNsUri;
        }

        @Override
        public String getNodeName() {
            this.computeNodeValue();
            return this.attribName;
        }

        @Override
        public short getNodeType() {
            return 2;
        }

        @Override
        public String getNodeValue() {
            return this.attribValue;
        }

        @Override
        public String getPrefix() {
            return this.attribPrefix;
        }

        @Override
        public void setValue(String value) {
        }

        @Override
        public Element getOwnerElement() {
            return null;
        }

        @Override
        public boolean getSpecified() {
            return false;
        }

        @Override
        public Node appendChild(Node child) throws DOMException {
            return null;
        }

        @Override
        public Node cloneNode(boolean arg0) {
            return null;
        }

        @Override
        public NamedNodeMap getAttributes() {
            return null;
        }

        @Override
        public NodeList getChildNodes() {
            return null;
        }

        @Override
        public Node getFirstChild() {
            return null;
        }

        @Override
        public Node getLastChild() {
            return null;
        }

        @Override
        public Node getNextSibling() {
            return null;
        }

        @Override
        public Document getOwnerDocument() {
            return null;
        }

        @Override
        public Node getParentNode() {
            return null;
        }

        @Override
        public Node getPreviousSibling() {
            return null;
        }

        @Override
        public boolean hasAttributes() {
            return false;
        }

        @Override
        public boolean hasChildNodes() {
            return false;
        }

        @Override
        public Node insertBefore(Node arg0, Node arg1) throws DOMException {
            return null;
        }

        @Override
        public boolean isSupported(String arg0, String arg1) {
            return false;
        }

        @Override
        public void normalize() {
        }

        @Override
        public Node removeChild(Node arg0) throws DOMException {
            return null;
        }

        @Override
        public Node replaceChild(Node arg0, Node arg1) throws DOMException {
            return null;
        }

        @Override
        public void setNodeValue(String arg0) throws DOMException {
        }

        @Override
        public void setPrefix(String arg0) throws DOMException {
        }

        @Override
        public TypeInfo getSchemaTypeInfo() {
            return null;
        }

        @Override
        public boolean isId() {
            return false;
        }

        @Override
        public short compareDocumentPosition(Node other) throws DOMException {
            return 0;
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public Object getFeature(String feature, String version) {
            return null;
        }

        @Override
        public String getTextContent() throws DOMException {
            return null;
        }

        @Override
        public Object getUserData(String key) {
            return null;
        }

        @Override
        public boolean isDefaultNamespace(String namespaceURI) {
            return false;
        }

        @Override
        public boolean isEqualNode(Node arg) {
            return false;
        }

        @Override
        public boolean isSameNode(Node other) {
            return false;
        }

        @Override
        public String lookupNamespaceURI(String prefix) {
            return null;
        }

        @Override
        public String lookupPrefix(String namespaceURI) {
            return null;
        }

        @Override
        public void setTextContent(String textContent) throws DOMException {
        }

        @Override
        public Object setUserData(String key, Object data, UserDataHandler handler) {
            return null;
        }

        public String toString() {
            return this.getNodeName() + "= \"" + this.getNodeValue() + "\"";
        }
    }

    public static class AttrComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            String nm2;
            Attr a1 = (Attr)o1;
            Attr a2 = (Attr)o2;
            String ns1 = a1.getNamespaceURI();
            String ns2 = a2.getNamespaceURI();
            if (ns1 == null && ns2 == null) {
                return a1.getNodeName().compareTo(a2.getNodeName());
            }
            if (ns1 == null) {
                ns1 = "";
            }
            if (ns2 == null) {
                ns2 = "";
            }
            String nm1 = a1.getLocalName() == null ? a1.getNodeName() : a1.getLocalName();
            String string = nm2 = a2.getLocalName() == null ? a2.getNodeName() : a2.getLocalName();
            if (ns1.equals(ns2)) {
                return nm1.compareTo(nm2);
            }
            return ns1.compareTo(ns2);
        }
    }

    public static class StreamingInclusiveCommentsC14N11Impl
    extends StreamingC14NImpl {
        public StreamingInclusiveCommentsC14N11Impl() {
            super(false, true, true);
        }
    }

    public static class StreamingInclusiveC14N11Impl
    extends StreamingC14NImpl {
        public StreamingInclusiveC14N11Impl() {
            super(false, false, true);
        }
    }

    public static class StreamingExclusiveCommentsC14NImpl
    extends StreamingC14NImpl {
        public StreamingExclusiveCommentsC14NImpl() {
            super(true, true);
        }

        public StreamingExclusiveCommentsC14NImpl(XSAlgorithmIdentifier c14nMethod) {
            super(true, true);
            this.setInclusiveNSPrefixList(StreamingExclusiveCommentsC14NImpl.getInclusiveNamespacesList(c14nMethod));
        }
    }

    public static class StreamingExclusiveC14NImpl
    extends StreamingC14NImpl {
        public StreamingExclusiveC14NImpl() {
            super(true, false);
        }

        public StreamingExclusiveC14NImpl(XSAlgorithmIdentifier c14nMethod) {
            super(true, false);
            this.setInclusiveNSPrefixList(StreamingExclusiveC14NImpl.getInclusiveNamespacesList(c14nMethod));
        }
    }

    public static class StreamingInclusiveCommentsC14NImpl
    extends StreamingC14NImpl {
        public StreamingInclusiveCommentsC14NImpl() {
            super(false, true);
        }
    }

    public static class StreamingInclusiveC14NImpl
    extends StreamingC14NImpl {
        public StreamingInclusiveC14NImpl() {
            super(false, false);
        }
    }
}

