/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.c14n;

import java.io.InputStream;
import java.util.Collection;
import oracle.security.xmlsec.c14n.C14NImpl;
import oracle.security.xmlsec.c14n.CanonicalizationException;
import oracle.security.xmlsec.c14n.Canonicalizer;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ExclusiveC14N
extends Canonicalizer {
    private C14NImpl c14nImpl;
    private String inclusiveNSList;

    public ExclusiveC14N() {
        this.c14nImpl = new C14NImpl(false, true);
    }

    ExclusiveC14N(boolean withComments) {
        this.c14nImpl = new C14NImpl(withComments, true);
    }

    public ExclusiveC14N(String inclusiveNSList) {
        this.c14nImpl = new C14NImpl(false, true);
        this.inclusiveNSList = inclusiveNSList;
        if (inclusiveNSList != null) {
            this.c14nImpl.setInclusiveNamespacePrefixList(inclusiveNSList);
        }
    }

    ExclusiveC14N(boolean withComments, String inclusiveNSList) {
        this.c14nImpl = new C14NImpl(withComments, true);
        this.inclusiveNSList = inclusiveNSList;
        if (inclusiveNSList != null) {
            this.c14nImpl.setInclusiveNamespacePrefixList(inclusiveNSList);
        }
    }

    public ExclusiveC14N(XSAlgorithmIdentifier c14nMethod) {
        super(c14nMethod);
        if (!"http://www.w3.org/2001/10/xml-exc-c14n#".equals(c14nMethod.getAlgorithm())) {
            throw new IllegalArgumentException("Algorithm URI invalid for exclusiveC14N");
        }
        this.c14nImpl = new C14NImpl(false, true);
        this.inclusiveNSList = ExclusiveC14N.processParameter(c14nMethod);
        if (this.inclusiveNSList != null) {
            this.c14nImpl.setInclusiveNamespacePrefixList(this.inclusiveNSList);
        }
    }

    static String processParameter(XSAlgorithmIdentifier c14nMethod) throws IllegalArgumentException {
        NodeList pList = c14nMethod.getParameters();
        if (pList.getLength() == 1) {
            Element param = (Element)pList.item(0);
            if (!"InclusiveNamespaces".equals(param.getLocalName()) && !"InclusiveNamespaces".equals(param.getTagName())) {
                throw new IllegalArgumentException("Illegal CanonicalizationMethod parameter");
            }
            if (param.hasAttribute("PrefixList")) {
                return param.getAttribute("PrefixList");
            }
            return null;
        }
        if (pList.getLength() > 0) {
            throw new IllegalArgumentException("Illegal CanonicalizationMethod parameter");
        }
        return null;
    }

    @Override
    public void setInclusiveNSPrefixList(String inclusiveNSList) {
        this.inclusiveNSList = inclusiveNSList;
        if (inclusiveNSList != null) {
            this.c14nImpl.setInclusiveNamespacePrefixList(inclusiveNSList);
        }
    }

    @Override
    public String getInclusiveNSPrefixList() {
        return this.inclusiveNSList;
    }

    @Override
    public byte[] canonicalize(Node source) throws CanonicalizationException {
        return this.c14nImpl.canonicalize(source);
    }

    @Override
    public byte[] canonicalize(NodeList source) throws CanonicalizationException {
        return this.c14nImpl.canonicalize(source);
    }

    @Override
    public byte[] canonicalize(Collection source) throws CanonicalizationException {
        return this.c14nImpl.canonicalize(source);
    }

    @Override
    public byte[] canonicalize(InputStream source) throws CanonicalizationException {
        return this.c14nImpl.canonicalize(source);
    }

    @Override
    public byte[] canonicalize(InputStream source, String systemId) throws CanonicalizationException {
        return this.c14nImpl.canonicalize(source, systemId);
    }

    @Override
    public byte[] canonicalize(InputSource source) throws CanonicalizationException {
        return this.c14nImpl.canonicalize(source);
    }
}

