/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.print.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JComponent;
import oracle.ide.print.api.PrintPage;
import oracle.ide.print.core.Graphix;
import oracle.ide.print.misc.Config;
import oracle.ide.print.misc.Macro;
import oracle.ide.print.misc.Util;

final class Paper
extends JComponent {
    private int myNumber;
    private double myScale;
    private PrintPage myPage;
    private boolean myIsPainting;
    private int myPaperWidth;
    private int myPaperHeight;
    private int myPageX;
    private int myPageY;
    private int myPageWidth;
    private int myPageHeight;
    private int myHeaderY;
    private boolean myHasHeader;
    private String myHeaderLeft;
    private String myHeaderCenter;
    private String myHeaderRight;
    private Color myHeaderColor;
    private Font myHeaderFont;
    private int myFooterY;
    private boolean myHasFooter;
    private String myFooterLeft;
    private String myFooterCenter;
    private String myFooterRight;
    private Color myFooterColor;
    private Font myFooterFont;
    private boolean myHasBorder;
    private Color myBorderColor;
    private String myName;
    private String myCount;
    private String myRowNumber;
    private String myColumnNumber;
    private int myRow;
    private int myColumn;
    private static final int NUMBER_FONT_SIZE = 35;
    private static final int SHADOW_WIDTH = 10;
    private static final int NUMBER_X = Util.round(35.0);
    private static final int NUMBER_Y = Util.round(52.5);
    private static final Color NUMBER_FONT_COLOR = new Color(125, 125, 255);
    private static final String AUTHOR = System.getProperty("user.name");
    private static final Font NUMBER_FONT_NAME = new Font("Serif", 1, 35);

    Paper(PrintPage page, String name) {
        this.myPage = page;
        this.myName = name;
        this.myPaperWidth = Util.getConfig().getPaperWidth();
        this.myPaperHeight = Util.getConfig().getPaperHeight();
        this.myPageX = Util.getConfig().getPageX();
        this.myPageY = Util.getConfig().getPageY();
        this.myPageWidth = Util.getConfig().getPageWidth();
        this.myPageHeight = Util.getConfig().getPageHeight();
        this.myHasBorder = Util.getConfig().hasBorder();
        this.myBorderColor = Util.getConfig().getBorderColor();
        this.myIsPainting = true;
    }

    void setCoordinate(int number, int row, int column, double scale) {
        this.myNumber = number;
        this.myRow = row;
        this.myColumn = column;
        this.myRowNumber = String.valueOf(row + 1);
        this.myColumnNumber = String.valueOf(column + 1);
        this.setScale(scale);
    }

    void setCount(int count) {
        this.myCount = String.valueOf(count);
        this.myHeaderY = Util.getConfig().getHeaderY();
        this.myHasHeader = Util.getConfig().hasHeader();
        this.myHeaderLeft = this.expandTitle(Util.getConfig().getHeaderLeft());
        this.myHeaderCenter = this.expandTitle(Util.getConfig().getHeaderCenter());
        this.myHeaderRight = this.expandTitle(Util.getConfig().getHeaderRight());
        this.myHeaderColor = Util.getConfig().getHeaderColor();
        this.myHeaderFont = Util.getConfig().getHeaderFont();
        this.myFooterY = Util.getConfig().getFooterY();
        this.myHasFooter = Util.getConfig().hasFooter();
        this.myFooterLeft = this.expandTitle(Util.getConfig().getFooterLeft());
        this.myFooterCenter = this.expandTitle(Util.getConfig().getFooterCenter());
        this.myFooterRight = this.expandTitle(Util.getConfig().getFooterRight());
        this.myFooterColor = Util.getConfig().getFooterColor();
        this.myFooterFont = Util.getConfig().getFooterFont();
    }

    int getRow() {
        return this.myRow;
    }

    int getColumn() {
        return this.myColumn;
    }

    void setScale(double scale) {
        this.myScale = scale;
        if (this.myIsPainting) {
            this.setPreferredSize(new Dimension(Util.round((double)(this.myPaperWidth + 10) * this.myScale), Util.round((double)(this.myPaperHeight + 10) * this.myScale)));
        } else {
            this.setPreferredSize(new Dimension(this.myPaperWidth, this.myPaperHeight));
        }
    }

    int getPaperWidth() {
        return this.myPaperWidth + 10;
    }

    int getPaperHeight() {
        return this.myPaperHeight + 10;
    }

    @Override
    public void print(Graphics g) {
        this.myIsPainting = false;
        this.setScale(1.0);
        super.print(g);
        this.myIsPainting = true;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D g = Graphix.adjustGraphics(graphics);
        if (this.myIsPainting) {
            g.scale(this.myScale, this.myScale);
        }
        g.setColor(Color.white);
        g.fillRect(this.myPageX, this.myPageY, this.myPageWidth, this.myPageHeight);
        g.translate(this.myPageX, this.myPageY);
        this.myPage.print(g);
        g.translate(-this.myPageX, -this.myPageY);
        g.setColor(Color.white);
        g.fillRect(0, 0, this.myPaperWidth, this.myPageY);
        g.fillRect(0, this.myPageY + this.myPageHeight, this.myPaperWidth, this.myPaperHeight);
        if (this.myHasHeader) {
            this.drawTitle(g, this.myHeaderLeft, this.myHeaderCenter, this.myHeaderRight, this.myHeaderY, this.myHeaderColor, this.myHeaderFont);
        }
        if (this.myHasFooter) {
            this.drawTitle(g, this.myFooterLeft, this.myFooterCenter, this.myFooterRight, this.myFooterY, this.myFooterColor, this.myFooterFont);
        }
        g.setColor(Color.white);
        g.fillRect(0, 0, this.myPageX, this.myPaperHeight);
        g.fillRect(this.myPageX + this.myPageWidth, 0, this.myPaperWidth, this.myPaperHeight);
        if (this.myIsPainting) {
            g.setColor(Color.gray.darker());
            g.fillRect(this.myPaperWidth, 10, 11, this.myPaperHeight);
            g.fillRect(10, this.myPaperHeight, this.myPaperWidth, 11);
            g.setColor(Color.lightGray);
            g.fillRect(this.myPaperWidth, 0, 11, 11);
            g.fillRect(0, this.myPaperHeight, 11, 11);
        }
        if (this.myIsPainting) {
            g.setColor(Color.black);
            g.drawRect(0, 0, this.myPaperWidth, this.myPaperHeight);
        }
        if (this.myHasBorder) {
            g.setColor(this.myBorderColor);
            g.drawRect(this.myPageX, this.myPageY, this.myPageWidth, this.myPageHeight);
        }
        if (this.myIsPainting) {
            g.setColor(NUMBER_FONT_COLOR);
            g.setFont(NUMBER_FONT_NAME);
            g.drawString(Integer.toString(this.myNumber), NUMBER_X, NUMBER_Y);
        }
    }

    private void drawTitle(Graphics2D g, String left, String center, String right, int y, Color color, Font f) {
        g.setColor(color);
        this.drawTitle(g, left, this.myPageX, y, f);
        this.drawTitle(g, center, this.myPageX + (this.myPageWidth - this.getWidth(center, f)) / 2, y, f);
        this.drawTitle(g, right, this.myPageX + this.myPageWidth - this.getWidth(right, f), y, f);
    }

    private void drawTitle(Graphics2D g, String text, int x, int y, Font font) {
        g.setFont(font);
        g.drawString(text, x, y);
    }

    private String expandTitle(String t) {
        Date timestamp = new Date(System.currentTimeMillis());
        t = this.replace(t, Macro.NAME.getName(), this.myName);
        t = this.replace(t, Macro.ROW.getName(), this.myRowNumber);
        t = this.replace(t, Macro.COLUMN.getName(), this.myColumnNumber);
        t = this.replace(t, Macro.AUTHOR.getName(), AUTHOR);
        t = this.replace(t, Macro.COUNT.getName(), this.myCount);
        t = this.replace(t, Macro.DATE.getName(), this.getDate(timestamp));
        t = this.replace(t, Macro.TIME.getName(), this.getTime(timestamp));
        return t;
    }

    private int getWidth(String text, Font font) {
        return Util.round(font.getStringBounds(text, Config.FONT_RENDER_CONTEXT).getWidth());
    }

    private String getDate(Date timestamp) {
        return this.getTimestamp(timestamp, "yyyy.MM.dd");
    }

    private String getTime(Date timestamp) {
        return this.getTimestamp(timestamp, "HH:mm:ss");
    }

    private String getTimestamp(Date timestamp, String format) {
        return new SimpleDateFormat(format).format(timestamp);
    }

    private String replace(String source, String searchFor, String replaceWith) {
        if (source == null) {
            return null;
        }
        if (searchFor == null || searchFor.length() == 0) {
            return null;
        }
        int k = 0;
        int found = source.indexOf(searchFor, k);
        StringBuilder builder = new StringBuilder();
        while (found != -1) {
            builder.append(source.substring(k, found));
            builder.append(replaceWith);
            k = found + searchFor.length();
            found = source.indexOf(searchFor, k);
        }
        if (k > 0) {
            builder.append(source.substring(k));
            return builder.toString();
        }
        return source;
    }
}

