/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.mongodb.jdbc;

import oracle.dbtools.thirdparty.mongodb.jdbc.Criteria;
import oracle.dbtools.thirdparty.mongodb.jdbc.MongoResultSet;

public class NoSQL {
    public static final int NOLIMIT = -1;
    public static final int EMPTYLIMIT = -2;
    private static String GETCOLLECTIONNAMES = "db.getCollectionNames()";
    private static String EVAL = "/*eval*/";
    private static String EVALTABLE = "/*eval table*/";
    private static String TABLE = "/*table*/";
    private static String COMMAND = "{";
    private String _stmt = null;
    private String _collection = null;
    private Criteria _criteria = null;
    private Task _task = null;
    private MongoResultSet.RESULTSETTYPE _resultSetType = MongoResultSet.RESULTSETTYPE.doc;
    private int _limit = -1;

    public NoSQL(String string) {
        this._stmt = string;
        if (string.startsWith(TABLE)) {
            string = string.substring(TABLE.length());
            this._resultSetType = MongoResultSet.RESULTSETTYPE.table;
        }
        if (string.startsWith(EVALTABLE)) {
            this._task = Task.EVAL;
            this._stmt = string.substring(EVALTABLE.length());
            this._resultSetType = MongoResultSet.RESULTSETTYPE.table;
        } else if (GETCOLLECTIONNAMES.equals(string)) {
            this._task = Task.GETCOLLECTIONNAMES;
        } else if (string.startsWith(EVAL)) {
            this._task = Task.EVAL;
            this._stmt = string.substring(EVAL.length());
        } else if (string.startsWith(COMMAND)) {
            this._task = Task.COMMAND;
            this._stmt = string.substring(COMMAND.length(), string.length() - 1);
        } else {
            String[] stringArray = string.split("(?<!system)\\.(?!(users)|(version))");
            if ((stringArray.length == 3 || stringArray.length == 4 && stringArray[3].startsWith("limit(")) && stringArray[0].equals("db")) {
                String string2;
                this._collection = stringArray[1];
                if (stringArray[2].startsWith("find(")) {
                    this._task = Task.FIND;
                    if (!stringArray[2].equals("find()")) {
                        string2 = stringArray[2];
                        String[] stringArray2 = (string2 = string2.substring(string2.indexOf("(") + 1, string2.lastIndexOf(")"))).split(",");
                        if (stringArray2.length == 2) {
                            String string3 = stringArray2[0];
                            String string4 = stringArray2[1];
                        } else {
                            String string5 = stringArray2[0];
                            this._criteria = new Criteria(string5);
                        }
                    }
                } else if (stringArray[2].startsWith("stats(")) {
                    this._task = Task.STATS;
                }
                if (stringArray.length == 4 && stringArray[3].startsWith("limit(")) {
                    string2 = stringArray[3].substring(6, stringArray[3].length() - 1);
                    this._limit = Integer.parseInt(string2);
                }
            }
        }
        if (this._task == null) {
            this._task = Task.EVAL;
        }
    }

    public String getCollection() {
        return this._collection;
    }

    public Criteria getCriteria() {
        return this._criteria;
    }

    public Task getTask() {
        return this._task;
    }

    public boolean hasCriteria() {
        return this.getCriteria() != null;
    }

    public String getStmt() {
        return this._stmt;
    }

    public MongoResultSet.RESULTSETTYPE getResultSetType() {
        return this._resultSetType;
    }

    public int getLimit() {
        return this._limit;
    }

    public static enum Task {
        GETCOLLECTIONNAMES,
        FIND,
        STATS,
        EVAL,
        COMMAND,
        UNKNOWN;

    }
}

