/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.mongodb.jdbc;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoDatabase;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import oracle.dbtools.thirdparty.mongodb.jdbc.MongoDatabaseMetadata;
import oracle.dbtools.thirdparty.mongodb.jdbc.MongoPreparedStatement;
import oracle.dbtools.thirdparty.mongodb.jdbc.MongoStatement;
import oracle.dbtools.thirdparty.mongodb.jdbc.MongoURL;
import oracle.dbtools.thirdparty.mongodb.jdbc.abstractdef.AMongoConnection;

public class MongoConnection
extends AMongoConnection {
    private MongoURL _mongoURL = null;
    private MongoClient _mongoClient = null;
    private MongoDatabase _mongoDB = null;

    public MongoConnection(String string, Properties properties) throws SQLException {
        this._mongoURL = new MongoURL(string);
        MongoCredential mongoCredential = null;
        if (properties.containsKey("user") && properties.get("user") != null) {
            String string2 = (String)properties.get("user");
            char[] cArray = ((String)properties.get("password")).toCharArray();
            mongoCredential = MongoCredential.createCredential((String)string2, (String)"admin", (char[])cArray);
            this._mongoClient = new MongoClient(new ServerAddress(this._mongoURL.getServer(), this._mongoURL.getPort()), mongoCredential, MongoClientOptions.builder().build());
        } else {
            this._mongoClient = new MongoClient(this._mongoURL.getServer(), this._mongoURL.getPort());
        }
        this._mongoDB = this._mongoClient.getDatabase(this._mongoURL.getDatabase());
    }

    public MongoDatabase getMongoDB() {
        return this._mongoDB;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new MongoStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        return new MongoPreparedStatement(this, string);
    }

    @Override
    public String getSchema() throws SQLException {
        return this._mongoDB.getName();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new MongoDatabaseMetadata(this);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this._mongoDB.getName();
    }

    @Override
    public void close() throws SQLException {
        if (this._mongoClient != null) {
            this._mongoClient.close();
            this._mongoClient = null;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._mongoClient == null;
    }
}

