/*
 * Decompiled with CFR 0.152.
 */
package oracle.soda.rdbms.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.json.logging.OracleLog;
import oracle.soda.OracleBatchException;
import oracle.soda.OracleException;
import oracle.soda.rdbms.impl.SODAMessage;
import oracle.soda.rdbms.impl.SQLTextCarrier;

public final class SODAUtils {
    private static final Logger log = Logger.getLogger(SODAUtils.class.getName());

    public static OracleException makeException(SODAMessage sODAMessage, Object ... objectArray) {
        return new OracleException(sODAMessage.get(objectArray), sODAMessage.getKey());
    }

    static OracleException makeException(SODAMessage sODAMessage, Throwable throwable, Object ... objectArray) {
        return new OracleException(sODAMessage.get(objectArray), throwable, sODAMessage.getKey());
    }

    static OracleBatchException makeBatchException(SODAMessage sODAMessage, int n, Object ... objectArray) {
        return new OracleBatchException(sODAMessage.get(objectArray), sODAMessage.getKey(), n);
    }

    static OracleBatchException makeBatchException(Throwable throwable, int n) {
        return new OracleBatchException(throwable, n);
    }

    static OracleException makeExceptionWithSQLText(Throwable throwable, String string) {
        return SODAUtils.makeExceptionWithSQLText(null, throwable, string, new Object[0]);
    }

    static OracleException makeExceptionWithSQLText(SODAMessage sODAMessage, Throwable throwable, String string, Object ... objectArray) {
        class OracleSQLException
        extends OracleException
        implements SQLTextCarrier {
            String sqlText;

            public OracleSQLException(String string, Throwable throwable, int n, String string2) {
                super(string, throwable, n);
                this.sqlText = string2;
            }

            public OracleSQLException(Throwable throwable, String string) {
                super(throwable);
                this.sqlText = string;
            }

            @Override
            public String getSQL() {
                return this.sqlText;
            }
        }
        if (sODAMessage != null) {
            return new OracleSQLException(sODAMessage.get(objectArray), throwable, sODAMessage.getKey(), string);
        }
        return new OracleSQLException(throwable, string);
    }

    static OracleBatchException makeBatchExceptionWithSQLText(Throwable throwable, int n, String string) {
        class OracleBatchSQLException
        extends OracleBatchException
        implements SQLTextCarrier {
            String sqlText;

            public OracleBatchSQLException(Throwable throwable, int n, String string) {
                super(throwable, n);
                this.sqlText = string;
            }

            @Override
            public String getSQL() {
                return this.sqlText;
            }
        }
        return new OracleBatchSQLException(throwable, n, string);
    }

    public static List<String> closeCursor(Statement statement, ResultSet resultSet) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            arrayList.add(sQLException.getMessage());
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            arrayList.add(sQLException.getMessage());
        }
        return arrayList;
    }

    public static boolean sqlSyntaxBelow_12_2(SQLSyntaxLevel sQLSyntaxLevel) {
        return sQLSyntaxLevel == SQLSyntaxLevel.SQL_SYNTAX_12_1;
    }

    public static boolean sqlSyntaxBelow_18(SQLSyntaxLevel sQLSyntaxLevel) {
        if (SODAUtils.sqlSyntaxBelow_12_2(sQLSyntaxLevel)) {
            return true;
        }
        return SODAUtils.sqlSyntax_12_2_0_1(sQLSyntaxLevel);
    }

    public static boolean sqlSyntaxBelow_19(SQLSyntaxLevel sQLSyntaxLevel) {
        if (SODAUtils.sqlSyntaxBelow_12_2(sQLSyntaxLevel)) {
            return true;
        }
        if (SODAUtils.sqlSyntax_12_2_0_1(sQLSyntaxLevel)) {
            return true;
        }
        return SODAUtils.sqlSyntax_18(sQLSyntaxLevel);
    }

    public static boolean sqlSyntaxBelow_21(SQLSyntaxLevel sQLSyntaxLevel) {
        if (SODAUtils.sqlSyntaxBelow_19(sQLSyntaxLevel)) {
            return true;
        }
        if (SODAUtils.sqlSyntax_19(sQLSyntaxLevel)) {
            return true;
        }
        return SODAUtils.sqlSyntax_20(sQLSyntaxLevel);
    }

    public static boolean sqlSyntax_18(SQLSyntaxLevel sQLSyntaxLevel) {
        return sQLSyntaxLevel == SQLSyntaxLevel.SQL_SYNTAX_18;
    }

    public static boolean sqlSyntax_19(SQLSyntaxLevel sQLSyntaxLevel) {
        return sQLSyntaxLevel == SQLSyntaxLevel.SQL_SYNTAX_19;
    }

    public static boolean sqlSyntax_20(SQLSyntaxLevel sQLSyntaxLevel) {
        return sQLSyntaxLevel == SQLSyntaxLevel.SQL_SYNTAX_20;
    }

    public static boolean sqlSyntax_12_2_0_1(SQLSyntaxLevel sQLSyntaxLevel) {
        return sQLSyntaxLevel == SQLSyntaxLevel.SQL_SYNTAX_12_2_0_1;
    }

    public static SQLSyntaxLevel getDatabaseVersion(Connection connection) throws SQLException {
        DatabaseMetaData databaseMetaData;
        DatabaseMetaData databaseMetaData2 = databaseMetaData = connection == null ? null : connection.getMetaData();
        if (databaseMetaData == null) {
            return SQLSyntaxLevel.SQL_SYNTAX_UNKNOWN;
        }
        int n = databaseMetaData.getDatabaseMajorVersion();
        int n2 = databaseMetaData.getDatabaseMinorVersion();
        if (n == 12) {
            if (n2 > 1) {
                return SQLSyntaxLevel.SQL_SYNTAX_12_2_0_1;
            }
            return SQLSyntaxLevel.SQL_SYNTAX_12_1;
        }
        if (n == 18) {
            return SQLSyntaxLevel.SQL_SYNTAX_18;
        }
        if (n == 19) {
            return SQLSyntaxLevel.SQL_SYNTAX_19;
        }
        if (n == 20) {
            return SQLSyntaxLevel.SQL_SYNTAX_20;
        }
        if (n == 21) {
            return SQLSyntaxLevel.SQL_SYNTAX_21;
        }
        return SQLSyntaxLevel.SQL_SYNTAX_UNKNOWN;
    }

    public static SQLSyntaxLevel getSQLSyntaxLevel(Connection connection, SQLSyntaxLevel sQLSyntaxLevel) throws OracleException {
        try {
            if (sQLSyntaxLevel == SQLSyntaxLevel.SQL_SYNTAX_UNKNOWN) {
                sQLSyntaxLevel = SODAUtils.getDatabaseVersion(connection);
            }
        }
        catch (Exception exception) {
            if (OracleLog.isLoggingEnabled()) {
                log.severe(exception.getMessage());
            }
            throw SODAUtils.makeException(SODAMessage.EX_UNABLE_TO_GET_DB_VERSION, exception, new Object[0]);
        }
        return sQLSyntaxLevel;
    }

    public static enum SQLSyntaxLevel {
        SQL_SYNTAX_UNKNOWN,
        SQL_SYNTAX_12_1,
        SQL_SYNTAX_12_2_0_1,
        SQL_SYNTAX_18,
        SQL_SYNTAX_19,
        SQL_SYNTAX_20,
        SQL_SYNTAX_21;

    }
}

