/*
 * Decompiled with CFR 0.152.
 */
package oracle.soda.rdbms;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.json.common.JsonFactoryProvider;
import oracle.json.common.MetricsCollector;
import oracle.soda.OracleClient;
import oracle.soda.OracleDatabase;
import oracle.soda.OracleException;
import oracle.soda.rdbms.OracleRDBMSMetadataBuilder;
import oracle.soda.rdbms.impl.CollectionDescriptor;
import oracle.soda.rdbms.impl.OracleDatabaseImpl;
import oracle.soda.rdbms.impl.SODAMessage;
import oracle.soda.rdbms.impl.SODAUtils;
import oracle.soda.rdbms.impl.cache.CacheOfDescriptorCaches;
import oracle.soda.rdbms.impl.cache.DescriptorCache;
import oracle.soda.rdbms.impl.cache.SynchronizedCacheOfDescriptorCaches;

public class OracleRDBMSClient
implements OracleClient {
    private CacheOfDescriptorCaches cacheOfDescriptorCaches;
    private boolean localMetadataCache;
    private final MetricsCollector mcollector = new MetricsCollector();
    private JsonFactoryProvider jProvider = new JsonFactoryProvider();
    private static final Logger log = Logger.getLogger(OracleRDBMSClient.class.getName());

    public OracleRDBMSClient() {
    }

    public OracleRDBMSClient(Properties properties) {
        this();
        if (properties != null) {
            String string = properties.getProperty("oracle.soda.sharedMetadataCache");
            String string2 = properties.getProperty("oracle.soda.localMetadataCache");
            if (string != null && string.equalsIgnoreCase("true")) {
                this.cacheOfDescriptorCaches = new SynchronizedCacheOfDescriptorCaches(100, 100);
            }
            if (string2 != null && string2.equalsIgnoreCase("true")) {
                this.localMetadataCache = true;
            }
        }
    }

    @Override
    public OracleDatabase getDatabase(Connection connection) throws OracleException {
        return this.getDatabase(connection, false);
    }

    @Override
    public OracleDatabase getDatabase(Connection connection, boolean bl) throws OracleException {
        String string;
        OracleConnection oracleConnection;
        block8: {
            oracleConnection = null;
            string = null;
            try {
                if (connection instanceof OracleConnection) {
                    oracleConnection = (OracleConnection)connection;
                    break block8;
                }
                if (connection.isWrapperFor(OracleConnection.class)) {
                    oracleConnection = connection.unwrap(OracleConnection.class);
                    break block8;
                }
                throw SODAUtils.makeException(SODAMessage.EX_NOT_ORACLE_CONNECTION, new Object[0]);
            }
            catch (SQLException sQLException) {
                throw new OracleException(sQLException);
            }
        }
        DescriptorCache descriptorCache = null;
        if (this.cacheOfDescriptorCaches != null) {
            try {
                DatabaseMetaData databaseMetaData = oracleConnection.getMetaData();
                string = databaseMetaData.getURL();
                string = string + "/";
                String string2 = oracleConnection.getUserName();
                if (string2 == null) {
                    throw SODAUtils.makeException(SODAMessage.EX_UNABLE_TO_FETCH_USER_NAME, new Object[0]);
                }
                string = string + string2;
            }
            catch (Exception exception) {
                throw new OracleException(exception);
            }
            descriptorCache = this.cacheOfDescriptorCaches.putIfAbsentAndGet(string);
        }
        return new OracleDatabaseImpl(oracleConnection, descriptorCache, this.mcollector, this.localMetadataCache, bl, this.jProvider);
    }

    public OracleRDBMSMetadataBuilder createMetadataBuilder() {
        return CollectionDescriptor.createStandardBuilder();
    }
}

