/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.parser;

import oracle.json.parser.PathParser;
import oracle.json.parser.QueryException;
import oracle.json.parser.QueryMessage;

public class JsonQueryPath {
    private String[] steps = null;
    private String path = null;
    private boolean arrayEnd = false;
    private boolean arrayBegin = false;
    private boolean expandArray = false;

    private boolean isArrayStep(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return false;
        }
        return string.charAt(0) == '[';
    }

    private void processSteps(int n) {
        if (this.steps == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(n + this.steps.length);
        for (int i = 0; i < this.steps.length; ++i) {
            this.arrayEnd = this.isArrayStep(this.steps[i]);
            if (i == 0) {
                this.arrayBegin = this.arrayEnd;
            } else if (!this.arrayEnd) {
                stringBuilder.append(".");
            }
            stringBuilder.append(this.steps[i]);
        }
        this.path = stringBuilder.toString();
    }

    public JsonQueryPath(String[] stringArray) {
        this.steps = stringArray;
        this.processSteps(100);
    }

    public JsonQueryPath(String string) throws QueryException {
        if (string != null) {
            this.steps = new PathParser(string).splitAndSQLEscape();
            if (this.steps == null) {
                throw new QueryException(QueryMessage.EX_BAD_PATH.get(string));
            }
            if (this.steps.length == 0) {
                throw new QueryException(QueryMessage.EX_EMPTY_PATH.get(string));
            }
            this.processSteps(string.length());
        }
    }

    public JsonQueryPath() throws QueryException {
        this((String)null);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        JsonQueryPath jsonQueryPath = (JsonQueryPath)object;
        if (this.path == jsonQueryPath.path) {
            return true;
        }
        if (jsonQueryPath.steps == null || this.steps == null) {
            return false;
        }
        if (jsonQueryPath.steps.length != this.steps.length) {
            return false;
        }
        for (int i = 0; i < this.steps.length; ++i) {
            if (this.steps[i].equals(jsonQueryPath.steps[i])) continue;
            return false;
        }
        return true;
    }

    void setArrayExpansion() {
        this.expandArray = true;
    }

    String toQueryString(boolean bl) {
        String string = this.path == null ? "" : (this.arrayBegin ? this.path : "." + this.path);
        if (bl) {
            string = string + "[*]";
        }
        return string;
    }

    String toQueryString() {
        return this.toQueryString(this.expandArray);
    }

    String toQueryString(String string) {
        String string2 = this.toQueryString();
        if (string != null) {
            string2 = string2 + "." + string + "()";
        }
        return string2;
    }

    public void toLaxString(StringBuilder stringBuilder) {
        this.toLaxString(stringBuilder, false);
    }

    public void toLaxString(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("$");
        for (String string : this.steps) {
            if (this.isArrayStep(string)) continue;
            stringBuilder.append(".");
            stringBuilder.append(string);
        }
        if (bl) {
            stringBuilder.append("[*]");
        }
    }

    public boolean hasArraySteps() {
        if (this.steps != null) {
            for (String string : this.steps) {
                if (!this.isArrayStep(string)) continue;
                return true;
            }
        }
        return false;
    }

    public void toSingletonString(StringBuilder stringBuilder) {
        this.toSingletonString(stringBuilder, false);
    }

    public void toSingletonString(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("$");
        for (String string : this.steps) {
            if (this.isArrayStep(string)) continue;
            stringBuilder.append(".");
            stringBuilder.append(string);
            if (!bl) continue;
            stringBuilder.append("[0]");
        }
    }

    public String[] getSteps() {
        return this.steps;
    }

    public int hashCode() {
        if (this.path == null) {
            return 0;
        }
        return this.path.hashCode();
    }

    public String toString() {
        return this.path;
    }
}

