/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.common;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashSet;
import java.util.logging.Logger;
import oracle.json.common.ResourceCloser;

public class ResourceManager
implements ResourceCloser {
    private static final Logger log = Logger.getLogger(ResourceManager.class.getName());
    private final HashSet<Closeable> openResources = new HashSet();

    @Override
    public void register(Closeable closeable) {
        this.openResources.add(closeable);
    }

    @Override
    public void unregister(Closeable closeable) {
        if (this.openResources != null) {
            this.openResources.remove(closeable);
        }
    }

    public void closeAll() {
        if (this.openResources != null) {
            for (Closeable closeable : this.openResources) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    log.warning(iOException.toString());
                }
            }
            this.openResources.clear();
        }
    }
}

