/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.dragdrop;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMException;
import ilog.views.sdm.IlvSDMModel;
import ilog.views.sdm.renderer.IlvRendererUtil;
import ilog.views.sdm.renderer.IlvSDMRenderer;
import ilog.views.sdm.renderer.IlvStyleSheetRenderer;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import oracle.diagram.framework.dragdrop.event.DiagramDropTargetDragEvent;
import oracle.diagram.framework.dragdrop.event.DiagramDropTargetDropEvent;
import oracle.diagram.framework.dragdrop.event.DiagramDropTargetEvent;
import oracle.diagram.framework.dragdrop.handler.DropHandler;
import oracle.diagram.framework.readonly.ReadOnlyUtil;
import oracle.diagram.sdm.context.SDMDiagramContextUtil;
import oracle.diagram.sdm.datatransfer.SDMTransferable;

public class SDMDropHandler
implements DropHandler {
    private final DataFlavor _flavor;

    public SDMDropHandler() {
        this(SDMTransferable.DEFAULT_FLAVOR);
    }

    public SDMDropHandler(DataFlavor flavor) {
        this._flavor = flavor;
    }

    @Override
    public void dragEnter(DiagramDropTargetDragEvent dtde) {
        dtde.acceptDrag(2);
    }

    @Override
    public void dragExit(DiagramDropTargetEvent dte) {
    }

    @Override
    public void dragOver(DiagramDropTargetDragEvent dtde) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(DiagramDropTargetDropEvent dtde) {
        IlvGrapher parentGraphic;
        IlvManagerView view = dtde.getView();
        IlvSDMEngine engine = SDMDiagramContextUtil.getSDMEngine(view);
        IlvSDMModel model = engine.getModel();
        DataFlavor flavor = this.getDataFlavor();
        IlvPoint location = dtde.getLocation(null);
        Transferable t = dtde.getTransferable();
        if (t == null || !t.isDataFlavorSupported(flavor)) {
            dtde.rejectDrop();
            return;
        }
        Object parent = engine.isDropToGroupEnabled() ? engine.getParent(view, location.x, location.y, true) : null;
        Object object = parentGraphic = parent != null ? engine.getGraphic(parent, true) : engine.getGrapher();
        if (!ReadOnlyUtil.checkWritableDrop(dtde.getDiagramContext(), (IlvGraphic)parentGraphic, t)) {
            dtde.rejectDrop();
            return;
        }
        try {
            engine.setAdjusting(true);
            dtde.acceptDrop(2);
            String data = (String)t.getTransferData(flavor);
            ByteArrayInputStream bais = new ByteArrayInputStream(data.getBytes());
            if (parent != null) {
                engine.getXMLConnector().setParent(parent);
            }
            Enumeration e = engine.getXMLConnector().readXML(model, (InputStream)new BufferedInputStream(bais), true, null);
            ArrayList els = new ArrayList(64);
            String cssClass = this.getCSSClassPropertyName(engine);
            while (e.hasMoreElements()) {
                Object obj1 = e.nextElement();
                if (model.isLink(obj1) && model.getParent(obj1) == parent && cssClass != null) {
                    model.setObjectProperty(model.getFrom(obj1), cssClass, (Object)"anchor");
                    model.setObjectProperty(model.getTo(obj1), cssClass, (Object)"anchor");
                }
                if (model.getParent(obj1) != parent) continue;
                els.add(obj1);
            }
            IlvRect rect = null;
            for (Object obj2 : els) {
                IlvGraphic g = engine.getGraphic(obj2, true);
                if (g == null) continue;
                IlvRect bbox = g.boundingBox(null);
                if (rect == null) {
                    rect = bbox;
                    continue;
                }
                rect.add(bbox);
            }
            if (rect != null) {
                IlvPoint point = new IlvPoint(location);
                point.x -= rect.x + rect.width / 2.0f;
                point.y -= rect.y + rect.height / 2.0f;
                for (Object obj3 : els) {
                    IlvGraphic g;
                    if (model.getParent(obj3) != parent || (g = engine.getGraphic(obj3, true)) == null) continue;
                    IlvRect rect2 = g.boundingBox(null);
                    engine.moveObject(obj3, null, rect2.x + point.x, rect2.y + point.y, false, 5, true);
                }
            }
            dtde.getDropTargetContext().dropComplete(true);
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        catch (UnsupportedFlavorException ufex) {
            ufex.printStackTrace();
        }
        catch (IlvSDMException sdmex) {
            sdmex.printStackTrace();
        }
        finally {
            engine.setAdjusting(false);
        }
    }

    @Override
    public void dropActionChanged(DiagramDropTargetDragEvent dtde) {
    }

    @Override
    public DataFlavor getDataFlavor() {
        return this._flavor;
    }

    private String getCSSClassPropertyName(IlvSDMEngine engine) {
        IlvSDMRenderer renderer = IlvRendererUtil.getRenderer((IlvSDMEngine)engine, (String)"StyleSheet");
        if (renderer != null && renderer instanceof IlvStyleSheetRenderer) {
            return ((IlvStyleSheetRenderer)renderer).getCssClassPropertyName();
        }
        return null;
    }
}

