/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.view;

import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.event.ManagerChangedEvent;
import ilog.views.event.ManagerChangedListener;
import ilog.views.event.ManagerContentChangedEvent;
import ilog.views.event.ManagerContentChangedListener;
import ilog.views.event.TransformerChangedEvent;
import ilog.views.event.TransformerListener;
import ilog.views.graphic.IlvText;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;

public class HintTextDecoration {
    private IlvManagerView _view;
    private IlvManager _manager;
    private Listener _listener;
    private String _hintString;
    private IlvText _hintTextGraphic;
    private boolean _isEmpty;
    private boolean _needsIsEmptyRecalc;
    private boolean _needsPositionRecalc;
    protected static final Font HINT_FONT = new Font("SansSerif", 1, 20);
    protected static final Color IHINT_FOREGROUND = Color.gray;
    protected static final float HINT_WRAPPING_WIDTH = 275.0f;

    protected HintTextDecoration(IlvManagerView view, String hint) {
        this._view = view;
        this._hintString = hint;
        this._manager = this._view.getManager();
        this._isEmpty = false;
        this._needsIsEmptyRecalc = true;
        this._needsPositionRecalc = true;
        this._listener = new Listener();
        this._view.addComponentListener((ComponentListener)this._listener);
        this._view.addTransformerListener((TransformerListener)this._listener);
        this._view.addManagerChangedListener((ManagerChangedListener)this._listener);
        this._manager.addManagerContentChangedListener((ManagerContentChangedListener)this._listener);
    }

    public void clean() {
        if (this._manager != null) {
            this._manager.removeManagerContentChangedListener((ManagerContentChangedListener)this._listener);
            this._manager = null;
        }
        if (this._view != null) {
            this._view.removeComponentListener((ComponentListener)this._listener);
            this._view.removeTransformerListener((TransformerListener)this._listener);
            this._view.removeManagerChangedListener((ManagerChangedListener)this._listener);
            this._view = null;
        }
        this._listener = null;
        this._hintTextGraphic = null;
    }

    protected final boolean isEmpty() {
        return this._isEmpty;
    }

    protected final IlvManagerView getView() {
        return this._view;
    }

    protected final void updateCachedEmptyState() {
        this._isEmpty = this.isViewEmpty(this.getView());
        this._needsIsEmptyRecalc = false;
    }

    protected final boolean requiresIsEmptyRecalc() {
        return this._needsIsEmptyRecalc;
    }

    protected final boolean requiresPositionRecalc() {
        return this._needsPositionRecalc;
    }

    protected final void updateCachedPosition(IlvTransformer tx) {
        this._needsPositionRecalc = false;
        Dimension viewSize = this.getView().getSize();
        if (viewSize.width > 0 && viewSize.height > 0) {
            IlvText graphic = this.getHintTextGraphic();
            IlvRect graphicRect = graphic.boundingBox();
            IlvRect viewRect = new IlvRect(0.0f, 0.0f, (float)viewSize.width, (float)viewSize.height);
            float x = Math.max(0.0f, viewRect.x + viewRect.width / 2.0f - graphicRect.width / 2.0f);
            float y = Math.max(0.0f, viewRect.y + viewRect.height / 2.0f - graphicRect.height / 2.0f);
            IlvPoint p = new IlvPoint(x, y);
            tx.inverse(p);
            graphic.move(p.x, p.y);
        }
    }

    protected boolean isViewEmpty(IlvManagerView view) {
        boolean isEmpty = true;
        IlvManager mgr = view.getManager();
        if (mgr.getCardinal(true) > 0) {
            IlvGraphicEnumeration e = mgr.getObjects(true);
            while (e.hasMoreElements()) {
                if (!e.nextElement().isVisible()) continue;
                isEmpty = false;
                break;
            }
        }
        return isEmpty;
    }

    protected IlvText createHintTextGraphic(String hintString) {
        IlvText hintTextGraphic = new IlvText();
        hintTextGraphic.setLabel(hintString);
        hintTextGraphic.setAntialiasing(true);
        hintTextGraphic.setFont(HINT_FONT);
        hintTextGraphic.setForeground(IHINT_FOREGROUND);
        hintTextGraphic.setAlignment(16);
        hintTextGraphic.setWrappingMode((short)1);
        hintTextGraphic.setWrappingWidth(275.0f);
        hintTextGraphic.setFractionalMetrics(false);
        return hintTextGraphic;
    }

    protected IlvText getHintTextGraphic() {
        if (this._hintTextGraphic == null) {
            this._hintTextGraphic = this.createHintTextGraphic(this._hintString);
        }
        return this._hintTextGraphic;
    }

    private class Listener
    extends ComponentAdapter
    implements ManagerContentChangedListener,
    TransformerListener,
    ManagerChangedListener {
        private Listener() {
        }

        public void contentsChanged(ManagerContentChangedEvent event) {
            int type = event.getType();
            if (type == 1 || type == 2) {
                HintTextDecoration.this._needsIsEmptyRecalc = true;
                HintTextDecoration.this._needsPositionRecalc = true;
                HintTextDecoration.this._manager.reDraw();
            }
        }

        @Override
        public void componentResized(ComponentEvent componentevent) {
            HintTextDecoration.this._needsPositionRecalc = true;
            HintTextDecoration.this._manager.reDraw();
        }

        public void transformerChanged(TransformerChangedEvent event) {
            HintTextDecoration.this._manager.reDraw();
        }

        public void managerChanged(ManagerChangedEvent event) {
            IlvManager oldMgr = event.getOldValue();
            IlvManager newMgr = event.getNewValue();
            if (oldMgr != null) {
                oldMgr.removeManagerContentChangedListener((ManagerContentChangedListener)HintTextDecoration.this._listener);
                HintTextDecoration.this._manager = null;
            }
            HintTextDecoration.this._needsIsEmptyRecalc = true;
            HintTextDecoration.this._needsPositionRecalc = true;
            if (newMgr != null) {
                HintTextDecoration.this._manager = newMgr;
                newMgr.addManagerContentChangedListener((ManagerContentChangedListener)HintTextDecoration.this._listener);
                newMgr.reDraw();
            }
        }
    }
}

