/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.toolbar;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.ide.controls.CustomColorChoice;
import oracle.ide.controls.ToolbarItem;

public class DiagramColorChoiceToolButton
extends CustomColorChoice
implements MouseListener,
ToolbarItem {
    private boolean localChange = false;
    private PropertyChangeListener m_enableStateListener;
    private PropertyChangeListener m_colorChangeListener;
    Action m_action;

    public DiagramColorChoiceToolButton(Action action) {
        this.m_action = action;
        this.setHorizontalAlignment(0);
        this.setFocusable(false);
        this.setFocusPainted(false);
        this.setDefaultAllowed(true);
        this.setToolTipText((String)action.getValue("Name"));
        this.m_action.setEnabled(true);
        this.addActionListener(this.m_action);
        this.m_enableStateListener = new EnableStateChangeListener();
        this.m_action.addPropertyChangeListener(this.m_enableStateListener);
        this.m_colorChangeListener = new ColorChangeListener();
        this.addPropertyChangeListener(this.m_colorChangeListener);
    }

    public void quietlySetSelectedColor(Color c) {
        try {
            this.localChange = true;
            this.setSelectedColor(c);
        }
        finally {
            this.localChange = false;
        }
    }

    public Action getAction() {
        return this.m_action;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void dispose() {
        if (this.m_action != null) {
            Action a = this.m_action;
            a.removePropertyChangeListener(this.m_enableStateListener);
            this.removePropertyChangeListener(this.m_colorChangeListener);
            this.m_action = null;
            this.removeActionListener(a);
        }
        ArrayTwoDModel emptyArrayTwoDModel = new ArrayTwoDModel(0, 0);
        this.getColorPalettePane().setColorPalette((TwoDModel)emptyArrayTwoDModel);
        this.setCustomColorPalette((TwoDModel)emptyArrayTwoDModel);
        this.setColorPalette((TwoDModel)emptyArrayTwoDModel);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.localChange = true;
        this.setSelectedColor(null);
        this.localChange = false;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private class ColorChangeListener
    implements PropertyChangeListener {
        private ColorChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (!DiagramColorChoiceToolButton.this.localChange) {
                ActionEvent ae = null;
                boolean unpress = false;
                if (prop == "selectedColor") {
                    if (!DiagramColorChoiceToolButton.this.isDefaultSelected()) {
                        ae = new ActionEvent(this, 1001, (String)DiagramColorChoiceToolButton.this.m_action.getValue("Name"));
                    }
                } else if (prop == "defaultSelected") {
                    ae = new ActionEvent(this, 1001, (String)DiagramColorChoiceToolButton.this.m_action.getValue("Name"));
                    unpress = true;
                }
                if (ae != null) {
                    DiagramColorChoiceToolButton.this.m_action.actionPerformed(ae);
                }
                if (unpress) {
                    try {
                        SwingUtilities.invokeLater(new UnpressDefault());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private class EnableStateChangeListener
    implements PropertyChangeListener {
        private EnableStateChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop.equals("enabled")) {
                DiagramColorChoiceToolButton.this.setEnabled((Boolean)e.getNewValue());
            }
        }
    }

    private class UnpressDefault
    implements Runnable {
        private UnpressDefault() {
        }

        @Override
        public void run() {
            DiagramColorChoiceToolButton.this.localChange = true;
            DiagramColorChoiceToolButton.this.setDefaultSelected(false);
            DiagramColorChoiceToolButton.this.localChange = false;
        }
    }
}

