/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.toolbar;

import java.awt.Component;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.framework.action.Actions;
import oracle.diagram.framework.action.handler.ZoomFitToWindowHandler;
import oracle.diagram.framework.action.handler.ZoomInHandler;
import oracle.diagram.framework.action.handler.ZoomOutHandler;
import oracle.diagram.framework.action.handler.ZoomPercentageHandler;
import oracle.diagram.framework.action.handler.ZoomSelectedHandler;
import oracle.diagram.framework.controller.modular.ModularController;
import oracle.diagram.framework.toolbar.AbstractToolbarPlugin;
import oracle.diagram.framework.toolbar.ZoomComboBox;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.view.View;

public class DefaultDiagramToolbarPlugin
extends AbstractToolbarPlugin {
    private IdeAction _zoomIn = null;
    private IdeAction _zoomOut = null;
    private ZoomComboBox _zoomList;
    private final Controller _controller = new MyController();
    private final Controller[] _handlers = this.createHandlers();
    private final DiagramContext _context;

    public DefaultDiagramToolbarPlugin(DiagramContext context) {
        this._context = context;
    }

    protected final DiagramContext getDiagramContext() {
        return this._context;
    }

    @Override
    protected void installControllerItems(ModularController mc) {
        mc.register(Actions.CMD_ZOOM_IN, this._controller);
        mc.register(Actions.CMD_ZOOM_OUT, this._controller);
        mc.register(Actions.CMD_ZOOM_400_PERCENT, this._controller);
        mc.register(Actions.CMD_ZOOM_200_PERCENT, this._controller);
        mc.register(Actions.CMD_ZOOM_150_PERCENT, this._controller);
        mc.register(Actions.CMD_ZOOM_125_PERCENT, this._controller);
        mc.register(Actions.CMD_ZOOM_100_PERCENT, this._controller);
        mc.register(Actions.CMD_ZOOM_75_PERCENT, this._controller);
        mc.register(Actions.CMD_ZOOM_50_PERCENT, this._controller);
        mc.register(Actions.CMD_ZOOM_40_PERCENT, this._controller);
        mc.register(Actions.CMD_ZOOM_25_PERCENT, this._controller);
        mc.register(Actions.CMD_ZOOM_15_PERCENT, this._controller);
        mc.register(Actions.CMD_ZOOM_10_PERCENT, this._controller);
        mc.register(Actions.CMD_ZOOM_5_PERCENT, this._controller);
        mc.register(Actions.CMD_ZOOM_SELECTED, this._controller);
        mc.register(Actions.CMD_ZOOM_FIT_TO_WINDOW, this._controller);
    }

    @Override
    public void update(Context context) {
        super.update(context);
        if (this._zoomIn != null) {
            this._zoomIn.updateAction(context);
        }
        if (this._zoomOut != null) {
            this._zoomOut.updateAction(context);
        }
        if (this._zoomList != null) {
            this._zoomList.updateZoomDisplay();
        }
    }

    @Override
    protected Toolbar createToolbarImpl(View view) {
        Toolbar tb = new Toolbar();
        this._zoomIn = Actions.ZOOM_IN.newLocalAction(view);
        this._zoomOut = Actions.ZOOM_OUT.newLocalAction(view);
        tb.add((ToggleAction)this._zoomIn);
        tb.add((ToggleAction)this._zoomOut);
        this._zoomList = new ZoomComboBox(view, this.getDiagramContext().getManagerView());
        tb.add((Component)this._zoomList);
        return tb;
    }

    protected Controller[] createHandlers() {
        return new Controller[]{new ZoomInHandler(), new ZoomOutHandler(), new ZoomSelectedHandler(), new ZoomFitToWindowHandler(), new ZoomPercentageHandler()};
    }

    @Override
    protected void disposeImpl() {
        super.disposeImpl();
        if (this._zoomList != null) {
            this._zoomList.dispose();
        }
        this._zoomIn = null;
        this._zoomOut = null;
    }

    private final class MyController
    implements Controller {
        private MyController() {
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (DefaultDiagramToolbarPlugin.this._handlers != null) {
                for (int i = 0; i < DefaultDiagramToolbarPlugin.this._handlers.length; ++i) {
                    if (!DefaultDiagramToolbarPlugin.this._handlers[i].handleEvent(ideAction, context)) continue;
                    DefaultDiagramToolbarPlugin.this.update(context);
                    return true;
                }
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            if (DefaultDiagramToolbarPlugin.this._handlers != null) {
                for (int i = 0; i < DefaultDiagramToolbarPlugin.this._handlers.length; ++i) {
                    if (!DefaultDiagramToolbarPlugin.this._handlers[i].update(ideAction, context)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

