/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.swimlanes.palette;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import java.awt.Dimension;
import java.awt.dnd.DragSource;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Iterator;
import oracle.diagram.core.util.IlvGraphicEnumerationFromIterator;
import oracle.diagram.framework.graphic.layout.column.ColumnContainer;
import oracle.diagram.framework.graphic.layout.row.RowContainer;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.palette.PaletteTask;
import oracle.diagram.framework.palette.interactor.MakeNodeInteractor;
import oracle.diagram.framework.palette.interactor.NodeItemFactory;
import oracle.diagram.framework.swimlanes.SwimlanesPlugin;
import oracle.diagram.framework.swimlanes.graphic.ExtendedSwimlaneGraphic;
import oracle.diagram.framework.swimlanes.graphic.SwimlaneGraphic;
import oracle.ide.palette2.PaletteItem;

public class DiagramMakeNodeInSwimlaneInteractor
extends MakeNodeInteractor {
    private IlvGraphic _swimlaneSubHit;
    private SwimlaneGraphic _swimlaneTarget;
    private IlvRect _swimlaneRect;
    private IlvPoint _mutableStartPoint;
    private IlvRect _mutableDragRect;

    public DiagramMakeNodeInSwimlaneInteractor(PaletteTask task, NodeItemFactory factory) {
        super(task, factory);
    }

    @Override
    protected boolean handleButtonDown(MouseEvent event) {
        boolean rc = super.handleButtonDown(event);
        this._mutableStartPoint = new IlvPoint(super.getStartPoint());
        this._mutableDragRect = new IlvRect(super.getDraggedRectangle());
        if (!this.isRotationAllowed()) {
            this.getManagerView().getTransformer().inverse(this._mutableDragRect);
        }
        return rc;
    }

    @Override
    protected boolean handleButtonDragged(MouseEvent event) {
        IlvPoint p = new IlvPoint((float)event.getX(), (float)event.getY());
        this.getManagerView().getTransformer().inverse(p);
        float x0 = Math.min(p.x, this._mutableStartPoint.x);
        float x1 = Math.max(p.x, this._mutableStartPoint.x);
        float y0 = Math.min(p.y, this._mutableStartPoint.y);
        float y1 = Math.max(p.y, this._mutableStartPoint.y);
        this._mutableDragRect.setRect(x0, y0, x1 - x0, y1 - y0);
        return super.handleButtonDragged(event);
    }

    protected IlvPoint getStartPoint() {
        return new IlvPoint(this._mutableStartPoint);
    }

    public IlvRect getDraggedRectangle() {
        IlvRect r = new IlvRect(this._mutableDragRect);
        if (!this.isRotationAllowed()) {
            this.getManagerView().getTransformer().apply(r);
        }
        return r;
    }

    private void preResize(IlvGraphic g, IlvRect reshapeRect) {
        if (this._swimlaneTarget != null) {
            SwimlaneGraphic topSwimlane = this._swimlaneTarget.getTopSwimlane();
            int flowDirection = topSwimlane.getFlowDirection();
            Dimension size = this.getNodeItemFactory().getPreferredSize();
            Dimension minSize = this.getNodeItemFactory().getMinimumSize();
            if (!topSwimlane.isAutoExpand() || flowDirection == 8) {
                if (reshapeRect.y < this._swimlaneRect.y) {
                    reshapeRect.height = Math.max((float)size.height, reshapeRect.y + reshapeRect.height - this._swimlaneRect.y);
                    reshapeRect.y = this._swimlaneRect.y;
                } else {
                    reshapeRect.height = Math.max((float)size.height, reshapeRect.height);
                }
                if (reshapeRect.y + reshapeRect.height > this._swimlaneRect.y + this._swimlaneRect.height) {
                    reshapeRect.height = Math.max((float)size.height, this._swimlaneRect.y + this._swimlaneRect.height - reshapeRect.y);
                    if (reshapeRect.y + reshapeRect.height > this._swimlaneRect.y + this._swimlaneRect.height) {
                        reshapeRect.y = this._swimlaneRect.y + this._swimlaneRect.height - reshapeRect.height - 1.0f;
                    }
                }
            }
            if (!topSwimlane.isAutoExpand() || flowDirection == 2) {
                if (reshapeRect.x < this._swimlaneRect.x) {
                    reshapeRect.width = Math.max((float)size.width, reshapeRect.x + reshapeRect.width - this._swimlaneRect.x);
                    reshapeRect.x = this._swimlaneRect.x;
                } else {
                    reshapeRect.width = Math.max((float)size.width, reshapeRect.width);
                }
                if (reshapeRect.x + reshapeRect.width > this._swimlaneRect.x + this._swimlaneRect.width) {
                    reshapeRect.width = Math.max((float)size.width, this._swimlaneRect.x + this._swimlaneRect.width - reshapeRect.x);
                    if (reshapeRect.x + reshapeRect.width > this._swimlaneRect.x + this._swimlaneRect.width) {
                        reshapeRect.x = this._swimlaneRect.x + this._swimlaneRect.width - reshapeRect.width - 1.0f;
                    }
                }
            }
            if (topSwimlane.isAutoExpand()) {
                IlvRect sgBBox = new IlvRect(this._swimlaneTarget.boundingBox(null));
                IlvRect sgIntBBox = this._swimlaneTarget.getInteriorBoundingBox(null);
                if (flowDirection == 8) {
                    if (sgIntBBox.x + sgIntBBox.width <= reshapeRect.x + reshapeRect.width) {
                        float newWidth = reshapeRect.x + reshapeRect.width + 1.0f + this._swimlaneTarget.getShapeLineThickness().floatValue() - sgBBox.x;
                        ColumnContainer container = (ColumnContainer)this._swimlaneTarget.getGraphicBag();
                        int index = container.getColumnGraphicIndex(this._swimlaneTarget);
                        container.resizeColumn(index, newWidth);
                    } else if (reshapeRect.x < sgIntBBox.x) {
                        float newWidth = sgBBox.x + sgBBox.width - (reshapeRect.x - (1.0f + this._swimlaneTarget.getShapeLineThickness().floatValue()));
                        float delta = sgBBox.width - newWidth;
                        ColumnContainer container = (ColumnContainer)this._swimlaneTarget.getGraphicBag();
                        int index = container.getColumnGraphicIndex(this._swimlaneTarget);
                        container.resizeColumn(index, newWidth);
                        IlvManager topManager = this.getManagerView().getManager();
                        SwimlanesPlugin plugin = this.getDiagramContext().getPlugin(SwimlanesPlugin.class);
                        HashSet<IlvGraphic> others = new HashSet<IlvGraphic>(plugin.getGraphicsInSwimlane(this._swimlaneTarget));
                        others.remove(g);
                        Iterator<IlvGraphic> i = others.iterator();
                        topManager.translateObjects((IlvGraphicEnumeration)new IlvGraphicEnumerationFromIterator(i), delta * -1.0f, 0.0f, null);
                        this._mutableStartPoint.x += delta * -1.0f;
                        this.getManagerView().translate((sgIntBBox.x - reshapeRect.x) * -1.0f, 0.0f, false);
                        reshapeRect.x = sgIntBBox.x;
                        reshapeRect.width = this.getStartPoint().x - reshapeRect.x;
                    }
                } else if (flowDirection == 2) {
                    if (sgIntBBox.y + sgIntBBox.height <= reshapeRect.y + reshapeRect.height) {
                        float newHeight = reshapeRect.y + reshapeRect.height + 1.0f + this._swimlaneTarget.getShapeLineThickness().floatValue() - sgBBox.y;
                        RowContainer container = (RowContainer)this._swimlaneTarget.getGraphicBag();
                        int index = container.getRowGraphicIndex(this._swimlaneTarget);
                        container.resizeRow(index, newHeight);
                    } else if (reshapeRect.y < sgIntBBox.y) {
                        float newHeight = sgBBox.y + sgBBox.height - (reshapeRect.y - (1.0f + this._swimlaneTarget.getShapeLineThickness().floatValue()));
                        float delta = sgBBox.height - newHeight;
                        RowContainer container = (RowContainer)this._swimlaneTarget.getGraphicBag();
                        int index = container.getRowGraphicIndex(this._swimlaneTarget);
                        container.resizeRow(index, newHeight);
                        IlvManager topManager = this.getManagerView().getManager();
                        SwimlanesPlugin plugin = this.getDiagramContext().getPlugin(SwimlanesPlugin.class);
                        HashSet<IlvGraphic> others = new HashSet<IlvGraphic>(plugin.getGraphicsInSwimlane(this._swimlaneTarget));
                        others.remove(g);
                        Iterator<IlvGraphic> i = others.iterator();
                        topManager.translateObjects((IlvGraphicEnumeration)new IlvGraphicEnumerationFromIterator(i), 0.0f, delta * -1.0f, null);
                        this._mutableStartPoint.y += delta * -1.0f;
                        this.getManagerView().translate(0.0f, (sgIntBBox.y - reshapeRect.y) * -1.0f, false);
                        reshapeRect.y = sgIntBBox.y;
                        reshapeRect.height = this.getStartPoint().y - reshapeRect.y;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void resizeObject(IlvGraphic g, IlvRect r) {
        IlvManagerView view = this.getManagerView();
        IlvManager topManager = view.getManager();
        topManager.setContentsAdjusting(true);
        topManager.initReDraws();
        int redrawMode = view.getRedrawMode();
        view.setRedrawMode(1);
        try {
            IlvRect reshapeRect = new IlvRect(r);
            this.preResize(g, reshapeRect);
            super.resizeObject(g, reshapeRect);
        }
        finally {
            topManager.setContentsAdjusting(false);
            try {
                view.setRedrawMode(1);
                topManager.reDrawViews();
            }
            finally {
                view.setRedrawMode(redrawMode);
            }
        }
    }

    @Override
    protected IlvGraphic makeObject(IlvRect r) {
        IlvGraphic g = super.makeObject(r);
        IlvRect reshapeRect = new IlvRect(g.boundingBox(null));
        this.preResize(g, reshapeRect);
        if (!reshapeRect.equals((Object)g.boundingBox(null))) {
            g.moveResize(reshapeRect);
        }
        return g;
    }

    @Override
    protected boolean handleMouseMove(MouseEvent event) {
        IlvGraphic oldTarget = this.getCurrentTarget();
        IlvGraphic oldSwimlaneSubHit = this._swimlaneSubHit;
        boolean rc = super.handleMouseMove(event);
        IlvGraphic newTarget = this.getCurrentTarget();
        IlvGraphic newSwimlaneSubHit = this._swimlaneSubHit;
        if (oldTarget == newTarget && oldSwimlaneSubHit != newSwimlaneSubHit) {
            this.updateTargetValidity(newTarget);
        }
        return rc;
    }

    @Override
    protected boolean isValidTarget(IlvGraphic target) {
        boolean isValid = super.isValidTarget(target);
        if (isValid && this._swimlaneSubHit != null) {
            SwimlaneGraphic topSwimlane;
            boolean bl = isValid = this._swimlaneTarget != null;
            if (isValid && !(topSwimlane = this._swimlaneTarget.getTopSwimlane()).isAutoExpand()) {
                int flowDirection = topSwimlane.getFlowDirection();
                Dimension size = this.getNodeItemFactory().getPreferredSize();
                if (flowDirection == 8) {
                    isValid = (float)size.width < this._swimlaneRect.width;
                } else if (flowDirection == 2) {
                    boolean bl2 = isValid = (float)size.height < this._swimlaneRect.height;
                }
            }
        }
        if (isValid) {
            SwimlanesPlugin plugin = this.getDiagramContext().getPlugin(SwimlanesPlugin.class);
            IlvManager mgr = this.getManagerView().getManager();
            if (plugin != null && plugin.getTopSwimlane(mgr) != null) {
                PaletteTask paletteTask = this.getPaletteTask();
                PaletteItem paletteItem = paletteTask.getPaletteItem();
                String nodeType = (String)paletteItem.getData((Object)"info");
                isValid = plugin.acceptNodeType(mgr, this._swimlaneTarget, nodeType);
            }
        }
        return isValid;
    }

    @Override
    protected IlvGraphic getHitObject(IlvPoint point, IlvManagerView view) {
        IlvGraphic hit = super.getHitObject(point, view);
        this._swimlaneSubHit = null;
        this._swimlaneTarget = null;
        this._swimlaneRect = null;
        if (hit instanceof SwimlaneGraphic) {
            IlvTransformer tx = ManagerUtil.getTransformingManager(hit).getDrawingTransformer(view);
            this._swimlaneSubHit = ((SwimlaneGraphic)hit).getSubShape(point, tx);
            if (this._swimlaneSubHit instanceof ExtendedSwimlaneGraphic) {
                this._swimlaneTarget = (SwimlaneGraphic)this._swimlaneSubHit;
                this._swimlaneRect = this._swimlaneTarget.getInteriorBoundingBox(null);
            }
            return this._swimlaneSubHit;
        }
        return hit;
    }

    @Override
    protected void updateCursor(IlvGraphic target, boolean valid) {
        if (!valid) {
            this.getManagerView().setCursor(DragSource.DefaultMoveNoDrop);
        } else {
            this.getManagerView().setCursor(this.getCursor());
        }
    }
}

