/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.swimlanes.graphic;

import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvLine;
import java.util.List;
import oracle.diagram.core.interaction.CompositeObjectInteractor;
import oracle.diagram.framework.geom.DimensionFloat;
import oracle.diagram.framework.graphic.ExtendedGraphic;
import oracle.diagram.framework.graphic.layout.column.ColumnContainer;
import oracle.diagram.framework.graphic.layout.column.ColumnLayout;
import oracle.diagram.framework.graphic.layout.column.ReorderColumnInteractor;
import oracle.diagram.framework.graphic.layout.column.ResizeColumnInteractor;
import oracle.diagram.framework.graphic.layout.column.ResizeColumnUndoableStep;
import oracle.diagram.framework.swimlanes.SwimlanesPermissions;
import oracle.diagram.framework.swimlanes.graphic.PoolGraphic;
import oracle.diagram.framework.swimlanes.graphic.SwimlaneGraphic;
import oracle.diagram.framework.undo.UndoableStep;

public class VerticalPoolGraphic
extends PoolGraphic
implements ColumnContainer {
    public VerticalPoolGraphic(IlvRect rect, List<SwimlaneGraphic> laneGraphics) {
        super(rect, new ColumnLayout(), laneGraphics);
        ((ColumnLayout)this.getLayout()).setMargins(0.0f, 0.0f, 0.0f, 0.0f);
        this.setObjectInteractor(new CompositeObjectInteractor(new ResizeColumnInteractor(), new ReorderColumnInteractor()));
    }

    @Override
    public int getFlowDirection() {
        return 8;
    }

    @Override
    public DimensionFloat getMinimumSwimlaneSize(DimensionFloat minimum) {
        DimensionFloat dim = super.getMinimumSwimlaneSize(minimum);
        if (!this._lanes.isEmpty()) {
            IlvRect poolBBox = this.boundingBox(null);
            SwimlaneGraphic lastLane = (SwimlaneGraphic)this._lanes.get(this._lanes.size() - 1);
            IlvRect lastLaneBBox = lastLane.boundingBox(null);
            DimensionFloat lastLaneMinSize = lastLane.getMinimumSwimlaneSize(new DimensionFloat());
            dim.width = poolBBox.width - lastLaneBBox.width + lastLaneMinSize.width;
        }
        return dim;
    }

    @Override
    public DimensionFloat getMinimumSize(DimensionFloat minimum) {
        DimensionFloat d = super.getMinimumSize(minimum);
        if (!this._lanes.isEmpty()) {
            IlvRect poolBBox = this.boundingBox(null);
            SwimlaneGraphic lastLane = (SwimlaneGraphic)this._lanes.get(this._lanes.size() - 1);
            IlvRect lastLaneBBox = lastLane.boundingBox(null);
            DimensionFloat lastLaneMinSize = lastLane.getMinimumSize(new DimensionFloat());
            d.width = poolBBox.width - lastLaneBBox.width + lastLaneMinSize.width;
        }
        ColumnLayout layout = (ColumnLayout)this.getLayout();
        d.height = d.height + layout.getTopMargin() + layout.getBottomMargin();
        d.width = d.width + layout.getLeftMargin() + layout.getRightMargin();
        return minimum;
    }

    @Override
    public DimensionFloat getPreferedSize(DimensionFloat prefered) {
        for (SwimlaneGraphic g : this._lanes) {
            DimensionFloat d = g.getPreferedSize(new DimensionFloat());
            prefered.width += d.width;
            prefered.height = Math.max(prefered.height, d.height);
        }
        for (IlvLine divider : this._dividers) {
            prefered.width += divider.getLineWidth();
        }
        ColumnLayout layout = (ColumnLayout)this.getLayout();
        prefered.height = prefered.height + layout.getTopMargin() + layout.getBottomMargin();
        prefered.width = prefered.width + layout.getLeftMargin() + layout.getRightMargin();
        return prefered;
    }

    @Override
    public int getColumnIndex(IlvLine divider) {
        return divider instanceof PoolGraphic.DividerLine ? this._dividers.indexOf((PoolGraphic.DividerLine)divider) : -1;
    }

    @Override
    public int getColumnGraphicIndex(ExtendedGraphic g) {
        return g instanceof SwimlaneGraphic ? this._lanes.indexOf((SwimlaneGraphic)g) : -1;
    }

    @Override
    public ExtendedGraphic getColumnGraphic(int index) {
        return (ExtendedGraphic)this._lanes.get(index);
    }

    @Override
    public void resizeColumn(int index, float newWidth) {
        SwimlaneGraphic lane = (SwimlaneGraphic)this._lanes.get(index);
        DimensionFloat preferredSize = lane.getPreferedSize(new DimensionFloat());
        preferredSize.width = newWidth;
        this.resizeLaneImpl(lane, preferredSize);
    }

    @Override
    public void deleteLane(SwimlaneGraphic lane) {
        this.deleteLaneImpl(lane, new DimensionFloat(lane.boundingBox(null).width * -1.0f, 0.0f));
    }

    @Override
    public void insertLane(SwimlaneGraphic lane, int index) {
        this.insertLaneImpl(lane, index, new DimensionFloat(lane.boundingBox(null).width, 0.0f));
    }

    @Override
    public DimensionFloat getMinimumColumnSize(int index, DimensionFloat dim) {
        return ((SwimlaneGraphic)this._lanes.get(index)).getMinimumSwimlaneSize(dim);
    }

    @Override
    public void moveColumn(int fromIndex, int toIndex) {
        this.moveLaneImpl(fromIndex, toIndex);
    }

    @Override
    public UndoableStep createLaneGraphicUndoableStep(SwimlaneGraphic lane) {
        return this.createLaneIndexUndoableStep(this.getColumnGraphicIndex(lane));
    }

    @Override
    public UndoableStep createLaneIndexUndoableStep(int index) {
        return new ResizeColumnUndoableStep(this, index){

            @Override
            protected void redoImpl() {
                SwimlaneGraphic topSwimlane = VerticalPoolGraphic.this.getTopSwimlane();
                boolean isEnabled = topSwimlane.getLayoutEventsEnabled();
                topSwimlane.setLayoutEventsEnabled(false);
                super.redoImpl();
                topSwimlane.setLayoutEventsEnabled(isEnabled);
            }
        };
    }

    @Override
    public boolean canResizeColumns() {
        SwimlanesPermissions permissions = this.getPermissions();
        if (permissions == null) {
            permissions = this.getTopSwimlane().getPermissions();
        }
        return permissions == null ? false : permissions.canResizeSwimlanes(this);
    }

    @Override
    public boolean canMoveColumn(int index) {
        SwimlanesPermissions permissions = this.getPermissions();
        if (permissions == null) {
            permissions = this.getTopSwimlane().getPermissions();
        }
        return permissions == null ? false : permissions.canMoveSwimlane(this, index);
    }

    @Override
    public boolean canMoveColumn(int fromIndex, int toIndex) {
        SwimlanesPermissions permissions = this.getPermissions();
        if (permissions == null) {
            permissions = this.getTopSwimlane().getPermissions();
        }
        return permissions == null ? false : permissions.canMoveSwimlane(this, fromIndex, toIndex);
    }

    @Override
    public ExtendedGraphic getColumnGraphic(IlvPoint pt, IlvTransformer t) {
        return this.getSwimlaneSubShape(pt, t);
    }
}

