/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.swimlanes.editor;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.editor.ScrollManagerViewPlugin;
import oracle.diagram.core.manager.CoreGrapher;
import oracle.diagram.core.manager.CoreManager;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.framework.geom.DimensionFloat;
import oracle.diagram.framework.graphic.FakeNode;
import oracle.diagram.framework.swimlanes.SwimlanesPlugin;
import oracle.diagram.framework.swimlanes.graphic.SwimlaneGraphic;

public class DefaultSwimlanesScrollManagerViewPlugin
extends AbstractPlugin
implements ScrollManagerViewPlugin {
    protected static final float _MARGIN = 200.0f;
    protected static final int _DEFAULT_BACKGROUND_LAYER = 0;

    protected int getBackgroundGraphicsLayer(IlvManagerView view) {
        IlvManager mgr = view.getManager();
        if (mgr instanceof CoreGrapher) {
            return ((CoreGrapher)mgr).getBackgroundGraphicsLayer();
        }
        if (mgr instanceof CoreManager) {
            return ((CoreManager)mgr).getBackgroundGraphicsLayer();
        }
        return 0;
    }

    @Override
    public boolean isThumbnailConstrained() {
        return true;
    }

    @Override
    public boolean constrainViewTransformer(IlvManagerView view, IlvTransformer t) {
        IlvPoint p = new IlvPoint(0.0f, 0.0f);
        t.apply(p);
        if (p.x > 0.0f || p.y > 0.0f) {
            float dx = p.x > 0.0f ? -1.0f * p.x : 0.0f;
            float dy = p.y > 0.0f ? -1.0f * p.y : 0.0f;
            t.translate((double)dx, (double)dy);
            return true;
        }
        return false;
    }

    protected IlvRect getManagerBoundingBox(IlvManagerView view) {
        int backgroundLayer = this.getBackgroundGraphicsLayer(view);
        IlvRect viewBBox = null;
        IlvManager mgr = view.getManager();
        IlvGraphicEnumeration e = mgr.getObjects(false);
        while (e.hasMoreElements()) {
            IlvGraphic g = e.nextElement();
            if (g instanceof IlvLinkImage || g instanceof FakeNode || mgr.getLayer(g) == backgroundLayer) continue;
            if (viewBBox == null) {
                viewBBox = new IlvRect(g.boundingBox(null));
                continue;
            }
            viewBBox.add(g.boundingBox(null));
        }
        return viewBBox == null ? new IlvRect() : viewBBox;
    }

    @Override
    public void adjustBackgroundGraphics(IlvManagerView view) {
        DiagramContext context = DiagramContext.getDiagramContext(view);
        SwimlanesPlugin plugin = context.getPlugin(SwimlanesPlugin.class);
        SwimlaneGraphic swimlaneGraphic = plugin.getTopSwimlane(view.getManager());
        IlvRect r = new IlvRect(0.0f, 0.0f, (float)view.getWidth(), (float)view.getHeight());
        view.getTransformer().inverse(r);
        IlvRect mgrRect = this.getManagerBoundingBox(view);
        DimensionFloat d = swimlaneGraphic.getPreferedSize(new DimensionFloat());
        int flowDirection = swimlaneGraphic.getFlowDirection();
        if (flowDirection == 2) {
            mgrRect.width += 200.0f;
            mgrRect.width += mgrRect.x;
            mgrRect.x = 0.0f;
            r.height = (float)d.getHeight();
            r.width += r.x;
        } else if (flowDirection == 8) {
            mgrRect.height += 200.0f;
            mgrRect.height += mgrRect.y;
            mgrRect.y = 0.0f;
            r.width = (float)d.getWidth();
            r.height += r.y;
        }
        r.x = 0.0f;
        r.y = 0.0f;
        mgrRect.add(r);
        view.getManager().reshapeObject((IlvGraphic)swimlaneGraphic, mgrRect, true);
    }

    @Override
    public IlvRect getScrollableRect(IlvManagerView view) {
        DiagramContext context = DiagramContext.getDiagramContext(view);
        SwimlanesPlugin plugin = context.getPlugin(SwimlanesPlugin.class);
        SwimlaneGraphic swimlaneGraphic = plugin.getTopSwimlane(view.getManager());
        IlvRect mgrRect = this.getManagerBoundingBox(view);
        DimensionFloat d = swimlaneGraphic.getPreferedSize(new DimensionFloat());
        int flowDirection = swimlaneGraphic.getFlowDirection();
        if (flowDirection == 2) {
            mgrRect.width += 200.0f;
            mgrRect.width += mgrRect.x;
            mgrRect.x = 0.0f;
            mgrRect.height = (float)d.getHeight();
            mgrRect.y = 0.0f;
        } else if (flowDirection == 8) {
            mgrRect.height += 200.0f;
            mgrRect.height += mgrRect.y;
            mgrRect.y = 0.0f;
            mgrRect.width = (float)d.getWidth();
            mgrRect.x = 0.0f;
        }
        view.getTransformer().apply(mgrRect);
        return mgrRect;
    }
}

