/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.readonly;

import ilog.views.IlvGraphic;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.context.IdeContextPlugin;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.framework.readonly.ReadOnlyPlugin;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.ide.vcs.VCSManager;
import oracle.ide.vcs.VCSTask;

public abstract class AbstractReadOnlyPlugin
extends AbstractPlugin
implements ReadOnlyPlugin {
    @Override
    public boolean isReadOnly(DiagramContext context, IlvGraphic g) {
        Element[] els = this.getElements(context.getPlugin(IdeContextPlugin.class).getContext(), g);
        if (els == null) {
            return false;
        }
        for (Element el : els) {
            URL url;
            if (!(el instanceof Locatable) || !URLFileSystem.exists((URL)(url = ((Locatable)el).getURL())) || !URLFileSystem.isReadOnly((URL)url)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isWritable(DiagramContext context, IlvGraphic g) {
        Element[] els = this.getElements(context.getPlugin(IdeContextPlugin.class).getContext(), g);
        if (els == null) {
            return true;
        }
        for (Element el : els) {
            URL url;
            if (!(el instanceof Locatable) || !URLFileSystem.exists((URL)(url = ((Locatable)el).getURL())) || !URLFileSystem.isReadOnly((URL)url)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean setWritable(DiagramContext context, IlvGraphic g) {
        Element[] els = this.getElements(context.getPlugin(IdeContextPlugin.class).getContext(), g);
        if (els == null) {
            return true;
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Element el : els) {
            if (!(el instanceof Locatable)) continue;
            urls.add(((Locatable)el).getURL());
        }
        if (!urls.isEmpty()) {
            try {
                if (!((Boolean)VCSManager.getVCSManager().checkOutUsingUI(new VCSTask(urls.toArray(new URL[0])){}).get()).booleanValue()) {
                    return false;
                }
            }
            catch (CancellationException ce) {
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    protected abstract Element[] getElements(Context var1, IlvGraphic var2);
}

