/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.preference.propertyeditor;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import oracle.bali.inspector.JavaBeansPropertyEditorAdapter;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.editor.EditorComponentInfo;
import oracle.bali.inspector.editor.PropertyValueApplier;
import oracle.bali.inspector.editor.ToStringConverter;

public class PropertyEditorFactory2Delegate
extends JavaBeansPropertyEditorAdapter {
    private PropertyEditorFactory2 _factory;
    private EditorComponentInfo _editorComponentInfo;
    private String _cachedStringValue;
    private boolean _isDetached;

    public PropertyEditorFactory2Delegate(PropertyEditorFactory2 factory) {
        this(factory, new DefaultPropertyEditor());
    }

    public PropertyEditorFactory2Delegate(PropertyEditorFactory2 factory, PropertyEditor pe) {
        super(pe);
        this._factory = factory;
        this._factory.setEditorComponentInfo(this._editorComponentInfo);
        this._editorComponentInfo = null;
        this._isDetached = false;
    }

    public void detachFromProperyEditor() {
        super.detachFromProperyEditor();
        this._cachedStringValue = this.getAsText();
        this._isDetached = true;
    }

    public void setValue(Object value) {
        if (!this._isDetached) {
            this._factory.setValue(value);
        }
    }

    public Object getValue() {
        return this._factory.getValue();
    }

    public void applyValueFrom(Component c) {
        this._factory.applyValueFrom(c);
    }

    public String getAsText() {
        return this._isDetached ? this._cachedStringValue : this._factory.getAsText();
    }

    public void setAsText(String text) {
        this._factory.setAsText(text);
    }

    public boolean isPaintable() {
        return this._factory.isPaintable();
    }

    public void paintValue(Graphics g, Rectangle r) {
        this._factory.paintValue(g, r);
    }

    public boolean hasInlineEditor() {
        return this._factory.hasInlineEditor();
    }

    public Component getInlineEditor() {
        return this._factory.getInlineEditor();
    }

    public EditorComponentInfo getEditorComponentInfo() {
        return this._factory.getEditorComponentInfo();
    }

    public void setEditorComponentInfo(EditorComponentInfo editorComponentInfo) {
        if (this._factory != null) {
            this._factory.setEditorComponentInfo(editorComponentInfo);
        } else {
            this._editorComponentInfo = editorComponentInfo;
        }
    }

    public PropertyValueApplier getPropertyValueApplier() {
        return this._factory.getPropertyValueApplier();
    }

    public void setPropertyValueApplier(PropertyValueApplier propertyValueApplier) {
        this._factory.setPropertyValueApplier(propertyValueApplier);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._factory.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._factory.removePropertyChangeListener(listener);
    }

    public void setSelectedItemToStringConverter(ToStringConverter selectedItemToStringConverter) {
        this._factory.setSelectedItemToStringConverter(selectedItemToStringConverter);
    }

    private static class DefaultPropertyEditor
    implements PropertyEditor {
        private DefaultPropertyEditor() {
        }

        @Override
        public void setValue(Object value) {
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public boolean isPaintable() {
            return false;
        }

        @Override
        public void paintValue(Graphics gfx, Rectangle box) {
        }

        @Override
        public String getJavaInitializationString() {
            return null;
        }

        @Override
        public String getAsText() {
            return null;
        }

        @Override
        public void setAsText(String text) {
        }

        @Override
        public String[] getTags() {
            return new String[0];
        }

        @Override
        public Component getCustomEditor() {
            return null;
        }

        @Override
        public boolean supportsCustomEditor() {
            return false;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }
    }
}

