/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.preference.propertyeditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import oracle.bali.inspector.PropertyModel;
import oracle.diagram.framework.preference.propertyeditor.DomainPropertyEditorImpl;
import oracle.diagram.framework.preference.propertyeditor.PropertyEditorFactoryDelegate;

public class DomainPropertyEditor
extends PropertyEditorFactoryDelegate {
    private TableCellRenderer _renderer = null;

    public DomainPropertyEditor(String[] content, Object[] domainValues, Class domainClass) {
        super(new DomainPropertyEditorImpl(content, domainValues), domainClass);
    }

    public DomainPropertyEditor(ResourceBundle rb, String baseKey, Object[] domainValues, Class domainClass) {
        super(new DomainPropertyEditorImpl(rb, baseKey, domainValues), domainClass);
    }

    @Override
    public final TableCellRenderer getValueRenderer() {
        if (this._renderer == null) {
            this._renderer = new DisplayValueRenderer();
        }
        return this._renderer;
    }

    private final class DisplayValueRenderer
    extends DefaultTableCellRenderer {
        private Border _noFocusBorder = new EmptyBorder(1, 2, 1, 2);

        private DisplayValueRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            PropertyModel model = (PropertyModel)table.getModel();
            value = model.getPropertyValue(row);
            Object[] domainValues = ((DomainPropertyEditorImpl)DomainPropertyEditor.this.getPropertyEditor()).getDomainValues();
            for (int i = 0; i < domainValues.length; ++i) {
                if (!domainValues[i].equals(value)) continue;
                value = DomainPropertyEditor.this.getPropertyEditor().getTags()[i];
                break;
            }
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!hasFocus && c instanceof JComponent) {
                JComponent component = (JComponent)c;
                Border b = UIManager.getBorder("Table.focusCellHighlightBorder");
                Insets i = b.getBorderInsets(component);
                if (!this._noFocusBorder.getBorderInsets(component).equals(i)) {
                    this._noFocusBorder = new EmptyBorder(i.top, i.left, i.bottom, i.right);
                }
                component.setBorder(this._noFocusBorder);
            }
            this.setOpaque(true);
            return c;
        }

        @Override
        public void paintComponent(Graphics g) {
            Rectangle r = this.getBounds();
            Color c = g.getColor();
            g.setColor(this.getBackground());
            g.fillRect(r.x, r.y, r.width, r.height);
            g.setColor(c);
            super.paintComponent(g);
        }
    }
}

