/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.palette.interactor;

import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.event.InteractorChangedEvent;
import ilog.views.event.InteractorListener;
import ilog.views.interactor.IlvPermanentInteractorInterface;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.framework.palette.PaletteTask;
import oracle.ide.palette2.PaletteItem;

public class InteractorPaletteTask
extends PaletteTask {
    private IlvManagerViewInteractor _interactor = null;
    private boolean _started = false;

    public InteractorPaletteTask(DiagramContext context, PaletteItem item) {
        this(context, item, null);
    }

    public InteractorPaletteTask(DiagramContext context, PaletteItem item, IlvManagerViewInteractor interactor) {
        super(context, item);
        this._interactor = interactor;
    }

    public void setInteractor(IlvManagerViewInteractor interactor) {
        this._interactor = interactor;
    }

    public IlvManagerViewInteractor getInteractor() {
        return this._interactor;
    }

    @Override
    public void invoke(boolean isSticky) {
        if (this._interactor == null) {
            throw new IllegalArgumentException("setInteractor() must be called before invoke()");
        }
        if (this._started) {
            return;
        }
        this._started = true;
        if (isSticky && this._interactor instanceof IlvPermanentInteractorInterface) {
            ((IlvPermanentInteractorInterface)this._interactor).setPermanent(true);
        }
        this.getManagerView().pushInteractor(this._interactor);
    }

    @Override
    public void setSticky(boolean isSticky) {
        if (this._started && this._interactor != null && this._interactor instanceof IlvPermanentInteractorInterface) {
            ((IlvPermanentInteractorInterface)this._interactor).setPermanent(isSticky);
        }
    }

    @Override
    protected void abortImpl() {
        if (this._started && this._interactor != null) {
            final IlvManagerView view = this.getManagerView();
            if (view.getInteractor() == this._interactor) {
                view.popInteractor();
            } else {
                final IlvManagerViewInteractor interactor = this._interactor;
                view.addInteractorListener(new InteractorListener(){

                    public void interactorChanged(InteractorChangedEvent interactorChangedEvent) {
                        if (view.getInteractor() == interactor) {
                            view.popInteractor();
                            view.removeInteractorListener((InteractorListener)this);
                        }
                    }
                });
            }
        }
    }
}

