/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.palette;

import java.util.HashSet;
import java.util.Set;
import oracle.diagram.framework.notification.Notification;
import oracle.diagram.framework.notification.NotificationType;
import oracle.diagram.framework.palette.PaletteTask;
import oracle.ide.palette2.PaletteItem;

public class PaletteNotification
extends Notification {
    public static final NotificationType PALETTE_ITEM_SELECTED = new NotificationType("oracle.diagram.framework.palette.paletteItemSelected");
    public static final NotificationType PALETTE_ITEM_UNSELECTED = new NotificationType("oracle.diagram.framework.palette.paletteItemUnselected");
    public static final NotificationType PALETTE_ITEM_DRAG_ENTER = new NotificationType("oracle.diagram.framework.palette.paletteItemDragEnter");
    public static final NotificationType PALETTE_ITEM_DRAG_EXIT = new NotificationType("oracle.diagram.framework.palette.paletteItemDragExit");
    public static final NotificationType PALETTE_ITEM_DROP = new NotificationType("oracle.diagram.framework.palette.paletteItemDrop");
    public static final NotificationType PALETTE_TASK_FINISHED = new NotificationType("oracle.diagram.framework.palette.paletteTaskFinished");
    public static final Set<NotificationType> PALETTE_NOTIFICATION_SET = new HashSet<NotificationType>();
    private PaletteItem _item;
    private PaletteTask _task;

    public static PaletteNotification createPaletteItemSelectedNotification(Object source, PaletteItem item) {
        return new PaletteNotification(PALETTE_ITEM_SELECTED, source, item, null);
    }

    public static PaletteNotification createPaletteItemUnselectedNotification(Object source, PaletteItem item) {
        return new PaletteNotification(PALETTE_ITEM_UNSELECTED, source, item, null);
    }

    public static PaletteNotification createPaletteItemDragEnterNotification(Object source, PaletteItem item) {
        return new PaletteNotification(PALETTE_ITEM_DRAG_ENTER, source, item, null);
    }

    public static PaletteNotification createPaletteItemDragExitNotification(Object source, PaletteItem item) {
        return new PaletteNotification(PALETTE_ITEM_DRAG_EXIT, source, item, null);
    }

    public static PaletteNotification createPaletteItemDropNotification(Object source, PaletteItem item) {
        return new PaletteNotification(PALETTE_ITEM_DROP, source, item, null);
    }

    public static PaletteNotification createPaletteTaskFinishedNotification(Object source, PaletteTask task) {
        return new PaletteNotification(PALETTE_TASK_FINISHED, source, task.getPaletteItem(), task);
    }

    private PaletteNotification(NotificationType type, Object source, PaletteItem item, PaletteTask task) {
        super(type, source);
        this._item = item;
        this._task = task;
    }

    public final PaletteItem getPaletteItem() {
        return this._item;
    }

    public final PaletteTask getPaletteTask() {
        return this._task;
    }

    static {
        PALETTE_NOTIFICATION_SET.add(PALETTE_ITEM_SELECTED);
        PALETTE_NOTIFICATION_SET.add(PALETTE_ITEM_UNSELECTED);
        PALETTE_NOTIFICATION_SET.add(PALETTE_ITEM_DRAG_ENTER);
        PALETTE_NOTIFICATION_SET.add(PALETTE_ITEM_DRAG_EXIT);
        PALETTE_NOTIFICATION_SET.add(PALETTE_ITEM_DROP);
        PALETTE_NOTIFICATION_SET.add(PALETTE_TASK_FINISHED);
    }
}

