/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.notification;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import oracle.diagram.core.plugin.Plugin;
import oracle.diagram.core.plugin.PluginManager;
import oracle.diagram.framework.notification.Notification;
import oracle.diagram.framework.notification.NotificationObserver;
import oracle.diagram.framework.notification.NotificationType;
import oracle.ide.ExtensionRegistry;

public class NotificationCenter
implements Plugin {
    private Map<NotificationType, Set<NotificationObserver>> _notificationMap = new HashMap<NotificationType, Set<NotificationObserver>>();

    @Override
    public void attach(PluginManager pluginManager, Class<? extends Plugin> pluginType) {
    }

    @Override
    public void detach(PluginManager pluginManager, Class<? extends Plugin> pluginType) {
        this._notificationMap.clear();
    }

    public void addNotificationObserver(NotificationType notificationType, NotificationObserver observer) {
        if (notificationType == null) {
            throw new IllegalArgumentException("notificationtype  is null");
        }
        if (observer == null) {
            throw new IllegalArgumentException("observer is null");
        }
        this._addNotificationObserver(notificationType, observer);
    }

    public void addNotificationObserver(Collection<NotificationType> notificationTypes, NotificationObserver observer) {
        if (notificationTypes == null) {
            throw new IllegalArgumentException("notification Type set is null");
        }
        if (observer == null) {
            throw new IllegalArgumentException("observer is null");
        }
        for (NotificationType notificationType : notificationTypes) {
            if (notificationType == null) continue;
            this._addNotificationObserver(notificationType, observer);
        }
    }

    private void _addNotificationObserver(NotificationType notificationType, NotificationObserver observer) {
        Set<NotificationObserver> observers = this._notificationMap.get(notificationType);
        if (observers == null) {
            observers = new HashSet<NotificationObserver>();
            this._notificationMap.put(notificationType, observers);
        }
        observers.add(observer);
    }

    public void removeObserver(NotificationObserver observer) {
        Set<NotificationType> notificationTypes = this._notificationMap.keySet();
        if (!notificationTypes.isEmpty()) {
            this.removeObserver(notificationTypes, observer);
        }
    }

    public void removeObserver(NotificationType notificationType, NotificationObserver observer) {
        if (notificationType == null) {
            throw new IllegalArgumentException("notification Type  is null");
        }
        HashSet<NotificationType> types = new HashSet<NotificationType>();
        types.add(notificationType);
        this.removeObserver(types, observer);
    }

    public void removeObserver(Collection<NotificationType> notificationTypes, NotificationObserver observer) {
        if (notificationTypes == null) {
            throw new IllegalArgumentException("notification Type set is null");
        }
        if (observer == null) {
            throw new IllegalArgumentException("observer is null");
        }
        for (NotificationType notificationType : notificationTypes) {
            Set<NotificationObserver> observers;
            if (notificationType == null || (observers = this._notificationMap.get(notificationType)) == null) continue;
            observers.remove(observer);
        }
    }

    public void sendNotification(Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException("notification is null");
        }
        NotificationType type = notification.getType();
        Set<NotificationObserver> observers = this._notificationMap.get(type);
        if (observers != null) {
            for (NotificationObserver observer : observers) {
                try {
                    observer.receiveNotification(notification);
                }
                catch (Exception e) {
                    ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Error sending notification");
                }
            }
        }
    }
}

