/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.node;

import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.event.ManagerContentChangedEvent;
import ilog.views.event.ManagerContentChangedListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.logging.Level;
import oracle.bm.util.LoggerUtils;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Attributes;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.vcs.VCSManager;

public class SimpleIVLNode
extends Node
implements ManagerContentChangedListener {
    private IlvManager m_manager = null;
    private boolean m_isLoading = false;

    public SimpleIVLNode() {
        this.initializeAttributes();
    }

    public SimpleIVLNode(URL url) {
        super(url);
        this.initializeAttributes();
    }

    public final IlvManager getManager() throws IOException {
        this.open();
        return this.m_manager;
    }

    public void contentsChanged(ManagerContentChangedEvent managerContentChangedEvent) {
        if (!this.isLoading()) {
            this.markDirty(true);
        }
    }

    protected void initializeAttributes() {
        Attributes attr = this.getAttributes();
        attr.set(ElementAttributes.SAVEABLE | ElementAttributes.SAVEABLE_AS | ElementAttributes.ERASEABLE | ElementAttributes.EDITOR_SAVEABLE_AS | ElementAttributes.CLOSEABLE | ElementAttributes.RENAMEABLE | ElementAttributes.PRINTABLE);
    }

    protected IlvManager createManager() {
        return new IlvManager();
    }

    protected void readImpl(IlvManager mgr) throws IOException {
        try (BufferedInputStream bis = null;){
            URL url = this.getURL();
            VCSManager.getVCSManager().validateStatus(url);
            bis = VCSManager.getVCSManager().containsConflicts(url) ? new BufferedInputStream(VCSManager.getVCSManager().openConflictsStreamAsContributor(url)) : new BufferedInputStream(this.getInputStream());
            mgr.read((InputStream)bis);
        }
    }

    protected void writeImpl(IlvManager mgr) throws IOException {
        OutputStream os = URLFileSystem.openOutputStream((URL)this.getURL());
        if (os != null) {
            try {
                mgr.write(os);
            }
            finally {
                os.flush();
                os.close();
            }
        }
    }

    protected final void openImpl() throws IOException {
        super.openImpl();
        this.m_isLoading = true;
        try {
            if (this.m_manager == null) {
                this.m_manager = this.createManager();
                this.m_manager.addManagerContentChangedListener((ManagerContentChangedListener)this);
            }
            this.m_manager.setContentsAdjusting(true);
            this.m_manager.deleteAll(true);
            if (!this.isNew()) {
                this.readImpl(this.m_manager);
            }
        }
        finally {
            this.m_manager.setContentsAdjusting(false);
            this.m_isLoading = false;
        }
    }

    protected final boolean isLoading() {
        return this.m_isLoading;
    }

    protected final void saveImpl() throws IOException {
        super.saveImpl();
        IlvManager mgr = this.getManager();
        try {
            this.writeImpl(mgr);
        }
        catch (IOException ioex) {
            LoggerUtils.getLoggerForClass(SimpleIVLNode.class).log(Level.SEVERE, ioex.getLocalizedMessage(), ioex);
            throw ioex;
        }
    }

    protected void closeImpl() throws IOException {
        super.closeImpl();
        this.m_manager = null;
        CommandProcessor.getInstance().flush((Node)this);
    }

    protected void revertImpl() throws IOException {
        if (this.m_manager != null) {
            try {
                this.m_isLoading = true;
                this.m_manager.removeManagerContentChangedListener((ManagerContentChangedListener)this);
                Collection<IlvManagerView> views = ManagerUtil.getViews(this.m_manager);
                this.m_manager = this.createManager();
                this.m_manager.setContentsAdjusting(true);
                this.readImpl(this.m_manager);
                ManagerUtil.assignViewsToNewManager(this.m_manager, views);
                this.m_manager.addManagerContentChangedListener((ManagerContentChangedListener)this);
            }
            finally {
                this.m_manager.setContentsAdjusting(false);
                this.m_isLoading = false;
            }
        } else {
            super.revertImpl();
        }
    }
}

