/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.link.policy;

import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.linkpolicy.IlvLinkShapePolicy;
import ilog.views.linkconnector.IlvShapePath;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import oracle.diagram.framework.graphic.FakeNode;
import oracle.diagram.framework.link.LinkUtil;
import oracle.diagram.framework.link.policy.DiagramFrameworkLinkPolicy;
import oracle.diagram.framework.link.policy.SubShapePinLinkPolicy;
import oracle.diagram.framework.transformer.TransformerUtil;

public class PartialOrthogonalLinkPolicy
extends DiagramFrameworkLinkPolicy {
    public PartialOrthogonalLinkPolicy() {
        this.setChildPolicy(null);
    }

    public PartialOrthogonalLinkPolicy(IlvLinkShapePolicy child) {
        SubShapePinLinkPolicy policy = new SubShapePinLinkPolicy();
        if (child != null) {
            policy.setChildPolicy(child);
        }
        this.setChildPolicy((IlvLinkShapePolicy)policy);
    }

    @Override
    protected void initPolicy(IlvLinkImage link, boolean triggered) {
        this.initPolicy(link, 0, triggered);
    }

    @Override
    protected void initPolicy(IlvLinkImage link, int orthoSeed, boolean triggered) {
        IlvGraphic to;
        if (!this.isPolicyEnabled(link) || this._updatingState) {
            return;
        }
        if (link == null || link.getGraphicBag() == null) {
            return;
        }
        if (link.getFrom() instanceof FakeNode || link.getTo() instanceof FakeNode) {
            return;
        }
        if (link.getFrom().getGraphicBag() == null || link.getTo().getGraphicBag() == null) {
            return;
        }
        PolicyAlgoOutput pRes = null;
        IlvGraphic from = LinkUtil.getEndGraphic(link, true);
        if (from == null) {
            from = link.getFrom();
        }
        if ((to = LinkUtil.getEndGraphic(link, false)) == null) {
            to = link.getTo();
        }
        pRes = from.equals(to) ? this.initPolicySelfLink(link, orthoSeed, triggered) : this.initPolicyLink(link, orthoSeed, triggered);
        this.applyPolicyResult(link, pRes);
    }

    protected PolicyAlgoOutput initPolicyLink(IlvLinkImage link, int orthoSeed, boolean triggered) {
        IlvPoint[] points = LinkUtil.getLinkPointsUnclipped(link, TransformerUtil.IDENTITY_TRANSFORMER);
        boolean pointsUpdated = false;
        IlvPoint[] initialEdge = this.initialEdgeShape(link, points, orthoSeed);
        if (initialEdge != null) {
            pointsUpdated = true;
            points = initialEdge;
        }
        return this.correctLink(points, link, orthoSeed, triggered, pointsUpdated);
    }

    protected PolicyAlgoOutput correctLink(IlvPoint[] points, IlvLinkImage link, int orthoSeed, boolean triggered, boolean needsSmoothing) {
        IlvGraphic to;
        IlvGraphic from;
        if (needsSmoothing || triggered) {
            points = this.massageEdgeClosePoints(points);
        }
        if ((from = LinkUtil.getEndGraphic(link, true)) == null) {
            from = link.getFrom();
        }
        if ((to = LinkUtil.getEndGraphic(link, false)) == null) {
            to = link.getTo();
        }
        points = this.truncateLink(points, link, TransformerUtil.IDENTITY_TRANSFORMER, ERROR_TOLERANCE);
        return new PolicyAlgoOutput(true, points);
    }

    protected PolicyAlgoOutput initPolicySelfLink(IlvLinkImage link, int orthoSeed, boolean triggered) {
        IlvPoint[] points = LinkUtil.getLinkPointsUnclipped(link, TransformerUtil.IDENTITY_TRANSFORMER);
        IlvPoint[] initialEdgePoints = this.initialEdgeShapeForPigsEar(link, points);
        return new PolicyAlgoOutput(true, initialEdgePoints);
    }

    @Override
    protected void updatePolicy(IlvLinkImage link, boolean source, int orthoSeed, boolean triggered) {
        IlvGraphic to;
        if (!this.isPolicyEnabled(link) || this._updatingState) {
            return;
        }
        if (link == null || link.getGraphicBag() == null) {
            return;
        }
        if (link.getFrom() instanceof FakeNode || link.getTo() instanceof FakeNode) {
            return;
        }
        if (link.getFrom().getGraphicBag() == null || link.getTo().getGraphicBag() == null) {
            return;
        }
        IlvGraphic from = LinkUtil.getEndGraphic(link, true);
        if (from == null) {
            from = link.getFrom();
        }
        if ((to = LinkUtil.getEndGraphic(link, false)) == null) {
            to = link.getTo();
        }
        PolicyAlgoOutput pRes = null;
        pRes = from.equals(to) ? this.updatePolicySelfLink(link, source, orthoSeed, triggered) : this.updatePolicyLink(link, source, orthoSeed, triggered);
        this.applyPolicyResult(link, pRes);
    }

    protected PolicyAlgoOutput updatePolicySelfLink(IlvLinkImage link, boolean source, int orthoSeed, boolean triggered) {
        IlvPoint[] newPoints;
        IlvPoint p;
        DiagramFrameworkLinkPolicy.LinkInfo lInfo = (DiagramFrameworkLinkPolicy.LinkInfo)this._cachedLinksInfo.get(link);
        IlvPoint[] pPoints = lInfo.getPoints();
        IlvPoint[] points = LinkUtil.getLinkPointsUnclipped(link, TransformerUtil.IDENTITY_TRANSFORMER);
        IlvRect previousFromBox = lInfo.getFromGraphicInfo().boundingBox();
        int p1Pos = LinkUtil.getRelativePosToRectangle(pPoints[1], previousFromBox);
        IlvPoint diffSource = this.diffShapeSide(p1Pos, true, link);
        double dySourceDir = pPoints[1].getY() - pPoints[0].getY();
        double dxSource = diffSource.getX() == 0.0 && dySourceDir != 0.0 ? points[0].getX() - pPoints[0].getX() : diffSource.getX();
        double dxSourceDir = pPoints[1].getX() - pPoints[0].getX();
        double dySource = diffSource.getY() == 0.0 && dxSourceDir != 0.0 ? points[0].getY() - pPoints[0].getY() : diffSource.getY();
        for (int i = 1; i < points.length / 2; ++i) {
            IlvPoint p2 = points[i];
            p2.setLocation(p2.getX() + dxSource, p2.getY() + dySource);
        }
        IlvRect previousToBox = lInfo.getToGraphicInfo().boundingBox();
        int pn1Pos = LinkUtil.getRelativePosToRectangle(pPoints[pPoints.length - 2], previousToBox);
        IlvPoint diffDestination = this.diffShapeSide(pn1Pos, false, link);
        double dyDestinationDir = pPoints[points.length - 2].getY() - pPoints[points.length - 1].getY();
        double dxDestination = diffDestination.getX() == 0.0 && dyDestinationDir != 0.0 ? points[points.length - 1].getX() - pPoints[points.length - 1].getX() : diffDestination.getX();
        double dxDestinationDir = pPoints[points.length - 2].getX() - pPoints[points.length - 1].getX();
        double dyDestination = diffDestination.getY() == 0.0 && dxDestinationDir != 0.0 ? points[points.length - 1].getY() - pPoints[points.length - 1].getY() : diffDestination.getY();
        int i = points.length - 2;
        while ((double)i > Math.ceil(points.length / 2) - 1.0) {
            p = points[i];
            p.setLocation(p.getX() + dxDestination, p.getY() + dyDestination);
            --i;
        }
        if (points.length % 2 > 0) {
            i = points.length / 2;
            p = points[i];
            IlvPoint pPoint = pPoints[i];
            p.setLocation(pPoint.getX() == pPoints[i - 1].getX() ? points[i - 1].getX() : points[i + 1].getX(), pPoint.getY() == pPoints[i - 1].getY() ? points[i - 1].getY() : points[i + 1].getY());
        }
        if ((newPoints = this.massageEdgeClosePoints(points)) != null) {
            points = newPoints;
        }
        return new PolicyAlgoOutput(true, points);
    }

    protected PolicyAlgoOutput updatePolicyLink(IlvLinkImage link, boolean source, int orthoSeed, boolean triggered) {
        return this.initPolicyLink(link, orthoSeed, triggered);
    }

    protected void applyPolicyResult(IlvLinkImage link, PolicyAlgoOutput pRes) {
        if (pRes.hasUpdated()) {
            this._updatingState = true;
            LinkUtil.updatePointsWithApply(link, pRes.getPoints(), pRes.getPoints().length);
            this._updatingState = false;
        }
    }

    protected IlvPoint diffShapeSide(int whichSide, boolean source, IlvLinkImage link) {
        IlvPoint diff = new IlvPoint();
        IlvRect newBox = source ? link.getFromBoundingBox(TransformerUtil.IDENTITY_TRANSFORMER) : link.getToBoundingBox(TransformerUtil.IDENTITY_TRANSFORMER);
        DiagramFrameworkLinkPolicy.LinkInfo lInfo = (DiagramFrameworkLinkPolicy.LinkInfo)this._cachedLinksInfo.get(link);
        IlvRect prevBox = source ? lInfo.getFromGraphicInfo().boundingBox() : lInfo.getToGraphicInfo().boundingBox();
        switch (whichSide) {
            case 1: {
                diff.setLocation(newBox.getX() - prevBox.getX(), 0.0);
                break;
            }
            case 4: {
                diff.setLocation(0.0, newBox.getY() - prevBox.getY());
                break;
            }
            case 2: {
                diff.setLocation(newBox.getX() + newBox.getWidth() - (prevBox.getX() + prevBox.getWidth()), 0.0);
                break;
            }
            default: {
                diff.setLocation(0.0, newBox.getY() + newBox.getHeight() - (prevBox.getY() + prevBox.getHeight()));
            }
        }
        return diff;
    }

    protected IlvPoint[] initialEdgeShape(IlvLinkImage link, IlvPoint[] points, int orthoSeed) {
        IlvGraphic to;
        int nbPoints = points.length;
        IlvPoint[] edgePoints = points;
        IlvRect fromBox = LinkUtil.getFromBoundingBox(link, TransformerUtil.IDENTITY_TRANSFORMER);
        IlvRect toBox = LinkUtil.getToBoundingBox(link, TransformerUtil.IDENTITY_TRANSFORMER);
        boolean isHorizontalToOriginBox = LinkUtil.isHorizontalToRectangle(points[0], fromBox);
        boolean isHorizontalToDestinationBox = LinkUtil.isHorizontalToRectangle(points[nbPoints - 1], toBox);
        boolean pointsUpdated = false;
        IlvGraphic from = LinkUtil.getEndGraphic(link, true);
        if (from == null) {
            from = link.getFrom();
        }
        if ((to = LinkUtil.getEndGraphic(link, false)) == null) {
            to = link.getTo();
        }
        if (isHorizontalToOriginBox == isHorizontalToDestinationBox) {
            IlvPoint[] newPoints;
            if (nbPoints == 2) {
                if (points[0].x == points[1].x) {
                    return null;
                }
                if (points[0].y == points[1].y) {
                    return null;
                }
                newPoints = null;
                if (this.isJustCreated(link) && (Math.abs(points[0].x - points[1].x) < STRAIGHT_LINE_CREATION_THRESHOLD || Math.abs(points[0].y - points[1].y) < STRAIGHT_LINE_CREATION_THRESHOLD)) {
                    newPoints = LinkUtil.fetchStraightLine(link);
                }
                if (newPoints == null) {
                    newPoints = new IlvPoint[4];
                    newPoints[0] = points[0];
                    if (isHorizontalToOriginBox) {
                        float newX = 0.0f;
                        newX = points[0].x <= points[1].x ? 0.5f * (fromBox.x + fromBox.width + toBox.x) : 0.5f * (toBox.x + toBox.width + fromBox.x);
                        newPoints[1] = new IlvPoint(newX, points[0].y);
                        newPoints[2] = new IlvPoint(newX, points[1].y);
                    } else {
                        float newY = 0.0f;
                        newY = points[0].y <= points[1].y ? 0.5f * (fromBox.y + fromBox.height + toBox.y) : 0.5f * (toBox.y + toBox.height + fromBox.y);
                        newPoints[1] = new IlvPoint(points[0].x, newY);
                        newPoints[2] = new IlvPoint(points[1].x, newY);
                    }
                    newPoints[3] = points[1];
                }
                edgePoints = newPoints;
                nbPoints = newPoints.length;
                pointsUpdated = true;
            } else if (nbPoints % 2 == 1) {
                newPoints = new IlvPoint[nbPoints + 1];
                for (int j = 0; j < nbPoints - 1; ++j) {
                    newPoints[j] = points[j];
                }
                newPoints[nbPoints - 1] = new IlvPoint(newPoints[nbPoints - 2]);
                newPoints[nbPoints] = points[nbPoints - 1];
                edgePoints = newPoints;
                ++nbPoints;
                pointsUpdated = true;
            }
        } else if (nbPoints % 2 == 0) {
            IlvPoint[] ailvpoint3 = new IlvPoint[nbPoints + 1];
            for (int k = 0; k < nbPoints - 1; ++k) {
                ailvpoint3[k] = points[k];
            }
            ailvpoint3[nbPoints - 1] = new IlvPoint(ailvpoint3[nbPoints - 2]);
            ailvpoint3[nbPoints] = points[nbPoints - 1];
            edgePoints = ailvpoint3;
            ++nbPoints;
            pointsUpdated = true;
        }
        if (pointsUpdated || !LinkUtil.isLinkOrthogonal(edgePoints)) {
            boolean hFlag = LinkUtil.isHorizontalRelativeToPoint(edgePoints[1], edgePoints[0]);
            for (int ind = 1; ind < nbPoints - 1; ++ind) {
                if (ind == orthoSeed && orthoSeed > 1) {
                    if (hFlag) {
                        edgePoints[ind - 1].y = edgePoints[ind].y;
                    } else {
                        edgePoints[ind - 1].x = edgePoints[ind].x;
                    }
                } else if (hFlag) {
                    edgePoints[ind].y = edgePoints[ind - 1].y;
                } else {
                    edgePoints[ind].x = edgePoints[ind - 1].x;
                }
                hFlag = !hFlag;
            }
            if (hFlag) {
                edgePoints[nbPoints - 2].y = edgePoints[nbPoints - 1].y;
            } else {
                edgePoints[nbPoints - 2].x = edgePoints[nbPoints - 1].x;
            }
            pointsUpdated = true;
        }
        return pointsUpdated ? edgePoints : null;
    }

    protected IlvPoint[] initialEdgeShapeForPigsEar(IlvLinkImage link, IlvPoint[] points) {
        IlvPoint[] newPoints;
        IlvRect fromBox = LinkUtil.getFromBoundingBox(link, TransformerUtil.IDENTITY_TRANSFORMER);
        IlvPoint[] edgePoints = points;
        IlvTransformer fromTrans = new IlvTransformer();
        fromTrans.postCompose(link.getFromTransformer(TransformerUtil.IDENTITY_TRANSFORMER));
        PathIterator fromPathIte = link.getFrom() instanceof IlvShapePath ? ((IlvShapePath)link.getFrom()).getShapePath(fromTrans) : fromBox.getPathIterator(new AffineTransform());
        GeneralPath fromPath = new GeneralPath();
        fromPath.append(fromPathIte, false);
        if (LinkUtil.isLinkEntirelyInShape(fromPath, points)) {
            int originPos = LinkUtil.getRelativePosToRectangle(points[0], fromBox);
            if (points.length != 4) {
                edgePoints = new IlvPoint[5];
                edgePoints[0] = new IlvPoint(points[0]);
                edgePoints[4] = new IlvPoint(points[1]);
                float rectCenterX = (float)fromBox.getCenterX();
                float rectCenterY = (float)fromBox.getCenterY();
                switch (originPos) {
                    case 1: {
                        edgePoints[1] = new IlvPoint(fromBox.x - PIGS_EAR_DISTANCE, edgePoints[0].y);
                        edgePoints[2] = points[1].y < rectCenterY ? new IlvPoint(edgePoints[1].x, fromBox.y - PIGS_EAR_DISTANCE) : new IlvPoint(edgePoints[1].x, fromBox.y + fromBox.height + PIGS_EAR_DISTANCE);
                        edgePoints[3] = new IlvPoint(points[1].x, edgePoints[2].y);
                        break;
                    }
                    case 2: {
                        edgePoints[1] = new IlvPoint(fromBox.x + fromBox.width + PIGS_EAR_DISTANCE, edgePoints[0].y);
                        edgePoints[2] = points[1].y < rectCenterY ? new IlvPoint(edgePoints[1].x, fromBox.y - PIGS_EAR_DISTANCE) : new IlvPoint(edgePoints[1].x, fromBox.y + fromBox.height + PIGS_EAR_DISTANCE);
                        edgePoints[3] = new IlvPoint(points[1].x, edgePoints[2].y);
                        break;
                    }
                    case 4: {
                        edgePoints[1] = new IlvPoint(edgePoints[0].x, fromBox.y - PIGS_EAR_DISTANCE);
                        edgePoints[2] = points[1].x < rectCenterX ? new IlvPoint(fromBox.x - PIGS_EAR_DISTANCE, edgePoints[1].y) : new IlvPoint(fromBox.x + fromBox.width + PIGS_EAR_DISTANCE, edgePoints[1].y);
                        edgePoints[3] = new IlvPoint(edgePoints[2].x, edgePoints[4].y);
                        break;
                    }
                    case 8: {
                        edgePoints[1] = new IlvPoint(edgePoints[0].x, fromBox.y + fromBox.height + PIGS_EAR_DISTANCE);
                        edgePoints[2] = points[1].x < rectCenterX ? new IlvPoint(fromBox.x - PIGS_EAR_DISTANCE, edgePoints[1].y) : new IlvPoint(fromBox.x + fromBox.width + PIGS_EAR_DISTANCE, edgePoints[1].y);
                        edgePoints[3] = new IlvPoint(edgePoints[2].x, edgePoints[4].y);
                    }
                }
            } else {
                IlvPoint[] cPoints = link.getLinkPoints(TransformerUtil.IDENTITY_TRANSFORMER);
                int cOriginPos = LinkUtil.getRelativePosToRectangle(cPoints[0], fromBox);
                edgePoints = new IlvPoint[4];
                edgePoints[0] = cPoints[0];
                edgePoints[3] = cPoints[3];
                switch (cOriginPos) {
                    case 1: {
                        edgePoints[1] = new IlvPoint(fromBox.x - PIGS_EAR_DISTANCE, edgePoints[0].y);
                        edgePoints[2] = new IlvPoint(edgePoints[1].x, edgePoints[3].y);
                        break;
                    }
                    case 2: {
                        edgePoints[1] = new IlvPoint(fromBox.x + fromBox.width + PIGS_EAR_DISTANCE, edgePoints[0].y);
                        edgePoints[2] = new IlvPoint(edgePoints[1].x, edgePoints[3].y);
                        break;
                    }
                    case 4: {
                        edgePoints[1] = new IlvPoint(edgePoints[0].x, fromBox.y - PIGS_EAR_DISTANCE);
                        edgePoints[2] = new IlvPoint(edgePoints[3].x, edgePoints[1].y);
                        break;
                    }
                    case 8: {
                        edgePoints[1] = new IlvPoint(edgePoints[0].x, fromBox.y + fromBox.height + PIGS_EAR_DISTANCE);
                        edgePoints[2] = new IlvPoint(edgePoints[3].x, edgePoints[1].y);
                    }
                }
            }
        } else if (!LinkUtil.isLinkOrthogonal(points) && (newPoints = this.initialEdgeShape(link, points, 0)) != null) {
            edgePoints = newPoints;
        }
        return edgePoints;
    }

    @Override
    protected IlvPoint[] truncateLink(IlvPoint[] points, IlvLinkImage link, IlvTransformer trans, float errorTolerance) {
        return LinkUtil.truncateLink(points, link, trans, errorTolerance);
    }

    public class PolicyAlgoOutput {
        private boolean m_pointsUpdated;
        private IlvPoint[] m_points;

        public PolicyAlgoOutput(boolean pUpdated) {
            this.m_pointsUpdated = pUpdated;
        }

        public PolicyAlgoOutput(boolean pUpdated, IlvPoint[] points) {
            this(pUpdated);
            this.m_points = points;
        }

        public void setPoints(IlvPoint[] points) {
            this.m_points = points;
        }

        public boolean hasUpdated() {
            return this.m_pointsUpdated;
        }

        public IlvPoint[] getPoints() {
            return this.m_points;
        }
    }
}

