/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.link.policy;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.linkpolicy.IlvAbstractLinkShapePolicy;
import ilog.views.graphic.linkpolicy.IlvLinkShapePolicy;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import oracle.diagram.dif.Dimension;
import oracle.diagram.framework.link.LinkUtil;
import oracle.diagram.framework.link.policy.InvokablePolicy;
import oracle.diagram.framework.transformer.TransformerUtil;
import oracle.diagram.logging.AlertMessage;
import oracle.diagram.logging.DiagramLogPage;
import oracle.diagram.logging.EmphasizedMessage;

public abstract class DiagramFrameworkLinkPolicy
extends IlvAbstractLinkShapePolicy
implements InvokablePolicy {
    public static final String ENABLED_PROP = "Enabled";
    public static final String JUST_CREATED = "JustCreated";
    protected static float ERROR_TOLERANCE = 1.0f;
    protected static float POINTS_PROXIMITY_TOLERANCE = 10.0f;
    protected static float PIGS_EAR_DISTANCE = 50.0f;
    protected static float STRAIGHT_LINE_CREATION_THRESHOLD = 15.0f;
    protected boolean _updatingState = false;
    protected HashMap<IlvLinkImage, LinkInfo> _cachedLinksInfo = new HashMap();

    public void afterAdd(IlvLinkImage link) {
        if (this.isPolicyEnabled(link)) {
            if (link.getGraphicBag() != null) {
                link.getGraphicBag().applyToObject((IlvGraphic)link, new IlvApplyObject(){

                    public void apply(IlvGraphic graphic, Object obj) {
                        DiagramFrameworkLinkPolicy.this.initPolicy((IlvLinkImage)graphic, false);
                    }
                }, null, true);
            } else {
                this.initPolicy(link, false);
            }
        }
        this.cacheLinkInfo(link);
        super.afterAdd(link);
    }

    public void afterFromNodeMoved(IlvLinkImage link) {
        if (this.isPolicyEnabled(link) && !this.compareRect(link) && link.getProperty("__InteractorMoving") == null) {
            this.updatePolicy(link, true, 0, false);
        }
        this.cacheLinkInfo(link);
        super.afterFromNodeMoved(link);
    }

    public void afterToNodeMoved(IlvLinkImage link) {
        if (this.isPolicyEnabled(link) && !this.compareRect(link) && link.getProperty("__InteractorMoving") == null) {
            this.updatePolicy(link, false, 0, false);
        }
        this.cacheLinkInfo(link);
        super.afterToNodeMoved(link);
    }

    public void afterMovePoint(IlvLinkImage link, int ptIndex, IlvTransformer trans) {
        if (this.isPolicyEnabled(link)) {
            this.initPolicy(link, ptIndex, false);
        }
        this.cacheLinkInfo(link);
        super.afterMovePoint(link, ptIndex, trans);
    }

    public boolean allowInsertPoint(IlvLinkImage link, int ptIndex, float x, float y, IlvTransformer trans) {
        return super.allowInsertPoint(link, ptIndex, x, y, trans);
    }

    public void afterInsertPoint(IlvLinkImage link, int ptIndex, IlvTransformer trans) {
        if (this.isPolicyEnabled(link)) {
            this.initPolicy(link, ptIndex, false);
        }
        this.cacheLinkInfo(link);
        super.afterInsertPoint(link, ptIndex, trans);
    }

    public boolean allowRemovePoint(IlvLinkImage link, int ptIndex, IlvTransformer trans) {
        return super.allowRemovePoint(link, ptIndex, trans);
    }

    public void afterRemovePoint(IlvLinkImage link, int ptIndex, IlvTransformer trans) {
        super.afterRemovePoint(link, ptIndex, trans);
        if (this.isPolicyEnabled(link)) {
            this.initPolicy(link, false);
        }
        this.cacheLinkInfo(link);
    }

    public void afterSetIntermediateLinkPoints(IlvLinkImage link) {
        if (this.isPolicyEnabled(link)) {
            this.initPolicy(link, false);
        }
        super.afterSetIntermediateLinkPoints(link);
    }

    public void onInstall(IlvLinkImage link) {
        if (this.isPolicyEnabled(link)) {
            this.initPolicy(link, false);
        }
        this.cacheLinkInfo(link);
        super.onInstall(link);
    }

    public void onUninstall(IlvLinkImage link) {
        super.onUninstall(link);
        this._cachedLinksInfo.remove(link);
    }

    @Override
    public void invoke(IlvLinkImage link) {
        this.initPolicy(link, true);
        IlvLinkShapePolicy child = this.getChildPolicy();
        if (child instanceof InvokablePolicy) {
            ((InvokablePolicy)child).invoke(link);
        }
    }

    protected void cacheLinkInfo(IlvLinkImage link) {
        IlvPoint[] points = LinkUtil.getLinkPointsUnclipped(link, TransformerUtil.IDENTITY_TRANSFORMER);
        LinkInfo li = new LinkInfo(new LinkInfo.EndGraphicInfo(link.getFrom(), link.getVisibleFrom(), LinkUtil.getConnectedEnd(link, true), LinkUtil.getEndGraphic(link, true)), new LinkInfo.EndGraphicInfo(link.getTo(), link.getVisibleTo(), LinkUtil.getConnectedEnd(link, false), LinkUtil.getEndGraphic(link, false)), points);
        this._cachedLinksInfo.put(link, li);
    }

    protected boolean compareRect(IlvLinkImage link) {
        Dimension d;
        IlvPoint[] points = LinkUtil.getLinkPointsUnclipped(link, TransformerUtil.IDENTITY_TRANSFORMER);
        LinkInfo li = this._cachedLinksInfo.get(link);
        Dimension dimension = d = li != null ? li.getPathDimension() : new Dimension();
        return d.getWidth() == points[points.length - 1].getX() - points[0].getX() && d.getHeight() == points[points.length - 1].getY() - points[0].getY();
    }

    protected boolean isPolicyEnabled(IlvLinkImage link) {
        Boolean enabled = (Boolean)link.getProperty(ENABLED_PROP);
        return enabled == null || enabled != false;
    }

    protected boolean isJustCreated(IlvLinkImage link) {
        Boolean justCreated = (Boolean)link.getProperty(JUST_CREATED);
        return justCreated != null && justCreated != false;
    }

    protected abstract void initPolicy(IlvLinkImage var1, boolean var2);

    protected abstract void initPolicy(IlvLinkImage var1, int var2, boolean var3);

    protected abstract void updatePolicy(IlvLinkImage var1, boolean var2, int var3, boolean var4);

    protected IlvPoint[] massageEdgeClosePoints(IlvPoint[] points) {
        IlvPoint[] cleanOne = LinkUtil.cleanLinkFromCycles(points);
        return cleanOne;
    }

    protected abstract IlvPoint[] truncateLink(IlvPoint[] var1, IlvLinkImage var2, IlvTransformer var3, float var4);

    protected void logInfo(IlvLinkImage link, IlvPoint[] points, String message) {
        DiagramLogPage msgPage = DiagramLogPage.makeDiagramLogPage();
        IlvRect fromBox = LinkUtil.getFromBoundingBox(link, TransformerUtil.IDENTITY_TRANSFORMER);
        IlvRect toBox = LinkUtil.getToBoundingBox(link, TransformerUtil.IDENTITY_TRANSFORMER);
        msgPage.log((Object)new EmphasizedMessage("--- Starting Info: " + message + " ---\n"));
        msgPage.log("From Box: x=" + fromBox.x + ", y=" + fromBox.y + ", width=" + fromBox.width + ", height=" + fromBox.height + "\n");
        msgPage.log("To Box: x=" + toBox.x + ", y=" + toBox.y + ", width=" + toBox.width + ", height=" + toBox.height + "\n");
        if (points.length > 0) {
            for (IlvPoint p : points) {
                msgPage.log("[" + p.x + "," + p.y + "]\n");
            }
            if (!DiagramFrameworkLinkPolicy.nonstrictContains((Rectangle2D)fromBox, (Point2D)points[0])) {
                msgPage.log((Object)new AlertMessage("ALERT ---- source point is out of From Box ---- delta=[" + (points[0].x - fromBox.x) + "," + (points[0].y - fromBox.y) + "]\n"));
            }
            if (!DiagramFrameworkLinkPolicy.nonstrictContains((Rectangle2D)toBox, (Point2D)points[points.length - 1])) {
                msgPage.log((Object)new AlertMessage("ALERT ---- destination point is out of To Box ---- delta=[" + (points[points.length - 1].x - toBox.x) + "," + (points[points.length - 1].y - toBox.y) + "]\n"));
            }
        } else {
            msgPage.log((Object)new AlertMessage("ALERT ----- POINTS IS EMPTY -----\n"));
        }
        msgPage.log((Object)new EmphasizedMessage("--- Ending Info: " + message + " ---\n"));
    }

    protected static boolean nonstrictContains(Rectangle2D rect, Point2D p) {
        boolean contains = true;
        if (p.getX() < rect.getX() || p.getX() > rect.getX() + rect.getWidth() || p.getY() < rect.getY() || p.getY() > rect.getY() + rect.getHeight()) {
            contains = false;
        }
        return contains;
    }

    public static class LinkInfo {
        private EndGraphicInfo _fromGraphic;
        private EndGraphicInfo _toGraphic;
        private IlvPoint[] _points;
        private Dimension _dim;

        public LinkInfo() {
        }

        public LinkInfo(EndGraphicInfo fromGraphic, EndGraphicInfo toGraphic) {
            this._fromGraphic = fromGraphic;
            this._toGraphic = toGraphic;
        }

        public LinkInfo(EndGraphicInfo fromGraphic, EndGraphicInfo toGraphic, IlvPoint[] points) {
            this(fromGraphic, toGraphic);
            this._points = points;
            this._dim = this.calcDimension(points);
        }

        public EndGraphicInfo getFromGraphicInfo() {
            return this._fromGraphic;
        }

        public EndGraphicInfo getToGraphicInfo() {
            return this._toGraphic;
        }

        public IlvPoint[] getPoints() {
            return this._points;
        }

        public Dimension getPathDimension() {
            return this._dim;
        }

        private Dimension calcDimension(IlvPoint[] points) {
            double lowX = points[0].getX();
            double highX = points[0].getX();
            double lowY = points[0].getY();
            double highY = points[0].getY();
            for (int i = 1; i < points.length; ++i) {
                if (points[i].getX() < lowX) {
                    lowX = points[i].getX();
                } else if (points[i].getX() > highX) {
                    highX = points[i].getX();
                }
                if (points[i].getY() < lowY) {
                    lowY = points[i].getY();
                    continue;
                }
                if (!(points[i].getY() > highY)) continue;
                highY = points[i].getY();
            }
            Dimension dim = new Dimension();
            dim.setWidth(highX - lowX);
            dim.setHeight(highY - lowY);
            return dim;
        }

        public static class EndGraphicInfo {
            private final IlvGraphic _graphic;
            private final IlvGraphic _visibleGraphic;
            private final IlvGraphic _connectedGraphic;
            private final IlvGraphic _endGraphic;
            private IlvRect _boundingBox;

            public EndGraphicInfo(IlvGraphic g, IlvGraphic visibleGraphic, IlvGraphic connectedGraphic, IlvGraphic endGraphic) {
                this._graphic = g;
                this._visibleGraphic = visibleGraphic;
                this._connectedGraphic = connectedGraphic;
                this._endGraphic = endGraphic;
                this._boundingBox = this._endGraphic != null ? this._endGraphic.boundingBox() : new IlvRect();
            }

            public IlvGraphic getGraphic() {
                return this._graphic;
            }

            public IlvGraphic getVisibleGraphic() {
                return this._visibleGraphic;
            }

            public IlvGraphic getConnectedGraphic() {
                return this._connectedGraphic;
            }

            public IlvGraphic getEndGraphic() {
                return this._endGraphic;
            }

            public IlvRect boundingBox() {
                return this._boundingBox;
            }
        }
    }
}

