/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.inspector;

import java.util.HashSet;
import oracle.bali.inspector.PropertyModel;

public class CompositePropertyModel
extends PropertyModel {
    private final String _displayName;
    private final PropertyModel[] _models;
    private final Object[] _columns;
    private final int _rowCount;

    public CompositePropertyModel(PropertyModel[] models) {
        this(null, models);
    }

    public CompositePropertyModel(String displayName, PropertyModel[] models) {
        this._displayName = displayName != null ? displayName : models[0].getTargetDisplayName();
        this._models = models;
        int totalRowCount = 0;
        HashSet<Object> usedColumns = new HashSet<Object>();
        for (int i = 0; i < this._models.length; ++i) {
            PropertyModel subModel = models[i];
            Object[] subColumns = subModel.getColumnMapping();
            for (int j = 0; j < subColumns.length; ++j) {
                usedColumns.add(subColumns[j]);
            }
            totalRowCount += subModel.getRowCount();
        }
        if (!usedColumns.contains(PropertyModel.COLUMN_ID) || !usedColumns.contains(PropertyModel.COLUMN_VALUE)) {
            throw new IllegalStateException("Model must contain COLUMN_ID and COLUMN_VALUE");
        }
        Object[] columns = usedColumns.toArray(new Object[usedColumns.size()]);
        this._columns = new Object[columns.length];
        this._columns[0] = PropertyModel.COLUMN_ID;
        this._columns[1] = PropertyModel.COLUMN_VALUE;
        int insert = 2;
        for (int i = 0; i < columns.length; ++i) {
            Object col = columns[i];
            if (col == PropertyModel.COLUMN_ID || col == PropertyModel.COLUMN_VALUE) continue;
            this._columns[insert++] = col;
        }
        this._rowCount = totalRowCount;
    }

    public String getTargetDisplayName() {
        return this._displayName;
    }

    public Object[] getColumnMapping() {
        return this._columns;
    }

    public int getRowCount() {
        return this._rowCount;
    }

    public void invalidateValueData() {
        for (int i = 0; i < this._models.length; ++i) {
            this._models[i].invalidateValueData();
        }
    }

    public Object getValueAt(int row, int column) {
        if (column == -1) {
            return PropertyModel.DOES_NOT_EXIST;
        }
        int[] actualRC = new int[2];
        PropertyModel subModel = this.mapPropertyModelRowColumn(row, column, actualRC);
        if (subModel == null || actualRC[0] == -1 || actualRC[1] == -1) {
            return PropertyModel.DOES_NOT_EXIST;
        }
        return subModel.getValueAt(actualRC[0], actualRC[1]);
    }

    public void setValueAt(Object data, int row, int column) {
        int[] actualRC = new int[2];
        PropertyModel subModel = this.mapPropertyModelRowColumn(row, column, actualRC);
        if (subModel == null || actualRC[0] == -1 || actualRC[1] == -1) {
            return;
        }
        subModel.setValueAt(data, actualRC[0], actualRC[1]);
    }

    protected PropertyModel mapPropertyModelRowColumn(int row, int column, int[] actual) {
        actual[0] = -1;
        actual[1] = -1;
        int rowCount = 0;
        PropertyModel model = null;
        for (int i = 0; i < this._models.length; ++i) {
            model = this._models[i];
            int rows = model.getRowCount();
            if (row >= rowCount && row < rowCount + rows) {
                actual[0] = row - rowCount;
                break;
            }
            rowCount += rows;
            model = null;
        }
        if (model == null) {
            throw new IllegalArgumentException("No sub model represented by row " + row);
        }
        Object property = this.getColumnMapping()[column];
        Object[] subColumns = model.getColumnMapping();
        for (int i = 0; i < subColumns.length; ++i) {
            if (!property.equals(subColumns[i])) continue;
            actual[1] = i;
            break;
        }
        return model;
    }
}

