/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.highlight;

import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.event.ManagerSelectionChangedEvent;
import ilog.views.event.ManagerSelectionListener;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import oracle.diagram.core.plugin.Plugin;
import oracle.diagram.core.plugin.PluginManager;
import oracle.diagram.framework.highlight.SecondaryHighlightGraphicsProvider;
import oracle.diagram.framework.highlight.ShapeHighlighter;

public abstract class MultiHighlightManager
implements ManagerSelectionListener,
Plugin {
    private IlvManagerView m_managerView;
    private Map<IlvGraphic, Collection<IlvGraphic>> m_secondaryGraphicsMap = new IdentityHashMap<IlvGraphic, Collection<IlvGraphic>>();

    public MultiHighlightManager(IlvManagerView view) {
        this.m_managerView = view;
        IlvManager mgr = view.getManager();
        mgr.addManagerTreeSelectionListener((ManagerSelectionListener)this);
    }

    public void dispose() {
        IlvManager mgr = this.m_managerView.getManager();
        mgr.removeManagerTreeSelectionListener((ManagerSelectionListener)this);
        this.m_secondaryGraphicsMap.clear();
    }

    public void highlightSecondaryGraphics(IlvGraphic primary) {
        SecondaryHighlightGraphicsProvider provider;
        Collection<IlvGraphic> secondaryGraphics = this.m_secondaryGraphicsMap.get(primary);
        if (secondaryGraphics == null && (provider = this.getSecondaryHighlightGraphicsProvider(primary)) != null) {
            secondaryGraphics = new LinkedList<IlvGraphic>();
            provider.getSecondaryGraphics(primary, secondaryGraphics);
            this.m_secondaryGraphicsMap.put(primary, secondaryGraphics);
        }
        if (secondaryGraphics != null) {
            for (IlvGraphic secondary : secondaryGraphics) {
                ShapeHighlighter.highlight(this.m_managerView, secondary, false);
            }
        }
    }

    public void unhighlightSecondaryGraphics(IlvGraphic primary) {
        Collection<IlvGraphic> secondaryGraphics = this.m_secondaryGraphicsMap.get(primary);
        if (secondaryGraphics != null) {
            for (IlvGraphic secondary : secondaryGraphics) {
                ShapeHighlighter.unhighlight(this.m_managerView, secondary, false);
            }
            this.m_secondaryGraphicsMap.remove(primary);
        }
    }

    public void selectionChanged(ManagerSelectionChangedEvent e) {
        IlvGraphic selectedGraphic = e.getGraphic();
        if (e.getType() == 1) {
            this.highlightSecondaryGraphics(selectedGraphic);
        } else {
            this.unhighlightSecondaryGraphics(selectedGraphic);
        }
    }

    @Override
    public void attach(PluginManager pluginManager, Class<? extends Plugin> pluginType) {
    }

    @Override
    public void detach(PluginManager pluginManager, Class<? extends Plugin> pluginType) {
    }

    protected abstract SecondaryHighlightGraphicsProvider getSecondaryHighlightGraphicsProvider(IlvGraphic var1);
}

