/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic.selection;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import javax.swing.UIManager;
import oracle.diagram.framework.graphic.DiagramRenderingHints;
import oracle.diagram.framework.graphic.FontInterface;

public class TextSelection
extends IlvSelection {
    public static final Color BACKGROUND_COLOR = UIManager.getDefaults().getColor("TextField.selectionBackground");
    public static final Color FOREGROUND_COLOR = UIManager.getDefaults().getColor("TextField.selectionForeground");

    public TextSelection(IlvGraphic object) {
        super(object);
    }

    public void draw(Graphics graphics, IlvTransformer t) {
        IlvGraphic graphic = this.getObject();
        if (!(graphic instanceof FontInterface)) {
            return;
        }
        FontInterface lineText = (FontInterface)graphic;
        Graphics2D g2d = (Graphics2D)graphics;
        IlvGraphicBag bag = graphic.getGraphicBag();
        if (!(bag instanceof IlvGraphic)) {
            return;
        }
        Color savedForeground = lineText.getFontColor();
        Paint savedBackground = g2d.getPaint();
        lineText.setFontColor(FOREGROUND_COLOR);
        Object value = g2d.getRenderingHint(DiagramRenderingHints.KEY_HC_TEXT_HIGHLIGHT);
        if (value != null) {
            g2d.setRenderingHint(DiagramRenderingHints.KEY_HC_TEXT_HIGHLIGHT, DiagramRenderingHints.VALUE_HC_TEXT_HIGHLIGHT_ON);
        }
        ((Graphics2D)graphics).setPaint(BACKGROUND_COLOR);
        IlvRect rect = graphic.boundingBox(t);
        ((Graphics2D)graphics).fill((Shape)rect);
        graphic.draw(graphics, t);
        if (value != null) {
            g2d.setRenderingHint(DiagramRenderingHints.KEY_HC_TEXT_HIGHLIGHT, value);
        }
        lineText.setFontColor(savedForeground);
        g2d.setPaint(savedBackground);
    }

    public IlvRect boundingBox(IlvTransformer t) {
        return this.getObject().boundingBox(t);
    }
}

