/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic.port;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.IlvUnresizeableDrawSelection;
import ilog.views.graphic.IlvLine;
import ilog.views.graphic.IlvRectangle;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import oracle.diagram.core.util.CoreGraphicUtils;
import oracle.diagram.framework.geom.DimensionFloat;
import oracle.diagram.framework.graphic.ContainerGraphic;
import oracle.diagram.framework.graphic.ExtendedGraphic;
import oracle.diagram.framework.preference.VisualProperty;
import oracle.diagram.framework.selection.SubSelectionManager;
import oracle.diagram.framework.shape.SubShape;

public abstract class PinBar
extends ContainerGraphic
implements VisualProperty {
    private List<IlvGraphic> _pins;
    private List<IlvGraphic> _dividers;
    private Color _fillColor;
    private Color _lineColor;
    private final float _dividerSize;

    protected PinBar(float dividerSize) {
        this._dividerSize = dividerSize;
        this._pins = new ArrayList<IlvGraphic>();
        this._dividers = new ArrayList<IlvGraphic>();
        IlvRectangle r = new IlvRectangle();
        r.setFillOn(false);
        r.setStrokeOn(false);
        r.setVisible(false);
        this.setChildren(0, (IlvGraphic)r);
        SubSelectionManager.setSelectable((IlvGraphic)r, false);
        SubSelectionManager.setSelectable((IlvGraphic)this, false);
        this.setProperty("NonEllipsisShape", Boolean.TRUE);
        this.setTopLevel(true);
    }

    public final IlvGraphic[] getPins() {
        return this._pins.toArray(new IlvGraphic[this._pins.size()]);
    }

    public final float getDividerSize() {
        return this._dividerSize;
    }

    protected final IlvGraphic createDivider() {
        return new DividerLine(this.getDividerSize());
    }

    protected void setPinInfo(IlvGraphic pin) {
    }

    protected abstract boolean isVertical();

    public final void setPins(IlvGraphic[] pins) {
        LinkedList<Object> childrenList = new LinkedList<Object>();
        IlvGraphic outline = this.getChildren(0);
        childrenList.add(outline);
        int newPinCount = pins == null ? 0 : pins.length;
        ArrayList<IlvGraphic> newPinsList = new ArrayList<IlvGraphic>(newPinCount);
        ArrayList<IlvGraphic> newDividersList = new ArrayList<IlvGraphic>(newPinCount <= 1 ? 0 : newPinCount - 1);
        ArrayList<IlvGraphic> oldPinsList = new ArrayList<IlvGraphic>(this._pins);
        float newHeight = 0.0f;
        float newWidth = 0.0f;
        for (int i = 0; i < newPinCount; ++i) {
            IlvGraphic divider;
            IlvGraphic pin = pins[i];
            if (pin instanceof ExtendedGraphic) {
                DimensionFloat dim = ((ExtendedGraphic)pin).getMinimumSize(new DimensionFloat());
                if (this.isVertical()) {
                    newWidth = Math.max(newWidth, dim.width);
                    newHeight += dim.height;
                } else {
                    newHeight = Math.max(newHeight, dim.height);
                    newWidth += dim.width;
                }
            } else {
                IlvRect r = pin.boundingBox();
                if (this.isVertical()) {
                    newWidth = Math.max(newWidth, r.width);
                    newHeight += r.height;
                } else {
                    newHeight = Math.max(newHeight, r.height);
                    newWidth += r.width;
                }
            }
            if (pin instanceof VisualProperty) {
                ((VisualProperty)pin).setShapeFillColor(this._fillColor);
                ((VisualProperty)pin).setShapeLineColor(this._lineColor);
            }
            childrenList.add(pin);
            newPinsList.add(pin);
            this.setPinInfo(pin);
            if (oldPinsList.contains(pin)) {
                oldPinsList.remove(pin);
            }
            if (i >= newPinCount - 1) continue;
            IlvGraphic ilvGraphic = divider = i < this._dividers.size() ? this._dividers.get(i) : this.createDivider();
            if (this.isVertical()) {
                newHeight += this.getDividerSize();
            } else {
                newWidth += this.getDividerSize();
            }
            childrenList.add(divider);
            newDividersList.add(divider);
        }
        SubSelectionManager ssm = SubSelectionManager.getInstance();
        for (IlvGraphic pin : oldPinsList) {
            ssm.select(CoreGraphicUtils.getManagedParentNode((IlvGraphic)this), pin, false, true);
        }
        this._pins = newPinsList;
        this._dividers = newDividersList;
        this.setChildren(childrenList.toArray(new IlvGraphic[childrenList.size()]));
        DimensionFloat size = new DimensionFloat(newWidth, newHeight);
        this.setMinimumSize(size);
        this.setPreferedSize(size);
        this.moveResize(new IlvRect(0.0f, 0.0f, size.width, size.height));
        IlvGraphicBag bag = this.getGraphicBag();
        if (bag != null) {
            ((ContainerGraphic)bag).invalidate(true);
            ((ContainerGraphic)bag).doLayout();
            ((ContainerGraphic)bag).reDraw();
        }
        this.invalidate(true);
        this.doLayout();
        this.reDraw();
    }

    @Override
    public Color getShapeFillColor() {
        return null;
    }

    @Override
    public void setShapeFillColor(Color color) {
        this._fillColor = color;
        for (IlvGraphic pin : this._pins) {
            if (!(pin instanceof VisualProperty)) continue;
            ((VisualProperty)pin).setShapeFillColor(color);
        }
    }

    @Override
    public Font getShapeFont() {
        return null;
    }

    @Override
    public void setShapeFont(Font font) {
    }

    @Override
    public Color getShapeLineColor() {
        return null;
    }

    @Override
    public void setShapeLineColor(Color color) {
        this._lineColor = color;
        for (IlvGraphic pin : this._pins) {
            if (!(pin instanceof VisualProperty)) continue;
            ((VisualProperty)pin).setShapeLineColor(color);
        }
    }

    @Override
    public Color getShapeFontColor() {
        return null;
    }

    @Override
    public void setShapeFontColor(Color color) {
    }

    private static class DividerLine
    extends IlvLine
    implements SubShape {
        public DividerLine(float height) {
            SubSelectionManager.setSelectable((IlvGraphic)this, false);
            this.setLineWidth(height);
            this.setProperty("NonEllipsisShape", Boolean.TRUE);
        }

        public void draw(Graphics dst, IlvTransformer t) {
        }

        public IlvSelection makeSelection() {
            return new IlvUnresizeableDrawSelection((IlvGraphic)this);
        }
    }
}

