/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic.layout.column;

import ilog.views.IlvGraphic;
import ilog.views.IlvManagerView;
import ilog.views.IlvObjectInteractor;
import ilog.views.IlvObjectInteractorContext;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.event.TransformerChangedEvent;
import ilog.views.event.TransformerListener;
import ilog.views.graphic.IlvLine;
import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.context.IdeContextPlugin;
import oracle.diagram.core.interaction.CoreSelectInteractor;
import oracle.diagram.core.interaction.IdeObjectInteractorContext;
import oracle.diagram.framework.geom.DimensionFloat;
import oracle.diagram.framework.graphic.ExtendedGraphic;
import oracle.diagram.framework.graphic.layout.column.ColumnContainer;
import oracle.diagram.framework.graphic.layout.column.ResizeColumnUndoableStep;
import oracle.diagram.framework.undo.UndoableStep;
import oracle.diagram.framework.undo.UndoableStepManager;

public class ResizeColumnInteractor
extends IlvObjectInteractor {
    private IlvPoint m_pt = new IlvPoint();
    private ColumnContainer m_container;
    private IlvLine m_divider;
    private boolean m_dragging;
    private int m_columnIndex;
    private IlvPoint m_initialPressPoint;
    private IlvRect m_initialDividerRect;
    private Cursor m_oldCursor;
    private float m_minWidth;
    private UndoableStep m_undoStep;
    private MouseEvent m_lastDragEvent;
    private IlvObjectInteractorContext m_lastContext;
    private MyTransformerListener m_transformerListener;

    public boolean processEvent(IlvGraphic g, AWTEvent awtEvent, IlvObjectInteractorContext context) {
        if (g instanceof ColumnContainer && awtEvent instanceof MouseEvent) {
            ColumnContainer cg = (ColumnContainer)g;
            MouseEvent mouseEvent = (MouseEvent)awtEvent;
            this.m_pt.x = mouseEvent.getX();
            this.m_pt.y = mouseEvent.getY();
            IlvTransformer t = context.getTransformer();
            if (!this.m_dragging) {
                IlvManagerView view = this.getView(context);
                IlvGraphic subshape = cg.getSubShape(this.m_pt, view);
                if (subshape != null && subshape instanceof IlvLine && subshape.getGraphicBag() instanceof ColumnContainer) {
                    this.m_container = (ColumnContainer)subshape.getGraphicBag();
                    this.m_divider = (IlvLine)subshape;
                    this.m_columnIndex = this.m_container.getColumnIndex(this.m_divider);
                } else {
                    this.m_container = null;
                    this.m_divider = null;
                    this.m_columnIndex = -1;
                }
            }
            switch (awtEvent.getID()) {
                case 503: {
                    return this.mouseMoved(context);
                }
                case 501: {
                    return this.mousePressed(context);
                }
                case 506: {
                    this.m_lastDragEvent = mouseEvent;
                    this.m_lastContext = context;
                    return this.mouseDragged(context);
                }
                case 502: {
                    this.mouseDragged(context);
                    return this.mouseReleased(context);
                }
            }
        }
        return false;
    }

    private boolean mousePressed(IlvObjectInteractorContext context) {
        if (this.m_container != null && this.m_container.canResizeColumns() && this.m_columnIndex != -1) {
            this.m_dragging = true;
            this.m_initialPressPoint = new IlvPoint(this.m_pt);
            IlvManagerView view = this.getView(context);
            view.getTransformer().inverse(this.m_initialPressPoint);
            this.m_initialDividerRect = new IlvRect(this.m_divider.boundingBox(null));
            this.m_minWidth = this.m_container.getMinimumColumnSize((int)this.m_columnIndex, (DimensionFloat)new DimensionFloat()).width + 1.0f;
            this.m_undoStep = new ResizeColumnUndoableStep(this.m_container, this.m_columnIndex);
            this.m_undoStep.storeUndoState();
            this.m_transformerListener = new MyTransformerListener();
            view.addTransformerListener((TransformerListener)this.m_transformerListener);
            if (view.getInteractor() instanceof CoreSelectInteractor) {
                ((CoreSelectInteractor)view.getInteractor()).setCanAutoscroll(true);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mouseDragged(IlvObjectInteractorContext context) {
        if (this.m_dragging) {
            IlvPoint newPoint = new IlvPoint(this.m_pt);
            IlvManagerView view = this.getView(context);
            view.getTransformer().inverse(newPoint);
            ExtendedGraphic column = this.m_container.getColumnGraphic(this.m_columnIndex);
            IlvRect bbox = ((IlvGraphic)column).boundingBox(null);
            float x1 = newPoint.x - (this.m_initialPressPoint.x - this.m_initialDividerRect.x);
            float newWidth = Double.valueOf(Math.floor(Float.valueOf(x1 - bbox.x).floatValue())).floatValue();
            if (newWidth < this.m_minWidth) {
                newWidth = this.m_minWidth;
            }
            if (newWidth != bbox.width) {
                view.getManager().initReDraws();
                int redrawMode = view.getRedrawMode();
                view.setRedrawMode(1);
                try {
                    this.m_container.resizeColumn(this.m_columnIndex, newWidth);
                }
                finally {
                    try {
                        view.setRedrawMode(1);
                        view.getManager().reDrawViews();
                    }
                    finally {
                        view.setRedrawMode(redrawMode);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private boolean mouseReleased(IlvObjectInteractorContext context) {
        if (this.m_dragging) {
            IlvManagerView view = this.getView(context);
            view.removeTransformerListener((TransformerListener)this.m_transformerListener);
            if (view.getInteractor() instanceof CoreSelectInteractor) {
                ((CoreSelectInteractor)view.getInteractor()).setCanAutoscroll(false);
            }
            this.m_undoStep.storeRedoState();
            UndoableStepManager usm = this.getUndoableStepManager((IlvGraphic)this.m_container);
            if (usm != null) {
                usm.addUndoableStep(this.m_undoStep, this.getUndoDescription((IlvGraphic)this.m_container));
            }
            this.m_undoStep = null;
            this.m_transformerListener = null;
            this.m_lastDragEvent = null;
            this.m_lastContext = null;
            this.m_dragging = false;
            this.m_container = null;
            this.m_divider = null;
            this.m_columnIndex = -1;
            DiagramContext dc = DiagramContext.getDiagramContext(this.getView(context));
            dc.getPlugin(IdeContextPlugin.class).getContext().getNode().markDirty(true);
            return true;
        }
        return false;
    }

    private boolean mouseMoved(IlvObjectInteractorContext context) {
        if (this.m_container != null && this.m_container.canResizeColumns() && this.m_columnIndex != -1) {
            Cursor cursor = Cursor.getPredefinedCursor(11);
            this.m_oldCursor = context.getCursor();
            context.setCursor(cursor);
            return true;
        }
        if (this.m_columnIndex == -1 && this.m_oldCursor != null) {
            context.setCursor(this.m_oldCursor);
            this.m_oldCursor = null;
        }
        return false;
    }

    protected String getUndoDescription(IlvGraphic graphic) {
        return null;
    }

    protected UndoableStepManager getUndoableStepManager(IlvGraphic graphic) {
        return null;
    }

    protected IlvManagerView getView(IlvObjectInteractorContext context) {
        if (context instanceof IlvManagerView) {
            return (IlvManagerView)context;
        }
        if (context instanceof IdeObjectInteractorContext) {
            return ((IdeObjectInteractorContext)context).getView();
        }
        throw new IllegalStateException("Unable to determine view");
    }

    private class MyTransformerListener
    implements TransformerListener {
        private MyTransformerListener() {
        }

        public void transformerChanged(TransformerChangedEvent transformerChangedEvent) {
            if (ResizeColumnInteractor.this.m_lastDragEvent != null && ResizeColumnInteractor.this.m_container != null) {
                final MouseEvent event = new MouseEvent(ResizeColumnInteractor.this.m_lastDragEvent.getComponent(), 506, System.currentTimeMillis(), ResizeColumnInteractor.this.m_lastDragEvent.getModifiers(), ResizeColumnInteractor.this.m_lastDragEvent.getX(), ResizeColumnInteractor.this.m_lastDragEvent.getY(), ResizeColumnInteractor.this.m_lastDragEvent.getClickCount(), false, ResizeColumnInteractor.this.m_lastDragEvent.getButton());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ResizeColumnInteractor.this.m_container != null && ResizeColumnInteractor.this.m_lastContext != null) {
                            ResizeColumnInteractor.this.processEvent((IlvGraphic)ResizeColumnInteractor.this.m_container, event, ResizeColumnInteractor.this.m_lastContext);
                        }
                    }
                });
            }
        }
    }
}

