/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic.features;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvRect;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.plugin.Plugin;
import oracle.diagram.core.plugin.PluginManager;
import oracle.diagram.framework.graphic.features.BatchGraphic;
import oracle.diagram.framework.graphic.features.DistributeFormat;
import oracle.diagram.framework.graphic.features.DistributePanel;
import oracle.diagram.framework.graphic.features.DistributePlugin;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.ide.Ide;

public class DefaultDistributePlugin
implements DistributePlugin {
    private DistributeFormat _dFormat = new DistributeFormat(DistributeFormat.HorizontalMode.NONE, DistributeFormat.VerticalMode.NONE);
    private final DiagramContext _context;

    public DefaultDistributePlugin(DiagramContext context) {
        this._context = context;
    }

    @Override
    public void setDistributeFormat(DistributeFormat dFormat) {
        this._dFormat = dFormat;
    }

    @Override
    public DistributeFormat getDisributeFormat() {
        return this._dFormat;
    }

    @Override
    public boolean configureDistribute() {
        DistributePanel dPanel = new DistributePanel();
        if (dPanel.showDialog((Frame)Ide.getMainWindow())) {
            this._dFormat = dPanel.getDistributeFormat();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void distribute() {
        IlvGraphic element;
        if (this._dFormat.getHorizontalDistributeMode() == DistributeFormat.HorizontalMode.NONE && this._dFormat.getVerticalDistributeMode() == DistributeFormat.VerticalMode.NONE) {
            return;
        }
        IlvManager manager = this.getDiagramContext().getManagerView().getManager();
        IlvGraphicEnumeration selection = manager.getSelectedObjects(true);
        ArrayList<BatchGraphic> dCol = new ArrayList<BatchGraphic>();
        float xSpaceUsed = 0.0f;
        float ySpaceUsed = 0.0f;
        while (selection.hasMoreElements()) {
            element = selection.nextElement();
            if (element instanceof IlvLinkImage) continue;
            BatchGraphic dStruct = new BatchGraphic(element);
            dCol.add(dStruct);
            xSpaceUsed += dStruct.rect.width;
            ySpaceUsed += dStruct.rect.height;
        }
        this.distributeHorizontal(dCol, xSpaceUsed);
        this.distributeVertical(dCol, ySpaceUsed);
        selection = manager.getSelectedObjects(true);
        try {
            manager.initReDraws();
            manager.setContentsAdjusting(true);
            manager.setSelectionAdjusting(true);
            manager.deSelectAll(true, true);
            this.applyChanges(dCol);
            while (selection.hasMoreElements()) {
                element = selection.nextElement();
                IlvManager localManager = ManagerUtil.getManager(element);
                localManager.setSelected(element, true, true);
            }
        }
        finally {
            manager.setSelectionAdjusting(false);
            manager.setContentsAdjusting(false);
            manager.reDrawViews();
        }
    }

    protected void applyChanges(Collection<BatchGraphic> batch) {
        for (BatchGraphic elt : batch) {
            elt.applyChanges();
        }
    }

    @Override
    public void attach(PluginManager pluginManager, Class<? extends Plugin> pluginType) {
    }

    @Override
    public void detach(PluginManager pluginManager, Class<? extends Plugin> pluginType) {
    }

    protected void distributeHorizontal(List<BatchGraphic> dCol, float xSpaceUsed) {
        DistributeFormat.HorizontalMode hMode = this._dFormat.getHorizontalDistributeMode();
        if (hMode == DistributeFormat.HorizontalMode.NONE) {
            return;
        }
        Collections.sort(dCol, new IlvGraphicXComparator());
        switch (hMode) {
            case LEFT: {
                this.distributeHorizontalLeft(dCol, xSpaceUsed);
                break;
            }
            case CENTER: {
                this.distributeHorizontalCenter(dCol, xSpaceUsed);
                break;
            }
            case SPACING: {
                this.distributeHorizontalSpacing(dCol, xSpaceUsed);
                break;
            }
            case RIGHT: {
                this.distributeHorizontalRight(dCol, xSpaceUsed);
            }
        }
    }

    protected void distributeHorizontalSpacing(List<BatchGraphic> col, float spaceUsed) {
        float spaceTotal = col.get((int)(col.size() - 1)).rect.x + col.get((int)(col.size() - 1)).rect.width - col.get((int)0).rect.x;
        float freeSpace = spaceTotal - spaceUsed;
        float diffSpace = freeSpace / (float)(col.size() - 1);
        float nextXBase = col.get((int)0).rect.x - diffSpace;
        for (BatchGraphic elt : col) {
            IlvRect bBox = elt.rect;
            bBox.x = nextXBase + diffSpace;
            nextXBase += diffSpace + bBox.width;
        }
    }

    protected void distributeHorizontalLeft(List<BatchGraphic> col, float spaceUsed) {
        float spaceTotal = col.get((int)(col.size() - 1)).rect.x - col.get((int)0).rect.x;
        float diffSpace = spaceTotal / (float)(col.size() - 1);
        float nextXBase = col.get((int)0).rect.x - diffSpace;
        for (BatchGraphic elt : col) {
            IlvRect bBox = elt.rect;
            bBox.x = nextXBase + diffSpace;
            nextXBase += diffSpace;
        }
    }

    protected void distributeHorizontalCenter(List<BatchGraphic> col, float spaceUsed) {
        float spaceTotal = col.get((int)(col.size() - 1)).rect.x + col.get((int)(col.size() - 1)).rect.width / 2.0f - (col.get((int)0).rect.x + col.get((int)0).rect.width / 2.0f);
        float diffSpace = spaceTotal / (float)(col.size() - 1);
        float nextXBase = col.get((int)0).rect.x + col.get((int)0).rect.width / 2.0f - diffSpace;
        for (BatchGraphic elt : col) {
            IlvRect bBox = elt.rect;
            bBox.x = nextXBase + diffSpace - bBox.width / 2.0f;
            nextXBase += diffSpace;
        }
    }

    protected void distributeHorizontalRight(List<BatchGraphic> col, float spaceUsed) {
        float spaceTotal = col.get((int)(col.size() - 1)).rect.x + col.get((int)(col.size() - 1)).rect.width - (col.get((int)0).rect.x + col.get((int)0).rect.width);
        float diffSpace = spaceTotal / (float)(col.size() - 1);
        float nextXBase = col.get((int)0).rect.x + col.get((int)0).rect.width - diffSpace;
        for (BatchGraphic elt : col) {
            IlvRect bBox = elt.rect;
            bBox.x = nextXBase + diffSpace - bBox.width;
            nextXBase += diffSpace;
        }
    }

    protected void distributeVertical(List<BatchGraphic> dCol, float ySpaceUsed) {
        DistributeFormat.VerticalMode vMode = this._dFormat.getVerticalDistributeMode();
        if (vMode == DistributeFormat.VerticalMode.NONE) {
            return;
        }
        Collections.sort(dCol, new IlvGraphicYComparator());
        switch (vMode) {
            case TOP: {
                this.distributeVerticalTop(dCol, ySpaceUsed);
                break;
            }
            case CENTER: {
                this.distributeVerticalCenter(dCol, ySpaceUsed);
                break;
            }
            case SPACING: {
                this.distributeVerticalSpacing(dCol, ySpaceUsed);
                break;
            }
            case BOTTOM: {
                this.distributeVerticalBottom(dCol, ySpaceUsed);
            }
        }
    }

    protected void distributeVerticalSpacing(List<BatchGraphic> col, float spaceUsed) {
        float spaceTotal = col.get((int)(col.size() - 1)).rect.y + col.get((int)(col.size() - 1)).rect.height - col.get((int)0).rect.y;
        float freeSpace = spaceTotal - spaceUsed;
        float diffSpace = freeSpace / (float)(col.size() - 1);
        float nextYBase = col.get((int)0).rect.y - diffSpace;
        for (BatchGraphic elt : col) {
            IlvRect bBox = elt.rect;
            bBox.y = nextYBase + diffSpace;
            nextYBase += diffSpace + bBox.height;
        }
    }

    protected void distributeVerticalTop(List<BatchGraphic> col, float spaceUsed) {
        float spaceTotal = col.get((int)(col.size() - 1)).rect.y - col.get((int)0).rect.y;
        float diffSpace = spaceTotal / (float)(col.size() - 1);
        float nextYBase = col.get((int)0).rect.y - diffSpace;
        for (BatchGraphic elt : col) {
            IlvRect bBox = elt.rect;
            bBox.y = nextYBase + diffSpace;
            nextYBase += diffSpace;
        }
    }

    protected void distributeVerticalCenter(List<BatchGraphic> col, float spaceUsed) {
        float spaceTotal = col.get((int)(col.size() - 1)).rect.y + col.get((int)(col.size() - 1)).rect.height / 2.0f - (col.get((int)0).rect.y + col.get((int)0).rect.height / 2.0f);
        float diffSpace = spaceTotal / (float)(col.size() - 1);
        float nextYBase = col.get((int)0).rect.y + col.get((int)0).rect.height / 2.0f - diffSpace;
        for (BatchGraphic elt : col) {
            IlvRect bBox = elt.rect;
            bBox.y = nextYBase + diffSpace - bBox.height / 2.0f;
            nextYBase += diffSpace;
        }
    }

    protected void distributeVerticalBottom(List<BatchGraphic> col, float spaceUsed) {
        float spaceTotal = col.get((int)(col.size() - 1)).rect.y + col.get((int)(col.size() - 1)).rect.height - (col.get((int)0).rect.y + col.get((int)0).rect.height);
        float diffSpace = spaceTotal / (float)(col.size() - 1);
        float nextYBase = col.get((int)0).rect.y + col.get((int)0).rect.height - diffSpace;
        for (BatchGraphic elt : col) {
            IlvRect bBox = elt.rect;
            bBox.y = nextYBase + diffSpace - bBox.height;
            nextYBase += diffSpace;
        }
    }

    protected final DiagramContext getDiagramContext() {
        return this._context;
    }

    private static final class IlvGraphicYComparator
    implements Comparator<BatchGraphic> {
        private IlvGraphicYComparator() {
        }

        @Override
        public int compare(BatchGraphic g1, BatchGraphic g2) {
            if (g1.rect.y < g2.rect.y) {
                return -1;
            }
            if (g1.rect.y > g2.rect.y) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }
    }

    private static final class IlvGraphicXComparator
    implements Comparator<BatchGraphic> {
        private IlvGraphicXComparator() {
        }

        @Override
        public int compare(BatchGraphic g1, BatchGraphic g2) {
            if (g1.rect.x < g2.rect.x) {
                return -1;
            }
            if (g1.rect.x > g2.rect.x) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }
    }
}

