/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic;

import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import oracle.diagram.framework.graphic.RectangleOutline;
import oracle.diagram.framework.transformer.TransformerUtil;

public class OpenRectangleOutline
extends RectangleOutline {
    private boolean _isTopOpen = false;
    private boolean _isBottomOpen = false;
    private boolean _isRightOpen = false;
    private boolean _isLeftOpen = false;

    public OpenRectangleOutline(IlvRect rect) {
        super(rect);
    }

    public OpenRectangleOutline(RectangleOutline source) {
        super(source);
        this.setOpenBorders(this.isTopOpen(), this.isLeftOpen(), this.isBottomOpen(), this.isRightOpen());
    }

    public void setOpenBorders(boolean isTopOpen, boolean isLeftOpen, boolean isBottomOpen, boolean isRightOpen) {
        this._isTopOpen = isTopOpen;
        this._isLeftOpen = isLeftOpen;
        this._isBottomOpen = isBottomOpen;
        this._isRightOpen = isRightOpen;
    }

    public boolean isTopOpen() {
        return this._isTopOpen;
    }

    public boolean isLeftOpen() {
        return this._isLeftOpen;
    }

    public boolean isBottomOpen() {
        return this._isBottomOpen;
    }

    public boolean isRightOpen() {
        return this._isRightOpen;
    }

    @Override
    public Shape getShape() {
        if (!(this._isTopOpen || this._isLeftOpen || this._isBottomOpen || this._isRightOpen)) {
            return super.getShape();
        }
        return this.getOutlinePath(this._bounds);
    }

    protected GeneralPath getOutlinePath(IlvRect r) {
        GeneralPath gp = new GeneralPath();
        gp.moveTo(r.x, r.y);
        if (this._isTopOpen) {
            gp.moveTo(r.x + r.width, r.y);
        } else {
            gp.lineTo(r.x + r.width, r.y);
        }
        if (this._isRightOpen) {
            gp.moveTo(r.x + r.width, r.y + r.height);
        } else {
            gp.lineTo(r.x + r.width, r.y + r.height);
        }
        if (this._isBottomOpen) {
            gp.moveTo(r.x, r.y + r.height);
        } else {
            gp.lineTo(r.x, r.y + r.height);
        }
        if (!this._isLeftOpen) {
            gp.lineTo(r.x, r.y);
        }
        return gp;
    }

    @Override
    public void draw(Graphics dst, IlvTransformer t) {
        if (!(this._isTopOpen || this._isLeftOpen || this._isBottomOpen || this._isRightOpen)) {
            super.draw(dst, t);
            return;
        }
        Graphics2D g2d = (Graphics2D)dst;
        Color oldColor = g2d.getColor();
        Stroke oldStroke = g2d.getStroke();
        IlvRect drawRect = new IlvRect(this._bounds);
        IlvRect pathRect = new IlvRect(drawRect);
        pathRect.width -= 1.0f;
        pathRect.height -= 1.0f;
        GeneralPath path = this.getOutlinePath(pathRect);
        float penThickness = this.getThickness();
        if (t != null) {
            penThickness = TransformerUtil.getApplied(t, penThickness);
            TransformerUtil.apply(t, (Rectangle2D)drawRect);
            path.transform(TransformerUtil.getAffineTransform(t));
        }
        if (this.isFillOn()) {
            g2d.setColor(this.getBackground());
            g2d.fill((Shape)drawRect);
        }
        if (this._isBorderOn && penThickness > 0.0f) {
            g2d.setStroke(new BasicStroke(penThickness));
            g2d.setColor(this.getForeground());
            g2d.draw(path);
        }
        g2d.setColor(oldColor);
        g2d.setStroke(oldStroke);
    }

    @Override
    public void drawBorder(Graphics dst, IlvTransformer t) {
        if (this._isBorderOn) {
            if (!(this._isTopOpen || this._isLeftOpen || this._isBottomOpen || this._isRightOpen)) {
                super.draw(dst, t);
                return;
            }
            float penThickness = this.getThickness();
            if (penThickness > 0.0f) {
                Graphics2D g2d = (Graphics2D)dst;
                Color oldColor = g2d.getColor();
                Stroke oldStroke = g2d.getStroke();
                IlvRect drawRect = new IlvRect(this._bounds);
                IlvRect pathRect = new IlvRect(drawRect);
                pathRect.width -= 1.0f;
                pathRect.height -= 1.0f;
                GeneralPath path = this.getOutlinePath(pathRect);
                if (t != null) {
                    penThickness = TransformerUtil.getApplied(t, penThickness);
                    TransformerUtil.apply(t, (Rectangle2D)drawRect);
                    path.transform(TransformerUtil.getAffineTransform(t));
                }
                g2d.setStroke(new BasicStroke(penThickness));
                g2d.setColor(this.getForeground());
                g2d.draw(path);
                g2d.setColor(oldColor);
                g2d.setStroke(oldStroke);
            }
        }
    }
}

