/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.dragdrop.handler;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.bm.util.ResourcePicker;
import oracle.bm.util.ui.HintLabel;
import oracle.diagram.framework.dragdrop.handler.SelectionPreference;
import oracle.diagram.framework.dragdrop.handler.SubDropHandler;
import oracle.ide.Context;
import oracle.ide.model.TechId;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.data.PropertyStorage;

public class DropChooserPanel
extends JPanel {
    private ResourcePicker m_rp;
    private Context m_context;
    private Set<SubDropHandler> m_availableHandlers;
    private HintLabel m_hintText;
    private JLabel m_filterByLabel;
    private JComboBox m_filterByCombo;
    private JScrollPane m_scrollPane;
    private JList m_optionsList;
    private final FilterItem[] m_items;
    private final boolean m_hasProjectContext;

    public DropChooserPanel(ResourcePicker rp, Context context, Set<SubDropHandler> available, Set<SubDropHandler> conflicted) {
        this.m_rp = rp;
        this.m_context = context;
        this.m_hasProjectContext = context.getProject() != null;
        this.m_items = new FilterItem[this.m_hasProjectContext ? 2 : 1];
        this.m_availableHandlers = available;
        this.setName("DropChooserPanel");
        this.createComponents();
        this.layoutComponents();
        rp.start((Container)this);
    }

    private boolean hasProjectContext() {
        return this.m_hasProjectContext;
    }

    private void createComponents() {
        this.m_hintText = new HintLabel();
        this.m_hintText.setName("HintText");
        if (this.hasProjectContext()) {
            this.m_filterByLabel = new JLabel();
            this.m_filterByLabel.setName("FilterLabel");
            this.m_filterByCombo = new JComboBox();
            this.m_filterByLabel.setLabelFor(this.m_filterByCombo);
        }
        this.m_optionsList = new JList();
        this.m_scrollPane = new JScrollPane(this.m_optionsList);
        this.m_optionsList.setSelectionMode(2);
        this.m_optionsList.setCellRenderer(new HandlerCellRenderer());
        this.m_items[0] = new FilterItem("DropChooserPanel.AllTechnologies");
        TechnologyScope ts = null;
        if (this.hasProjectContext()) {
            TechnologyScopeConfiguration tsc = TechnologyScopeConfiguration.getInstance((PropertyStorage)this.m_context.getProject());
            ts = tsc.getTechnologyScope();
            this.m_items[1] = new FilterItem("DropChooserPanel.ProjectTechnologies");
            this.m_filterByCombo.addItem(this.m_items[0]);
            this.m_filterByCombo.addItem(this.m_items[1]);
        }
        block0: for (SubDropHandler handler : this.m_availableHandlers) {
            TechId[] ids;
            this.m_items[0].addHandler(handler);
            if (!this.hasProjectContext() || (ids = handler.getFilterTechIds()) == null) continue;
            for (TechId id : ids) {
                if (!ts.contains(id)) continue;
                this.m_items[1].addHandler(handler);
                continue block0;
            }
        }
        this.m_items[0].sort();
        if (this.hasProjectContext()) {
            this.m_items[1].sort();
            this.m_filterByCombo.setSelectedIndex(this.m_items[1].isEmpty() ? 0 : 1);
            this.m_filterByCombo.setEnabled(!this.m_items[1].isEmpty());
        }
        this.populateOptions();
        if (this.hasProjectContext()) {
            this.m_filterByCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DropChooserPanel.this.populateOptions();
                }
            });
        }
    }

    protected void populateOptions() {
        FilterItem scope = this.hasProjectContext() ? (FilterItem)this.m_filterByCombo.getSelectedItem() : this.m_items[0];
        scope.populate();
    }

    public void layoutComponents() {
        LayoutBuilder builder = new LayoutBuilder();
        int columns = this.hasProjectContext() ? 3 : 1;
        builder.setDefaultAnchor(18);
        builder.add((Component)this.m_hintText, LayoutBuilder.GROUP_INSETS, columns, false, true);
        builder.nl();
        if (this.hasProjectContext()) {
            builder.add((Component)this.m_filterByLabel, LayoutBuilder.LABEL_INSETS, 1, false, false);
            builder.add((Component)this.m_filterByCombo, LayoutBuilder.CONTROL_INSETS, 1, false, false);
            builder.addHFiller();
            builder.nl();
        }
        builder.add((Component)this.m_scrollPane, LayoutBuilder.ZERO_INSETS, columns, true, true);
        builder.addToPanel((Container)this);
    }

    public JList getHandlerList() {
        return this.m_optionsList;
    }

    public Set<SubDropHandler> getSelection() {
        HashSet<SubDropHandler> selection = new HashSet<SubDropHandler>();
        for (Object selectedValue : this.m_optionsList.getSelectedValues()) {
            selection.add((SubDropHandler)selectedValue);
        }
        return selection;
    }

    private class FilterItem {
        private String m_description;
        private ArrayList<SubDropHandler> m_handlers = new ArrayList();
        private int m_initialSelection;

        private FilterItem(String descKey) {
            this.m_description = DropChooserPanel.this.m_rp.getString(descKey);
        }

        public void addHandler(SubDropHandler handler) {
            this.m_handlers.add(handler);
        }

        public boolean isEmpty() {
            return this.m_handlers.isEmpty();
        }

        public void sort() {
            int i;
            Collections.sort(this.m_handlers, new Comparator<SubDropHandler>(){

                @Override
                public int compare(SubDropHandler h1, SubDropHandler h2) {
                    return h1.getName().compareTo(h2.getName());
                }
            });
            int[] initialIndices = new int[SelectionPreference.values().length];
            for (i = 0; i < initialIndices.length; ++i) {
                initialIndices[i] = -1;
            }
            int size = this.m_handlers.size();
            for (i = 0; i < size; ++i) {
                SelectionPreference sp = this.m_handlers.get(i).getSelectionPreference(DropChooserPanel.this.m_context);
                if (initialIndices[sp.ordinal()] != -1) continue;
                initialIndices[sp.ordinal()] = i;
            }
            for (int index : initialIndices) {
                if (index == -1) continue;
                this.m_initialSelection = index;
                break;
            }
        }

        public void populate() {
            DropChooserPanel.this.m_optionsList.setListData(this.m_handlers.toArray());
            DropChooserPanel.this.m_optionsList.setSelectedIndex(this.m_initialSelection);
        }

        public String toString() {
            return this.m_description;
        }
    }

    private class HandlerCellRenderer
    extends DefaultListCellRenderer {
        private HandlerCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return super.getListCellRendererComponent((JList<?>)list, ((SubDropHandler)value).getName(), index, isSelected, cellHasFocus);
        }
    }
}

