/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.datatransfer;

import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import oracle.diagram.framework.datatransfer.SelectionTransferData;

public class SelectionTransferable
implements ClipboardOwner,
Transferable {
    public static final DataFlavor FLAVOR = new DataFlavor(SelectionTransferable.class, "SelectionTransferable");
    private final DataFlavor[] _flavors;
    private final IlvManager _manager;
    private Object _data;

    public SelectionTransferable(IlvManager manager) throws IOException {
        this(manager, new DataFlavor[]{FLAVOR}, null);
    }

    public SelectionTransferable(IlvManager manager, IlvPoint startPoint) throws IOException {
        this(manager, new DataFlavor[]{FLAVOR}, startPoint);
    }

    public SelectionTransferable(IlvManager manager, DataFlavor flavor, IlvPoint startPoint) throws IOException {
        this(manager, new DataFlavor[]{flavor}, startPoint);
    }

    protected SelectionTransferable(IlvManager manager, DataFlavor[] flavors, IlvPoint startPoint) throws IOException {
        this._flavors = flavors;
        this._manager = manager;
        this._data = SelectionTransferData.serializeSelection(this._manager, startPoint);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!flavor.equals(this._flavors[0])) {
            throw new UnsupportedFlavorException(flavor);
        }
        if (this._data != null) {
            return this._data;
        }
        return SelectionTransferData.serializeSelection(this._manager);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this._flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (int i = 0; i < this._flavors.length; ++i) {
            if (!flavor.equals(this._flavors[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        this._data = null;
    }
}

