/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.accessibility;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.framework.accessibility.NavigableGraphicPlugin;
import oracle.diagram.framework.graphic.GraphicConnector;
import oracle.diagram.framework.graphic.GraphicPin;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.manager.VisibleObjectsIterator;
import oracle.diagram.framework.selection.SubSelectionManager;
import oracle.diagram.framework.shape.SubSelectableShape;
import oracle.diagram.framework.view.ViewUtil;

public class DefaultNavigableGraphicPlugin
extends AbstractPlugin
implements NavigableGraphicPlugin {
    @Override
    public List<IlvGraphic> getNavigableChildren(IlvManager manager) {
        ArrayList<IlvGraphic> l = new ArrayList<IlvGraphic>(manager.getCardinal());
        for (IlvGraphic g : new VisibleObjectsIterator(manager)) {
            l.add(g);
        }
        return l;
    }

    @Override
    public List<IlvGraphic> getNavigableContents(IlvGraphic graphic) {
        return null;
    }

    @Override
    public List<IlvGraphic> getNavigableEnds(IlvLinkImage link) {
        ArrayList<IlvGraphic> ends = new ArrayList<IlvGraphic>(2);
        GraphicPin fromPin = GraphicPin.findPin(link, true);
        this.addNavigableEnd(fromPin == null ? link.getFrom() : fromPin.getGraphic(), ends);
        GraphicPin toPin = GraphicPin.findPin(link, false);
        this.addNavigableEnd(toPin == null ? link.getTo() : toPin.getGraphic(), ends);
        return ends;
    }

    protected void addNavigableEnd(IlvGraphic end, List<IlvGraphic> ends) {
        if (end == null) {
            return;
        }
        IlvGrapher collapsedParent = this.getCollapsedParent(end.getGraphicBag());
        if (collapsedParent != null) {
            end = collapsedParent;
        }
        if (!ends.contains(end)) {
            ends.add(end);
        }
    }

    protected IlvGrapher getCollapsedParent(IlvGraphicBag parent) {
        if (parent == null) {
            return null;
        }
        IlvGrapher parentParent = this.getCollapsedParent(parent.getGraphicBag());
        if (parentParent != null) {
            return parentParent;
        }
        if (parent instanceof IlvGrapher && ((IlvGrapher)parent).isCollapsed()) {
            return (IlvGrapher)parent;
        }
        return null;
    }

    @Override
    public List<IlvLinkImage> getNavigableLinks(IlvGraphic graphic) {
        ArrayList<IlvLinkImage> links = new ArrayList<IlvLinkImage>();
        this.getNavigableLinks(graphic, new HashSet<IlvGraphic>(), links);
        return links;
    }

    protected void getNavigableLinks(IlvGraphic graphic, Set<IlvGraphic> linkSet, ArrayList<IlvLinkImage> links) {
        IlvGrapher grapher;
        IlvLinkImage link;
        GraphicConnector connector = GraphicConnector.findConnector(graphic);
        if (connector != null) {
            Collection<GraphicPin> pins = connector.getPins();
            links.ensureCapacity(links.size() + pins.size());
            for (GraphicPin pin : pins) {
                link = pin.getLink();
                if (!link.isVisible() || !linkSet.add((IlvGraphic)link)) continue;
                links.add(pin.getLink());
            }
        } else {
            IlvGrapher grapher2;
            IlvGraphicBag bag = graphic.getGraphicBag();
            if (bag instanceof IlvGrapher && (grapher2 = (IlvGrapher)bag).isNode(graphic)) {
                IlvGraphicEnumeration e = grapher2.getLinks(graphic);
                while (e.hasMoreElements()) {
                    link = (IlvLinkImage)e.nextElement();
                    if (!link.isVisible() || !linkSet.add((IlvGraphic)link)) continue;
                    links.add(link);
                }
            }
        }
        if (graphic instanceof IlvGrapher && (grapher = (IlvGrapher)graphic).isCollapsed()) {
            IlvGraphicEnumeration e = grapher.getObjects();
            while (e.hasMoreElements()) {
                this.getNavigableLinks(e.nextElement(), linkSet, links);
            }
        }
    }

    @Override
    public IlvGraphic getNavigableParent(IlvGraphic graphic) {
        IlvGraphicBag bag = graphic.getGraphicBag();
        if (bag instanceof IlvManager) {
            return (IlvManager)bag;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void navigateTo(IlvManagerView view, IlvGraphic graphic, boolean andSelect) {
        IlvManager mgr = view.getManager();
        try {
            mgr.initReDraws();
            if (andSelect) {
                mgr.setSelectionAdjusting(true);
                SubSelectionManager.getInstance().setAdjusting(mgr, true);
                IlvGraphicBag bag = graphic.getGraphicBag();
                boolean isVisible = true;
                if (!(bag instanceof IlvManager) && bag instanceof SubSelectableShape) {
                    isVisible = ((SubSelectableShape)bag).ensureSubShapeIsVisible(graphic);
                }
                if (isVisible) {
                    mgr.deSelectAll(true, true);
                    SubSelectionManager.getInstance().deselectAll(mgr, true);
                    if (bag instanceof IlvManager) {
                        ((IlvManager)bag).setSelected(graphic, true, true);
                    } else {
                        IlvGraphic owner = ManagerUtil.getManagedAncestor(graphic);
                        if (owner instanceof SubSelectableShape) {
                            SubSelectionManager.getInstance().select(owner, graphic, true, true);
                        }
                    }
                }
            }
            ViewUtil.ensureVisible(view, graphic, true);
        }
        finally {
            if (andSelect) {
                SubSelectionManager.getInstance().setAdjusting(mgr, false);
                mgr.setSelectionAdjusting(false);
            }
            mgr.reDrawViews();
        }
    }

    @Override
    public boolean isSelectable(IlvGraphic graphic) {
        IlvGraphicBag bag = graphic.getGraphicBag();
        if (bag instanceof IlvManager && ((IlvManager)bag).isManaged(graphic)) {
            return ((IlvManager)bag).isSelectable(graphic);
        }
        if (bag instanceof SubSelectableShape) {
            SubSelectionManager.getInstance();
            return SubSelectionManager.isSelectable(graphic);
        }
        return true;
    }
}

