/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.accessibility;

import ilog.views.IlvGraphic;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import oracle.diagram.framework.accessibility.AccessibleManagerView;
import oracle.diagram.framework.accessibility.PresentableGraphicPlugin;
import oracle.diagram.framework.graphic.GraphicDescriptor;
import oracle.diagram.res.AccessibilityResources;

public abstract class AccessibleGraphic
extends AccessibleContext
implements Accessible {
    private static final ResourceBundle RB = AccessibilityResources.getBundle();
    private final AccessibleManagerView _view;
    private final IlvGraphic _graphic;
    private final AccessibleStateSet _state = new AccessibleStateSet();
    private AccessibleStateSet _lastState = null;

    protected AccessibleGraphic(AccessibleManagerView view, IlvGraphic graphic) {
        this._view = view;
        this._graphic = graphic;
        this._state.add(AccessibleState.VISIBLE);
        this._state.add(AccessibleState.FOCUSABLE);
        this._state.add(AccessibleState.ENABLED);
        this._state.add(AccessibleState.OPAQUE);
        this._state.add(AccessibleState.SHOWING);
        this._state.add(AccessibleState.TRANSIENT);
    }

    @Override
    public String getAccessibleName() {
        String name = this.getName();
        if (name != null) {
            return name;
        }
        return RB.getString("NoPresentableName.text");
    }

    @Override
    public String getAccessibleDescription() {
        return this.getName();
    }

    @Override
    public abstract Accessible getAccessibleParent();

    @Override
    public abstract int getAccessibleIndexInParent();

    @Override
    public int getAccessibleChildrenCount() {
        return 0;
    }

    @Override
    public Accessible getAccessibleChild(int i) {
        return null;
    }

    @Override
    public AccessibleRole getAccessibleRole() {
        return AccessibleRole.UNKNOWN;
    }

    @Override
    public AccessibleStateSet getAccessibleStateSet() {
        if (this.isSelected()) {
            this._state.add(AccessibleState.SELECTED);
            this._state.add(AccessibleState.ACTIVE);
            this._state.add(AccessibleState.FOCUSED);
        } else {
            this._state.remove(AccessibleState.SELECTED);
            this._state.remove(AccessibleState.ACTIVE);
            this._state.remove(AccessibleState.FOCUSED);
        }
        if (this.isSelectable()) {
            this._state.add(AccessibleState.SELECTABLE);
        } else {
            this._state.remove(AccessibleState.SELECTABLE);
        }
        boolean oldSelected = false;
        boolean newSelected = this._state.contains(AccessibleState.SELECTED);
        if (this._lastState == null) {
            oldSelected = !newSelected;
            this._lastState = new AccessibleStateSet();
        } else {
            oldSelected = this._lastState.contains(AccessibleState.SELECTED);
        }
        if (oldSelected != newSelected) {
            this._lastState.clear();
            this._lastState.addAll(this._state.toArray());
        }
        return this._state;
    }

    @Override
    public final Locale getLocale() {
        return this.getAccessibleParent().getAccessibleContext().getLocale();
    }

    @Override
    public final AccessibleContext getAccessibleContext() {
        return this;
    }

    @Override
    public AccessibleComponent getAccessibleComponent() {
        return null;
    }

    @Override
    public AccessibleSelection getAccessibleSelection() {
        return null;
    }

    @Override
    public AccessibleText getAccessibleText() {
        return null;
    }

    @Override
    public AccessibleValue getAccessibleValue() {
        return null;
    }

    protected String getName() {
        GraphicDescriptor gd;
        PresentableGraphicPlugin pgp = this.getView().getPlugin(this.getGraphic(), PresentableGraphicPlugin.class);
        if (pgp != null && (gd = pgp.getGraphicDescriptor(this.getGraphic())) != null) {
            return gd.getName();
        }
        return null;
    }

    protected abstract boolean isSelected();

    protected abstract boolean isSelectable();

    protected final AccessibleManagerView getView() {
        return this._view;
    }

    protected final IlvGraphic getGraphic() {
        return this._graphic;
    }
}

