/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.core.plugin;

import ilog.views.IlvGraphic;
import ilog.views.IlvManagerView;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.plugin.Plugin;
import oracle.diagram.core.plugin.PluginManager;
import oracle.diagram.core.plugin.RequestRouterPlugin;

public final class PluginUtil {
    private PluginUtil() {
    }

    public static final DiagramContext getPluginManager(IlvManagerView view) {
        return DiagramContext.getDiagramContext(view);
    }

    public static final <T extends Plugin> T getPlugin(IlvManagerView view, Class<T> pluginKey) {
        DiagramContext dc = DiagramContext.getDiagramContext(view);
        if (dc != null) {
            return dc.getPlugin(pluginKey);
        }
        return null;
    }

    public static final <T extends Plugin> T getPlugin(DiagramContext context, Class<T> pluginKey) {
        if (context != null) {
            return context.getPlugin(pluginKey);
        }
        return null;
    }

    public static final PluginManager getPluginManager(IlvGraphic graphic) {
        assert (graphic != null) : "Graphic cannot be null";
        return (PluginManager)graphic.getProperty(PluginManager.GRAPHIC_KEY);
    }

    public static final void setPluginManager(IlvGraphic graphic, PluginManager pluginManager) {
        graphic.setProperty(PluginManager.GRAPHIC_KEY, (Object)pluginManager);
    }

    public static final <T extends Plugin> T getPlugin(IlvManagerView view, IlvGraphic graphic, Class<T> pluginKey) {
        RequestRouterPlugin rrp = PluginUtil.getPlugin(view, RequestRouterPlugin.class);
        if (rrp != null) {
            return rrp.getPlugin(graphic, pluginKey);
        }
        return null;
    }

    public static final <T extends Plugin> T getPlugin(DiagramContext context, IlvGraphic graphic, Class<T> pluginKey) {
        RequestRouterPlugin rrp = PluginUtil.getPlugin(context, RequestRouterPlugin.class);
        if (rrp != null) {
            return rrp.getPlugin(graphic, pluginKey);
        }
        return null;
    }
}

