/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.core.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.diagram.core.plugin.Plugin;
import oracle.diagram.core.plugin.PluginManagerListener;

public class PluginManager {
    static final String GRAPHIC_KEY = PluginManager.class.getName();
    private static final PluginManagerListener[] EMPTY = new PluginManagerListener[0];
    private final Map<Class<? extends Plugin>, Plugin> _plugins = new HashMap<Class<? extends Plugin>, Plugin>();
    private final List<PluginManagerListener> _listeners = new ArrayList<PluginManagerListener>(64);
    private final Object _owner;

    public PluginManager(Object host) {
        this._owner = host;
        if (this._owner == null) {
            throw new IllegalArgumentException("Owner must not be null");
        }
    }

    public Object getHost() {
        return this._owner;
    }

    public <T extends Plugin> T addPlugin(Class<T> pluginKey, T plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin must not be null");
        }
        Plugin oldPlugin = this._plugins.get(pluginKey);
        if (oldPlugin != null) {
            this.firePluginRemoved(pluginKey, oldPlugin);
            oldPlugin.detach(this, pluginKey);
        }
        this._plugins.put(pluginKey, plugin);
        plugin.attach(this, pluginKey);
        this.firePluginAdded(pluginKey, plugin);
        if (oldPlugin != null) {
            this.firePluginReplaced(pluginKey, oldPlugin, plugin);
        }
        return (T)oldPlugin;
    }

    public <T extends Plugin> T removePlugin(Class<T> pluginKey) {
        Plugin oldPlugin = this._plugins.remove(pluginKey);
        this.firePluginRemoved(pluginKey, oldPlugin);
        oldPlugin.detach(this, pluginKey);
        return (T)oldPlugin;
    }

    public <T extends Plugin> T getPlugin(Class<T> pluginKey) {
        return (T)this._plugins.get(pluginKey);
    }

    public void dispose() {
        ArrayList<Class<? extends Plugin>> pluginTypes = new ArrayList<Class<? extends Plugin>>(this._plugins.keySet());
        for (Class clazz : pluginTypes) {
            this.removePlugin(clazz);
        }
        this._listeners.clear();
    }

    public void addPluginManagerListener(PluginManagerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this._listeners.remove(listener);
        this._listeners.add(listener);
    }

    public void removePluginManagerListener(PluginManagerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this._listeners.remove(listener);
    }

    private void firePluginAdded(Class pluginKey, Plugin plugin) {
        PluginManagerListener[] listeners = this.getListenerArray();
        for (int i = 0; i < listeners.length; ++i) {
            try {
                listeners[i].pluginAdded(this, pluginKey, plugin);
                continue;
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    private void firePluginRemoved(Class pluginKey, Plugin plugin) {
        PluginManagerListener[] listeners = this.getListenerArray();
        for (int i = 0; i < listeners.length; ++i) {
            try {
                listeners[i].pluginRemoved(this, pluginKey, plugin);
                continue;
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    private void firePluginReplaced(Class pluginKey, Plugin oldPlugin, Plugin newPlugin) {
        PluginManagerListener[] listeners = this.getListenerArray();
        for (int i = 0; i < listeners.length; ++i) {
            try {
                listeners[i].pluginReplaced(this, pluginKey, oldPlugin, newPlugin);
                continue;
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    private PluginManagerListener[] getListenerArray() {
        if (this._listeners.isEmpty()) {
            return EMPTY;
        }
        return this._listeners.toArray(new PluginManagerListener[this._listeners.size()]);
    }
}

