/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.multi;

import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import oracle.bali.inspector.multi.SelectionEvent;
import oracle.bali.inspector.multi.SelectionListener;
import oracle.bali.inspector.multi.SelectionModel;
import oracle.bali.share.event.ListenerManager;

public class ArraySelectionModel
implements SelectionModel {
    private ListenerManager _manager;
    private Vector _items;

    public ArraySelectionModel() {
        this(null);
    }

    public ArraySelectionModel(Vector selectedItems) {
        this._items = selectedItems != null ? (Vector)selectedItems.clone() : new Vector();
    }

    public final void addItem(int startIndex, Object item) {
        this.addItems(startIndex, new Object[]{item});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItems(int startIndex, Object[] items) {
        int count;
        if (items != null && (count = items.length) > 0) {
            Vector vector = this._items;
            synchronized (vector) {
                for (int i = 0; i < count; ++i) {
                    this._items.insertElementAt(items[i], startIndex + i);
                }
                this._fireSelectionEvent(0, startIndex, count);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeItems(int startIndex, int count) {
        if (count > 0) {
            Vector vector = this._items;
            synchronized (vector) {
                int lastIndex = startIndex + count - 1;
                this._fireSelectionEvent(1, startIndex, count);
                for (int i = lastIndex; i >= startIndex; --i) {
                    this._items.removeElementAt(i);
                }
                this._fireSelectionEvent(2, startIndex, count);
            }
        }
    }

    public int getSelectedItemCount() {
        return this._items.size();
    }

    public Object getSelectedItem(int index) {
        return this._items.elementAt(index);
    }

    public SelectionModel copyContents() {
        return new ArraySelectionModel(this._items);
    }

    public void addSelectionListener(SelectionListener listener) {
        if (this._manager == null) {
            this._manager = new ListenerManager();
        }
        this._manager.addListener((EventListener)listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (this._manager != null) {
            this._manager.removeListener((EventListener)listener);
        }
    }

    private void _fireSelectionEvent(int eventID, int startIndex, int itemCount) {
        if (this._manager == null) {
            return;
        }
        Enumeration e = this._manager.getListeners();
        if (e == null) {
            return;
        }
        SelectionEvent event = new SelectionEvent(this, eventID, startIndex, itemCount);
        switch (eventID) {
            case 0: {
                while (e.hasMoreElements()) {
                    SelectionListener listener = (SelectionListener)e.nextElement();
                    listener.itemsAdded(event);
                }
                break;
            }
            case 1: {
                while (e.hasMoreElements()) {
                    SelectionListener listener = (SelectionListener)e.nextElement();
                    listener.itemsRemoving(event);
                }
                break;
            }
            case 2: {
                while (e.hasMoreElements()) {
                    SelectionListener listener = (SelectionListener)e.nextElement();
                    listener.itemsRemoved(event);
                }
                break;
            }
        }
    }
}

