/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.editor;

import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.bali.inspector.editor.EditorBundle;

public class EditorFactoryUtils {
    public static void showErrorMessage(Component parent, Exception error, String invalidValue) {
        Component superParent = SwingUtilities.windowForComponent(parent);
        if (superParent == null) {
            superParent = parent;
        }
        JOptionPane.showMessageDialog(superParent, EditorFactoryUtils.errorMessage(error, invalidValue), EditorBundle.get("ERROR_TITLE"), 0);
    }

    private static String errorMessage(Exception error, String invalidValue) {
        String errorMessage = error.getLocalizedMessage();
        if (errorMessage != null && errorMessage.length() > 0) {
            int i = errorMessage.indexOf("Exception: ");
            if (i >= 0) {
                errorMessage = errorMessage.substring("Exception: ".length() + i);
            }
            return errorMessage;
        }
        if (error instanceof IllegalArgumentException) {
            return "Invalid value: '" + invalidValue + "'";
        }
        return "Unable to set value: '" + invalidValue + "'";
    }

    private EditorFactoryUtils() {
    }
}

