/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;
import oracle.bali.inspector.ActionGroup;
import oracle.bali.inspector.PropertyCategory;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.PropertyGroup;
import oracle.bali.inspector.PropertyModelListener;
import oracle.bali.inspector.PropertyModelUpdateEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyModel
extends AbstractTableModel {
    public static final String PROPERTY_DISPLAY_NAME = "targetDisplayName";
    public static final Object COLUMN_VALUE_CLASS = "Class";
    public static final Object COLUMN_NAME = "column_Name";
    public static final Object COLUMN_DISPLAY_NAME = "Name";
    public static final Object COLUMN_VALUE = "Value";
    public static final Object COLUMN_DISPLAY_VALUE = "Display Value";
    public static final Object COLUMN_DEFAULT_VALUE = "Default Value";
    public static final Object COLUMN_DEFAULT_DISPLAY_VALUE = "Default Display Value";
    public static final Object COLUMN_IS_EXPERT = "Expert";
    public static final Object COLUMN_IS_HIDDEN = "Hidden";
    public static final Object COLUMN_DESCRIPTION = "Description";
    public static final Object COLUMN_IS_READABLE = "Readable";
    public static final Object COLUMN_IS_WRITABLE = "Writable";
    public static final Object COLUMN_EDITOR_FACTORY = "Editor Factory";
    public static final Object COLUMN_EDITOR_FACTORY_2 = "Editor Factory 2";
    public static final Object COLUMN_ID = "ID";
    public static final Object COLUMN_GROUP = "Group";
    public static final Object COLUMN_CATEGORY = "Category";
    public static final Object COLUMN_LEVEL = "Level";
    public static final Object COLUMN_IS_DRILLABLE = "Drillable";
    public static final Object COLUMN_MODEL = "Model";
    public static final Object DOES_NOT_EXIST = "";
    public static final int NONEXISTENT_COLUMN = -1;
    public static final Object COLUMN_ICON = "Icon";
    public static final Object COLUMN_ICON_TOOLTIP = "IconToolTip";
    public static final Object COLUMN_HOVER_PROVIDER = "HoverProvider";
    public static final Object COLUMN_ACTIONS = "PropertyLevelActions";
    public static final Object COLUMN_VALIDATION_ISSUES = "ValidationIssues";
    public static final Object COLUMN_MANDATORY = "Mandatory";
    private final List<PropertyModelListener> listeners = new CopyOnWriteArrayList<PropertyModelListener>();
    private static final String _RESOURCE_BUNDLE = "oracle.bali.inspector.resource.InspectorBundle";
    private static final String _KEY_SHORT_ERROR = "SHORT_ERROR";
    private static final String _KEY_LONG_ERROR = "LONG_ERROR";
    private Locale _locale;
    private transient PropertyChangeSupport _propertySupport;
    private String _categoryLayoutId;
    private final Map<Object, Object> globalProperties = new HashMap<Object, Object>();

    protected PropertyModel() {
        this._locale = Locale.getDefault();
    }

    public String getHelpTopic() {
        return null;
    }

    public void addPropertyModelListener(PropertyModelListener l) {
        if (this.listeners.contains(l)) {
            return;
        }
        this.listeners.add(l);
    }

    public void removePropertyModelListener(PropertyModelListener l) {
        if (!this.listeners.contains(l)) {
            return;
        }
        this.listeners.remove(l);
    }

    protected void firePropertyModelUpdate(PropertyModelUpdateEvent event) {
        for (PropertyModelListener l : this.listeners) {
            if (l == null) continue;
            l.updatePropertyInspector(event);
        }
    }

    public Object getMatchingId(Object id) {
        int rows = this.getRowCount();
        for (int row = 0; row < rows; ++row) {
            if (!this.isMatchingPropertyID(id, row)) continue;
            return this.getPropertyID(row);
        }
        return null;
    }

    public abstract Object[] getColumnMapping();

    public abstract String getTargetDisplayName();

    public abstract void invalidateValueData();

    public int getColumnIndex(Object columnID) {
        Object[] columnIDs = this.getColumnMapping();
        for (int i = 0; i < columnIDs.length; ++i) {
            if (!columnID.equals(columnIDs[i])) continue;
            return i;
        }
        return -1;
    }

    public boolean useUnion() {
        return false;
    }

    public boolean isDataConflicting(int columnIndex, int rowIndex) {
        return false;
    }

    public boolean isPropertyCommon(int rowIndex) {
        return true;
    }

    public Object getData(Object columnID, int rowIndex) {
        int columnIndex = this.getColumnIndex(columnID);
        if (columnIndex != -1) {
            return this.getValueAt(rowIndex, columnIndex);
        }
        return DOES_NOT_EXIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyByID(int columnIndex, Object propertyID, Object data) throws Throwable {
        int propertyIDColumnIndex = this.getColumnIndex(COLUMN_ID);
        if (propertyID == null || propertyIDColumnIndex == -1) {
            return;
        }
        int numRows = this.getRowCount();
        this.startRead();
        boolean found = false;
        try {
            for (int i = 0; i < numRows; ++i) {
                if (!propertyID.equals(this.getValueAt(i, propertyIDColumnIndex))) continue;
                found = true;
                this.stopRead();
                this.setValueAt(data, i, columnIndex);
                break;
            }
        }
        finally {
            if (!found) {
                this.stopRead();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPropertyByID(int columnIndex, Object propertyID) {
        int propertyIDColumnIndex = this.getColumnIndex(COLUMN_ID);
        if (propertyIDColumnIndex == -1) {
            return DOES_NOT_EXIST;
        }
        int numRows = this.getRowCount();
        this.startRead();
        try {
            for (int i = 0; i < numRows; ++i) {
                if (!this.areEqual(this.getValueAt(i, propertyIDColumnIndex), propertyID)) continue;
                Object object = this.getValueAt(i, columnIndex);
                return object;
            }
        }
        finally {
            this.stopRead();
        }
        return DOES_NOT_EXIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPropertyIndex(Object propertyID) {
        int propertyIDColumnIndex = this.getColumnIndex(COLUMN_ID);
        int notFound = -1;
        if (propertyIDColumnIndex == -1) {
            return -1;
        }
        int numRows = this.getRowCount();
        this.startRead();
        try {
            for (int i = 0; i < numRows; ++i) {
                if (!this.areEqual(this.getValueAt(i, propertyIDColumnIndex), propertyID)) continue;
                int n = i;
                return n;
            }
        }
        finally {
            this.stopRead();
        }
        return -1;
    }

    private boolean areEqual(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public final boolean getBooleanData(int columnIndex, int rowIndex) {
        Object state = this.getValueAt(rowIndex, columnIndex);
        if (state != null) {
            return Boolean.TRUE.equals(state);
        }
        return true;
    }

    public final boolean getBooleanData(Object columnID, int rowIndex) {
        int columnIndex = this.getColumnIndex(columnID);
        if (columnIndex != -1) {
            return this.getBooleanData(columnIndex, rowIndex);
        }
        return true;
    }

    protected void setData(Object columnID, int rowIndex, Object newValue) throws Throwable {
        int columnIndex = this.getColumnIndex(columnID);
        if (columnIndex != -1) {
            this.setValueAt(newValue, rowIndex, columnIndex);
        }
    }

    public final void setPropertyValue(int rowIndex, Object newValue) throws Throwable {
        this.setData(COLUMN_VALUE, rowIndex, newValue);
    }

    public final boolean isMandatory(int rowIndex) {
        Object val = this.getData(COLUMN_MANDATORY, rowIndex);
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        return false;
    }

    public final void setMandatory(int rowIndex, boolean val) throws Throwable {
        this.setData(COLUMN_MANDATORY, rowIndex, val);
    }

    public final String getPropertyDisplayName(int rowIndex) {
        return this.getPropertyDisplayName(rowIndex, this.getLocale());
    }

    public final String getPropertyDisplayName(int rowIndex, Locale locale) {
        return (String)this.getData(COLUMN_DISPLAY_NAME, rowIndex);
    }

    public final String getPropertyName(int rowIndex) {
        return (String)this.getData(COLUMN_NAME, rowIndex);
    }

    public final PropertyEditorFactory getPropertyEditorFactory(int rowIndex) {
        Object value = this.getData(COLUMN_EDITOR_FACTORY, rowIndex);
        return value instanceof PropertyEditorFactory ? (PropertyEditorFactory)value : null;
    }

    public final PropertyEditorFactory2 getPropertyEditorFactory2(int rowIndex) {
        Object value = this.getData(COLUMN_EDITOR_FACTORY_2, rowIndex);
        return value instanceof PropertyEditorFactory2 ? (PropertyEditorFactory2)value : null;
    }

    public boolean isMatchingPropertyID(Object id, int rowIndex) {
        return id.equals(this.getPropertyID(rowIndex));
    }

    public final Object getPropertyID(int rowIndex) {
        return this.getData(COLUMN_ID, rowIndex);
    }

    public final Object getPropertyValue(int rowIndex) {
        return this.getData(COLUMN_VALUE, rowIndex);
    }

    public final List<ActionGroup> getActionGroups(int rowIndex) {
        Object data = this.getData(COLUMN_ACTIONS, rowIndex);
        if (data instanceof List) {
            return (List)data;
        }
        return Collections.emptyList();
    }

    public final Icon getIcon(int rowIndex) {
        Object value = this.getData(COLUMN_ICON, rowIndex);
        if (!(value instanceof Icon)) {
            return null;
        }
        return (Icon)value;
    }

    public final String getIconToolTip(int rowIndex) {
        Object value = this.getData(COLUMN_ICON_TOOLTIP, rowIndex);
        if (!(value instanceof String)) {
            return null;
        }
        return (String)value;
    }

    public final Object getPropertyDisplayValue(int rowIndex) {
        return this.getData(COLUMN_DISPLAY_VALUE, rowIndex);
    }

    public final String getPropertyDescription(int rowIndex) {
        return (String)this.getData(COLUMN_DESCRIPTION, rowIndex);
    }

    public final boolean isPropertyWritable(int row) {
        return this.getBooleanData(COLUMN_IS_WRITABLE, row);
    }

    public final boolean isPropertyReadable(int row) {
        return this.getBooleanData(COLUMN_IS_READABLE, row);
    }

    public final PropertyGroup getPropertyGroup(int rowIndex) {
        Object data = this.getData(COLUMN_GROUP, rowIndex);
        if (data == DOES_NOT_EXIST || !(data instanceof PropertyGroup)) {
            return null;
        }
        return (PropertyGroup)data;
    }

    public final PropertyCategory getPropertyCategory(int rowIndex) {
        Object data = this.getData(COLUMN_CATEGORY, rowIndex);
        if (data == DOES_NOT_EXIST || !(data instanceof PropertyCategory)) {
            return null;
        }
        return (PropertyCategory)data;
    }

    public final PropertyModel getPropertyModel(int rowIndex) {
        Object data = this.getData(COLUMN_MODEL, rowIndex);
        if (data == DOES_NOT_EXIST || !(data instanceof PropertyModel)) {
            return null;
        }
        return (PropertyModel)data;
    }

    public final boolean isPropertyDrillable(int rowIndex) {
        Object data = this.getData(COLUMN_IS_DRILLABLE, rowIndex);
        if (data == DOES_NOT_EXIST || !(data instanceof Boolean)) {
            return false;
        }
        return (Boolean)data;
    }

    @Override
    public int getColumnCount() {
        return this.getColumnMapping().length;
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public void setCategoryLayoutId(String categoryLayoutId) {
        this._categoryLayoutId = categoryLayoutId;
    }

    public String getCategoryLayoutId() {
        return this._categoryLayoutId;
    }

    public Enumeration getPropertyIDs() {
        int propertyIDColumnIndex = this.getColumnIndex(COLUMN_ID);
        if (propertyIDColumnIndex != -1) {
            return new PropertyIDEnumeration(propertyIDColumnIndex);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        int index = this.getColumnIndex(COLUMN_DISPLAY_VALUE);
        if (index == column) {
            return this.isPropertyWritable(row);
        }
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this._propertySupport == null) {
            this._propertySupport = new PropertyChangeSupport(this);
        }
        this._propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this._propertySupport != null) {
            this._propertySupport.removePropertyChangeListener(listener);
        }
    }

    public void dispose() {
        this.disposePropertySupport();
        this.listeners.clear();
    }

    private void disposePropertySupport() {
        if (this._propertySupport == null) {
            return;
        }
        this._propertySupport = null;
    }

    public boolean isSettable(Object oldValue, Object newValue) {
        return newValue != oldValue && (newValue == null || !newValue.equals(oldValue));
    }

    public void startRead() {
    }

    public void stopRead() {
    }

    protected void firePropertyChanged(String property, Object oldValue, Object newValue) {
        if (this._propertySupport != null) {
            this._propertySupport.firePropertyChange(property, oldValue, newValue);
        }
    }

    protected void throwIllegalArgumentException(Throwable cause, String propertyName, Object value) {
        String key = value == null ? _KEY_SHORT_ERROR : _KEY_LONG_ERROR;
        String text = this._getTranslatedString(key);
        MessageFormat form = new MessageFormat(text);
        Object[] args = value == null ? new Object[]{propertyName} : new Object[]{propertyName, value};
        throw PropertyModel.createException(cause, form.format(args));
    }

    public boolean equals(Object obj) {
        Object[] thoseColumns;
        if (null == obj) {
            return false;
        }
        if (super.equals(obj)) {
            return true;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        PropertyModel that = (PropertyModel)obj;
        if (this.getRowCount() != that.getRowCount()) {
            return false;
        }
        Object[] theseColumns = this.getColumnMapping();
        return false != Arrays.equals(theseColumns, thoseColumns = that.getColumnMapping());
    }

    private static RuntimeException createException(Throwable cause, String message) {
        if (cause != null) {
            throw new IllegalArgumentException(message, cause);
        }
        return new IllegalArgumentException(message);
    }

    private String _getTranslatedString(String key) {
        if (key == null) {
            return null;
        }
        ResourceBundle b = ResourceBundle.getBundle(_RESOURCE_BUNDLE, this.getLocale());
        return b.getString(key);
    }

    public void setGlobalProperty(Object key, Object value) {
        this.globalProperties.put(key, value);
    }

    public Object getGlobalProperty(Object key) {
        return this.globalProperties.get(key);
    }

    public Map<Object, Object> getGlobalProperties() {
        return Collections.unmodifiableMap(this.globalProperties);
    }

    public void setGlobalProperties(Map<Object, Object> properties) {
        this.globalProperties.putAll(properties);
    }

    private class PropertyIDEnumeration
    implements Enumeration {
        private int _propertyIDColumnIndex;
        private int _currRowIndex;

        public PropertyIDEnumeration(int propertyIDColumnIndex) {
            this._propertyIDColumnIndex = propertyIDColumnIndex;
        }

        public boolean hasMoreElements() {
            return this._currRowIndex < PropertyModel.this.getRowCount();
        }

        public Object nextElement() {
            return PropertyModel.this.getValueAt(this._currRowIndex++, this._propertyIDColumnIndex);
        }
    }
}

