/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.PropertyInspector;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.SwitchingCellEditor;

class PropertyEditorHandler
extends DefaultTableCellRenderer
implements TableCellEditor,
ActionListener {
    private static final String _TEAR_OFF_COMMAND = "showTearOff";
    private static final String _ADVANCED_COMMAND = "showAdvanced";
    private static final String _KEY_TOOLTIP = "ADVANCED_EDITOR_TOOLTIP";
    private static final String _KEY_TEAROFF_TOOLTIP = "TEAROFF_EDITOR_TOOLTIP";
    private JButton _advancedButton;
    private JButton _tearOffButton;
    private int _row;
    private PropertyInspector _inspector;
    private TableCellEditor _editor;
    private int _valueIndex;
    private int _factoryIndex;

    public PropertyEditorHandler(PropertyInspector inspector, TableCellEditor editor) {
        this._editor = editor;
        this._inspector = inspector;
    }

    public void setIndicies(int value, int factory) {
        this._valueIndex = value;
        this._factoryIndex = factory;
    }

    public void clear() {
        if (this._editor instanceof SwitchingCellEditor) {
            ((SwitchingCellEditor)this._editor).init();
        }
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setValue(null);
        TableCellRenderer renderer = null;
        PropertyModel model = (PropertyModel)table.getModel();
        PropertyEditorFactory editorFactory = this._getEditorFactory(model, row);
        if (editorFactory != null) {
            Object data = this._getValue(model, row);
            try {
                editorFactory.setEditorValue(data);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (editorFactory.hasValueRenderer()) {
                renderer = editorFactory.getValueRenderer();
            }
        }
        return renderer == null ? super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column) : renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        PropertyModel model = (PropertyModel)table.getModel();
        Component c = this._editor.getTableCellEditorComponent(table, value, isSelected, row, column);
        PropertyEditorFactory editorFactory = this._getEditorFactory(model, row);
        JPanel buttons = new JPanel(new BorderLayout(0, 0));
        Component tearOffButton = null;
        Component advancedButton = null;
        if (editorFactory != null) {
            Object data = this._getValue(model, row);
            try {
                editorFactory.setEditorValue(data);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (editorFactory.hasAdvancedEditor()) {
                advancedButton = this._getAdvancedButton();
                buttons.add("East", advancedButton);
            }
            if (editorFactory.hasTearOffEditor()) {
                tearOffButton = this._getTearOffButton();
                buttons.add("West", tearOffButton);
            }
        }
        final Component focus = c != null && c.isFocusTraversable() ? c : (tearOffButton != null ? tearOffButton : (advancedButton != null ? advancedButton : null));
        JPanel control = new JPanel(new BorderLayout(0, 0)){

            public void requestFocus() {
                if (focus != null) {
                    focus.requestFocus();
                } else {
                    super.requestFocus();
                }
            }

            public boolean isFocusable() {
                return false;
            }

            protected boolean processKeyBinding(KeyStroke ks, final KeyEvent e, int condition, boolean pressed) {
                if (condition != 0) {
                    return super.processKeyBinding(ks, e, condition, pressed);
                }
                if (focus != null && PropertyEditorHandler.this._row != -1) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            focus.dispatchEvent(e);
                        }
                    });
                }
                return false;
            }
        };
        control.add("Center", c);
        control.add("East", buttons);
        this._row = row;
        return control;
    }

    public Object getCellEditorValue() {
        return this._editor.getCellEditorValue();
    }

    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof InputEvent && ((InputEvent)anEvent).isConsumed()) {
            return false;
        }
        return this._editor.isCellEditable(anEvent);
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return this._editor.shouldSelectCell(anEvent);
    }

    public boolean stopCellEditing() {
        this._clear();
        return this._editor.stopCellEditing();
    }

    public void cancelCellEditing() {
        this._clear();
        this._editor.cancelCellEditing();
    }

    public void addCellEditorListener(CellEditorListener l) {
        this._editor.addCellEditorListener(l);
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this._editor.removeCellEditorListener(l);
    }

    public void paintComponent(Graphics g) {
        Rectangle r = this.getBounds();
        Color c = g.getColor();
        g.setColor(this.getBackground());
        g.fillRect(r.x, r.y, r.width, r.height);
        g.setColor(c);
        super.paintComponent(g);
    }

    private void _clear() {
        this._row = -1;
        if (this._tearOffButton != null) {
            this._tearOffButton.removeActionListener(this);
        }
        this._tearOffButton = null;
        if (this._advancedButton != null) {
            this._advancedButton.removeActionListener(this);
        }
        this._advancedButton = null;
    }

    private Object _getValue(PropertyModel model, int row) {
        if (this._valueIndex == -1) {
            this._valueIndex = model.getColumnIndex(PropertyModel.COLUMN_VALUE);
        }
        return model.getValueAt(row, this._valueIndex);
    }

    private PropertyEditorFactory _getEditorFactory(PropertyModel model, int row) {
        Object data;
        if (this._factoryIndex == -1) {
            this._factoryIndex = model.getColumnIndex(PropertyModel.COLUMN_EDITOR_FACTORY);
        }
        return (data = model.getValueAt(row, this._factoryIndex)) instanceof PropertyEditorFactory ? (PropertyEditorFactory)data : null;
    }

    private Component _getAdvancedButton() {
        if (this._advancedButton == null) {
            this._advancedButton = new JButton();
            this._advancedButton.setMargin(new Insets(2, 2, 2, 2));
            this._advancedButton.setActionCommand(_ADVANCED_COMMAND);
            this._advancedButton.addActionListener(this);
            this._advancedButton.setIcon(this._inspector.getIcon("advanced"));
            this._advancedButton.setToolTipText(this._inspector.__getTranslatedString(_KEY_TOOLTIP));
        }
        return this._advancedButton;
    }

    private Component _getTearOffButton() {
        if (this._tearOffButton == null) {
            this._tearOffButton = new JButton();
            this._tearOffButton.setMargin(new Insets(2, 2, 2, 2));
            this._tearOffButton.setActionCommand(_TEAR_OFF_COMMAND);
            this._tearOffButton.addActionListener(this);
            this._tearOffButton.setIcon(this._inspector.getIcon("tearoff"));
            this._tearOffButton.setToolTipText(this._inspector.__getTranslatedString(_KEY_TEAROFF_TOOLTIP));
        }
        return this._tearOffButton;
    }

    public void actionPerformed(ActionEvent e) {
        if (this._row == -1) {
            return;
        }
        String cmd = e.getActionCommand();
        if (_ADVANCED_COMMAND.equals(cmd)) {
            this._inspector.showAdvancedEditor(this._row);
        } else if (_TEAR_OFF_COMMAND.equals(cmd)) {
            this._inspector.showTearOffEditorPalette(this._row);
        }
    }
}

