/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import oracle.bali.inspector.PropertyModel;

public class DisplayValueRenderer
extends DefaultTableCellRenderer {
    private static TableCellRenderer _sInstance = new DisplayValueRenderer();
    private Border _noFocusBorder = new EmptyBorder(1, 2, 1, 2);

    private DisplayValueRenderer() {
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        PropertyModel model = (PropertyModel)table.getModel();
        value = model.getPropertyDisplayValue(row);
        Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (!hasFocus && c instanceof JComponent) {
            JComponent component = (JComponent)c;
            Border b = UIManager.getBorder("Table.focusCellHighlightBorder");
            Insets i = b.getBorderInsets(component);
            if (!this._noFocusBorder.getBorderInsets(component).equals(i)) {
                this._noFocusBorder = new EmptyBorder(i.top, i.left, i.bottom, i.right);
            }
            component.setBorder(this._noFocusBorder);
        }
        this.setOpaque(true);
        return c;
    }

    public static TableCellRenderer getTableCellRenderer() {
        return _sInstance;
    }

    public void paintComponent(Graphics g) {
        Rectangle r = this.getBounds();
        Color c = g.getColor();
        g.setColor(this.getBackground());
        g.fillRect(r.x, r.y, r.width, r.height);
        g.setColor(c);
        super.paintComponent(g);
    }
}

